/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.card.CardType;
import forge.card.mana.ManaCost;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardZoneTable;
import forge.game.card.CounterEnumType;
import forge.game.cost.Cost;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerController;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SacrificeEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Player activator = sa.getActivatingPlayer();
        Game game = activator.getGame();
        Card host = sa.getHostCard();
        if (sa.hasParam("Echo")) {
            boolean isPaid = activator.hasKeyword("You may pay 0 rather than pay the echo cost for permanents you control.") && activator.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblDoYouWantPayEcho", new Object[0]) + " {0}?", null) ? true : activator.getController().payManaOptional(host, new Cost(sa.getParam("Echo"), true), sa, Localizer.getInstance().getMessage("lblPayEcho", new Object[0]), PlayerController.ManaPaymentPurpose.Echo);
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(host);
            runParams.put(AbilityKey.EchoPaid, isPaid);
            game.getTriggerHandler().runTrigger(TriggerType.PayEcho, runParams, false);
            if (isPaid || !host.getController().equals(activator)) {
                return;
            }
        } else if (sa.hasParam("CumulativeUpkeep")) {
            GameEntityCounterTable table = new GameEntityCounterTable();
            host.addCounter(CounterEnumType.AGE, 1, activator, table);
            table.replaceCounterEffect(game, sa, true);
            Cost payCost = new Cost(ManaCost.ZERO, true);
            int n = host.getCounters(CounterEnumType.AGE);
            if (n > 0) {
                Cost cumCost = new Cost(sa.getParam("CumulativeUpkeep"), true);
                payCost.mergeTo(cumCost, n, sa);
            }
            game.updateLastStateForCard(host);
            StringBuilder sb = new StringBuilder();
            sb.append("Cumulative upkeep for ").append(host);
            boolean isPaid = activator.getController().payManaOptional(host, payCost, sa, sb.toString(), PlayerController.ManaPaymentPurpose.CumulativeUpkeep);
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(host);
            runParams.put(AbilityKey.CumulativeUpkeepPaid, isPaid);
            runParams.put(AbilityKey.PayingMana, StringUtils.join(sa.getPayingMana(), ""));
            game.getTriggerHandler().runTrigger(TriggerType.PayCumulativeUpkeep, runParams, false);
            if (isPaid || !host.getController().equals(activator)) {
                return;
            }
        }
        int amount = AbilityUtils.calculateAmount(host, sa.getParamOrDefault("Amount", "1"), sa);
        boolean devour = sa.isKeyword(Keyword.DEVOUR);
        boolean exploit = sa.isKeyword(Keyword.EXPLOIT);
        boolean sacEachValid = sa.hasParam("SacEachValid");
        String valid = sa.getParamOrDefault("SacValid", "Self");
        String msg = sa.getParamOrDefault("SacMessage", valid);
        msg = CardType.CoreType.isValidEnum(msg) ? msg.toLowerCase() : msg;
        boolean destroy = sa.hasParam("Destroy");
        boolean remSacrificed = sa.hasParam("RememberSacrificed");
        boolean optional = sa.hasParam("Optional");
        EnumMap<AbilityKey, Object> params = AbilityKey.newMap();
        CardZoneTable zoneMovements = AbilityKey.addCardZoneTableParams(params, sa);
        if (valid.equals("Self") && game.getZoneOf(host) != null) {
            if (host.getController().equals(activator) && game.getZoneOf(host).is(ZoneType.Battlefield) && (!optional || activator.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblDoYouWantSacrificeThis", host.getName()), null)) && game.getAction().sacrifice(new CardCollection(host), sa, true, params) != null && remSacrificed) {
                host.addRemembered(host);
            }
        } else {
            CardCollectionView choosenToSacrifice = null;
            for (Player p : SacrificeEffect.getTargetPlayers(sa)) {
                Card lKICopy;
                CardCollection battlefield = new CardCollection(p.getCardsIn(ZoneType.Battlefield));
                battlefield.removeIf(c -> !zoneMovements.getLastStateBattlefield().contains(c));
                if (sacEachValid) {
                    String[] validArray = valid.split(" & ");
                    String[] msgArray = msg.split(" & ");
                    ArrayList<CardCollection> validTargetsList = new ArrayList<CardCollection>(validArray.length);
                    for (String subValid : validArray) {
                        CardCollection validTargets = CardLists.filter((Iterable<Card>)AbilityUtils.filterListByType(battlefield, subValid, sa), CardPredicates.canBeSacrificedBy(sa, true));
                        validTargetsList.add(validTargets);
                    }
                    CardCollection chosenCards = new CardCollection();
                    for (int i = 0; i < validArray.length; ++i) {
                        CardCollection validTargets = (CardCollection)validTargetsList.get(i);
                        if (validTargets.isEmpty()) continue;
                        if (validTargets.size() > 1 && i < validArray.length - 1) {
                            this.removeCandidates(validTargets, validTargetsList, new HashSet<Card>(), i + 1, 0, amount);
                        }
                        choosenToSacrifice = p.getController().choosePermanentsToSacrifice(sa, amount, amount, validTargets, msgArray[i]);
                        for (int j = i + 1; j < validArray.length; ++j) {
                            ((CardCollection)validTargetsList.get(j)).removeAll(choosenToSacrifice);
                        }
                        chosenCards.addAll(choosenToSacrifice);
                    }
                    choosenToSacrifice = chosenCards;
                } else {
                    boolean notEnoughTargets;
                    CardCollectionView validTargets = AbilityUtils.filterListByType(battlefield, valid, sa);
                    if (!destroy) {
                        validTargets = CardLists.filter((Iterable<Card>)validTargets, CardPredicates.canBeSacrificedBy(sa, true));
                    }
                    boolean isStrict = sa.hasParam("StrictAmount");
                    int minTargets = optional && !isStrict ? 0 : amount;
                    boolean bl = notEnoughTargets = isStrict && validTargets.size() < minTargets;
                    choosenToSacrifice = sa.hasParam("Random") ? new CardCollection((Iterable<Card>)Aggregates.random(validTargets, Math.min(amount, validTargets.size()))) : (notEnoughTargets || optional && !p.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblDoYouWantSacrifice", new Object[0]), null) ? CardCollection.EMPTY : (destroy ? p.getController().choosePermanentsToDestroy(sa, minTargets, amount, validTargets, msg) : p.getController().choosePermanentsToSacrifice(sa, minTargets, amount, validTargets, msg)));
                }
                choosenToSacrifice = GameActionUtil.orderCardsByTheirOwners(game, choosenToSacrifice, ZoneType.Graveyard, sa);
                if (destroy) {
                    for (Card sac : choosenToSacrifice) {
                        lKICopy = zoneMovements.getLastStateBattlefield().get(sac);
                        if (!game.getAction().destroy(sac, sa, true, params) || !remSacrificed) continue;
                        host.addRemembered(lKICopy);
                    }
                    continue;
                }
                for (Card sac : game.getAction().sacrifice(choosenToSacrifice, sa, true, params)) {
                    lKICopy = zoneMovements.getLastStateBattlefield().get(sac);
                    if (devour) {
                        host.addDevoured(lKICopy);
                        EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
                        runParams.put(AbilityKey.Devoured, lKICopy);
                        game.getTriggerHandler().runTrigger(TriggerType.Devoured, runParams, false);
                    }
                    if (exploit) {
                        host.addExploited(lKICopy);
                        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(host);
                        runParams.put(AbilityKey.Exploited, lKICopy);
                        game.getTriggerHandler().runTrigger(TriggerType.Exploited, runParams, false);
                    }
                    if (!remSacrificed) continue;
                    host.addRemembered(lKICopy);
                }
            }
        }
        zoneMovements.triggerChangesZoneAll(game, sa);
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        PlayerCollection tgts = SacrificeEffect.getTargetPlayers(sa);
        String valid = sa.getParamOrDefault("SacValid", "Self");
        String num = sa.getParamOrDefault("Amount", "1");
        if (sa.hasParam("Optional")) {
            sb.append("(OPTIONAL) ");
        }
        int amount = AbilityUtils.calculateAmount(sa.getHostCard(), num, sa);
        if (valid.equals("Self")) {
            sb.append("Sacrifices ").append(sa.getHostCard());
        } else if (valid.equals("Card.AttachedBy")) {
            Card toSac = sa.getHostCard().getEnchantingCard();
            sb.append(toSac.getController()).append(" sacrifices ").append(toSac).append(".");
        } else {
            sb.append(Lang.joinHomogenous(tgts)).append(" ");
            boolean oneTgtP = tgts.size() == 1;
            String msg = sa.getParamOrDefault("SacMessage", valid);
            String string = msg = CardType.CoreType.isValidEnum(msg) ? msg.toLowerCase() : msg;
            if (sa.hasParam("Destroy")) {
                sb.append(oneTgtP ? "destroys " : " destroy ");
            } else {
                sb.append(oneTgtP ? "sacrifices " : "sacrifice ");
            }
            sb.append(Lang.nounWithNumeralExceptOne(amount, msg)).append(".");
        }
        return sb.toString();
    }

    private void removeCandidates(CardCollection validTargets, List<CardCollection> validTargetsList, Set<Card> union, int index, int included, int amount) {
        if (index >= validTargetsList.size()) {
            if (union.size() <= included * amount) {
                validTargets.removeAll((Collection<?>)union);
            }
            return;
        }
        this.removeCandidates(validTargets, validTargetsList, union, index + 1, included, amount);
        CardCollection candidate = validTargetsList.get(index);
        if (candidate.isEmpty()) {
            return;
        }
        if (union.isEmpty()) {
            if (candidate.size() <= amount) {
                validTargets.removeAll(candidate.asSet());
            } else {
                this.removeCandidates(validTargets, validTargetsList, candidate.asSet(), index + 1, included + 1, amount);
            }
        } else {
            HashSet<Card> unionClone = new HashSet<Card>(union);
            unionClone.addAll(candidate.asSet());
            this.removeCandidates(validTargets, validTargetsList, unionClone, index + 1, included + 1, amount);
        }
    }
}

