/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.game.trigger.WrappedAbility;
import java.util.ArrayList;

public class RunChaosEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        ArrayList<SpellAbility> validSA = Lists.newArrayList();
        for (Card c : RunChaosEffect.getTargetCards(sa)) {
            for (Trigger t2 : c.getTriggers()) {
                if (t2.getMode() != TriggerType.ChaosEnsues) continue;
                SpellAbility triggerSA = t2.ensureAbility().copy(sa.getActivatingPlayer());
                Player decider = sa.getActivatingPlayer();
                if (t2.hasParam("OptionalDecider")) {
                    sa.setOptionalTrigger(true);
                    decider = (Player)AbilityUtils.getDefinedPlayers(c, t2.getParam("OptionalDecider"), sa).get(false);
                } else if (t2.hasParam("Cost")) {
                    sa.setOptionalTrigger(true);
                }
                WrappedAbility wrapperAbility = new WrappedAbility(t2, triggerSA, decider);
                validSA.add(wrapperAbility);
            }
        }
        sa.getActivatingPlayer().getController().orderAndPlaySimultaneousSa(validSA);
    }
}

