/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.event.GameEventRollDie;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RollDiceEffect
extends SpellAbilityEffect {
    public static String makeFormatedDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        String key = "ResultSubAbilities";
        if (sa.hasParam("ResultSubAbilities")) {
            String[] diceAbilities;
            for (String ab : diceAbilities = sa.getParam("ResultSubAbilities").split(",")) {
                String[] kv = ab.split(":");
                String desc = sa.getAdditionalAbility(kv[0]).getDescription();
                if (desc.isEmpty()) continue;
                sb.append("\n").append(desc);
            }
        }
        return sb.toString();
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        PlayerCollection player = RollDiceEffect.getTargetPlayers(sa);
        if (sa.hasParam("ToVisitYourAttractions")) {
            if (player.size() == 1 && ((Player)player.get(false)).equals(sa.getActivatingPlayer())) {
                return "Roll to Visit Your Attractions.";
            }
            return String.format("%s %s to visit their Attractions.", Lang.joinHomogenous(player), Lang.joinVerb(player, "roll"));
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (player.size() == 1 && ((Player)player.get(false)).equals(sa.getActivatingPlayer())) {
            stringBuilder.append("Roll ");
        } else {
            stringBuilder.append(player).append(" rolls ");
        }
        stringBuilder.append(sa.getParamOrDefault("Amount", "a")).append(" d");
        stringBuilder.append(sa.getParamOrDefault("Sides", "6"));
        if (sa.hasParam("IgnoreLower")) {
            stringBuilder.append(" and ignore the lower roll");
        }
        stringBuilder.append(".");
        return stringBuilder.toString();
    }

    public static int rollDiceForPlayer(SpellAbility sa, Player player, int amount, int sides) {
        boolean toVisitAttractions = sa != null && sa.hasParam("ToVisitYourAttractions");
        return RollDiceEffect.rollDiceForPlayer(sa, player, amount, sides, 0, 0, null, toVisitAttractions);
    }

    public static int rollDiceForPlayerToVisitAttractions(Player player) {
        return RollDiceEffect.rollDiceForPlayer(null, player, 1, 6, 0, 0, null, true);
    }

    private static int rollDiceForPlayer(SpellAbility sa, Player player, int amount, int sides, int ignore, int modifier, List<Integer> rollsResult, boolean toVisitAttractions) {
        if (amount == 0) {
            return 0;
        }
        Map ignoreChosenMap = Maps.newHashMap();
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(player);
        repParams.put(AbilityKey.Number, amount);
        repParams.put(AbilityKey.Ignore, ignore);
        repParams.put(AbilityKey.IgnoreChosen, ignoreChosenMap);
        switch (player.getGame().getReplacementHandler().run(ReplacementType.RollDice, repParams)) {
            case NotReplaced: {
                break;
            }
            case Updated: {
                amount = (Integer)repParams.get((Object)AbilityKey.Number);
                ignore = (Integer)repParams.get((Object)AbilityKey.Ignore);
                ignoreChosenMap = (Map)repParams.get((Object)AbilityKey.IgnoreChosen);
            }
        }
        int total = 0;
        int countMaxRolls = 0;
        ArrayList<Integer> naturalRolls = rollsResult == null ? new ArrayList<Integer>() : rollsResult;
        for (int i = 0; i < amount; ++i) {
            int roll = MyRandom.getRandom().nextInt(sides) + 1;
            player.getGame().fireEvent(new GameEventRollDie());
            player.roll();
            naturalRolls.add(roll);
            total += roll;
        }
        naturalRolls.sort(null);
        ArrayList<Integer> ignored = new ArrayList<Integer>();
        if (ignore > 0) {
            for (int i = ignore - 1; i >= 0; --i) {
                total -= ((Integer)naturalRolls.get(i)).intValue();
                ignored.add((Integer)naturalRolls.get(i));
                naturalRolls.remove(i);
            }
        }
        for (Player chooser : ignoreChosenMap.keySet()) {
            for (int ig = 0; ig < (Integer)ignoreChosenMap.get(chooser); ++ig) {
                Integer ign = chooser.getController().chooseRollToIgnore(naturalRolls);
                total -= ign.intValue();
                ignored.add(ign);
                naturalRolls.remove(ign);
            }
        }
        if (amount > 0) {
            StringBuilder sb = new StringBuilder();
            String rollResults = StringUtils.join(naturalRolls, ", ");
            String resultMessage = toVisitAttractions ? "lblAttractionRollResult" : "lblPlayerRolledResult";
            sb.append(Localizer.getInstance().getMessage(resultMessage, player, rollResults));
            if (!ignored.isEmpty()) {
                sb.append("\r\n").append(Localizer.getInstance().getMessage("lblIgnoredRolls", StringUtils.join(ignored, ", ")));
            }
            player.getGame().getAction().notifyOfValue(sa, player, sb.toString(), null);
        }
        ArrayList<Integer> rolls = Lists.newArrayList();
        int oddResults = 0;
        int evenResults = 0;
        int differentResults = 0;
        for (Integer n : naturalRolls) {
            int modifiedRoll = n + modifier;
            if (!rolls.contains(modifiedRoll)) {
                ++differentResults;
            }
            rolls.add(modifiedRoll);
            if (modifiedRoll % 2 == 0) {
                ++evenResults;
            } else {
                ++oddResults;
            }
            if (n != sides) continue;
            ++countMaxRolls;
        }
        if (sa != null) {
            if (sa.hasParam("EvenOddResults")) {
                sa.setSVar("EvenResults", Integer.toString(evenResults));
                sa.setSVar("OddResults", Integer.toString(oddResults));
            }
            if (sa.hasParam("DifferentResults")) {
                sa.setSVar("DifferentResults", Integer.toString(differentResults));
            }
            if (sa.hasParam("MaxRollsResults")) {
                sa.setSVar("MaxRolls", Integer.toString(countMaxRolls));
            }
        }
        total += modifier;
        int rollNum = 1;
        for (Integer roll : rolls) {
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(player);
            runParams.put(AbilityKey.Sides, sides);
            runParams.put(AbilityKey.Modifier, modifier);
            runParams.put(AbilityKey.Result, roll);
            runParams.put(AbilityKey.RolledToVisitAttractions, toVisitAttractions);
            runParams.put(AbilityKey.Number, player.getNumRollsThisTurn() - amount + rollNum);
            player.getGame().getTriggerHandler().runTrigger(TriggerType.RolledDie, runParams, false);
            ++rollNum;
        }
        Map<AbilityKey, Object> map = AbilityKey.mapFromPlayer(player);
        map.put(AbilityKey.Sides, sides);
        map.put(AbilityKey.Result, rolls);
        map.put(AbilityKey.RolledToVisitAttractions, toVisitAttractions);
        player.getGame().getTriggerHandler().runTrigger(TriggerType.RolledDieOnce, map, false);
        return total;
    }

    private static void resolveSub(SpellAbility sa, int num) {
        Map<String, SpellAbility> diceAbilities = sa.getAdditionalAbilities();
        SpellAbility resultAbility = null;
        for (Map.Entry<String, SpellAbility> e : diceAbilities.entrySet()) {
            String diceKey = e.getKey();
            if (diceKey.contains("-")) {
                String[] ranges = diceKey.split("-");
                if (Integer.parseInt(ranges[0]) > num || Integer.parseInt(ranges[1]) < num) continue;
                resultAbility = e.getValue();
                break;
            }
            if (!StringUtils.isNumeric(diceKey) || Integer.parseInt(diceKey) != num) continue;
            resultAbility = e.getValue();
            break;
        }
        if (resultAbility != null) {
            AbilityUtils.resolve(resultAbility);
        } else if (sa.hasAdditionalAbility("Else")) {
            AbilityUtils.resolve(sa.getAdditionalAbility("Else"));
        }
    }

    private int rollDice(SpellAbility sa, Player player, int amount, int sides) {
        Card host = sa.getHostCard();
        int modifier = AbilityUtils.calculateAmount(host, sa.getParamOrDefault("Modifier", "0"), sa);
        int ignore = AbilityUtils.calculateAmount(host, sa.getParamOrDefault("IgnoreLower", "0"), sa);
        ArrayList<Integer> rolls = new ArrayList<Integer>();
        int total = RollDiceEffect.rollDiceForPlayer(sa, player, amount, sides, ignore, modifier, rolls, sa.hasParam("ToVisitYourAttractions"));
        if (sa.hasParam("UseHighestRoll")) {
            total = Collections.max(rolls);
        } else if (sa.hasParam("UseDifferenceBetweenRolls")) {
            total = Collections.max(rolls) - Collections.min(rolls);
        }
        if (sa.hasParam("StoreResults")) {
            host.addStoredRolls(rolls);
        }
        if (sa.hasParam("ResultSVar")) {
            sa.setSVar(sa.getParam("ResultSVar"), Integer.toString(total));
        }
        if (sa.hasParam("ChosenSVar")) {
            int chosen = player.getController().chooseNumber(sa, Localizer.getInstance().getMessage("lblChooseAResult", new Object[0]), rolls, player);
            String message = Localizer.getInstance().getMessage("lblPlayerChooseValue", player, chosen);
            player.getGame().getAction().notifyOfValue(sa, player, message, player);
            sa.setSVar(sa.getParam("ChosenSVar"), Integer.toString(chosen));
            if (sa.hasParam("OtherSVar")) {
                int other = (Integer)rolls.get(0);
                for (int i = 1; i < rolls.size(); ++i) {
                    if ((Integer)rolls.get(i) == chosen) continue;
                    other = (Integer)rolls.get(i);
                    break;
                }
                sa.setSVar(sa.getParam("OtherSVar"), Integer.toString(other));
            }
        }
        if (sa.hasParam("SubsForEach")) {
            for (Integer roll : rolls) {
                RollDiceEffect.resolveSub(sa, roll);
            }
        } else {
            RollDiceEffect.resolveSub(sa, total);
        }
        if (sa.hasParam("NoteDoubles")) {
            HashSet<Integer> unique = new HashSet<Integer>();
            for (Integer roll : rolls) {
                if (unique.add(roll)) continue;
                sa.setSVar("Doubles", "1");
            }
        }
        return total;
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        int amount = AbilityUtils.calculateAmount(host, sa.getParamOrDefault("Amount", "1"), sa);
        int sides = AbilityUtils.calculateAmount(host, sa.getParamOrDefault("Sides", "6"), sa);
        boolean rememberHighest = sa.hasParam("RememberHighestPlayer");
        PlayerCollection playersToRoll = RollDiceEffect.getTargetPlayers(sa);
        ArrayList<Integer> results = new ArrayList<Integer>(playersToRoll.size());
        for (Object player : playersToRoll) {
            if (sa.hasParam("RerollResults")) {
                this.rerollDice(sa, host, (Player)player, sides);
                continue;
            }
            int result = this.rollDice(sa, (Player)player, amount, sides);
            results.add(result);
            if (!sa.hasParam("ToVisitYourAttractions")) continue;
            ((Player)player).visitAttractions(result);
        }
        if (rememberHighest) {
            int highest = 0;
            for (Integer result : results) {
                if (highest >= result) continue;
                highest = result;
            }
            for (int i = 0; i < results.size(); ++i) {
                if (highest != (Integer)results.get(i)) continue;
                host.addRemembered((Player)playersToRoll.get(i));
            }
        }
    }

    private void rerollDice(SpellAbility sa, Card host, Player roller, int sides) {
        ArrayList<Integer> toReroll = Lists.newArrayList();
        for (Integer storedResult : host.getStoredRolls()) {
            if (!roller.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblRerollResult", storedResult), null)) continue;
            toReroll.add(storedResult);
        }
        HashMap<Integer, Integer> replaceMap = Maps.newHashMap();
        for (Integer old : toReroll) {
            int newRoll = this.rollDice(sa, roller, 1, sides);
            replaceMap.put(old, newRoll);
        }
        host.replaceStoredRoll(replaceMap);
    }
}

