/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import org.apache.commons.lang3.StringUtils;

public class RevealEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        boolean anyNumber = sa.hasParam("AnyNumber");
        boolean optional = sa.hasParam("Optional");
        int cnt = sa.hasParam("NumCards") ? AbilityUtils.calculateAmount(host, sa.getParam("NumCards"), sa) : 1;
        for (Player p : RevealEffect.getTargetPlayers(sa)) {
            CardCollectionView cardsInHand;
            if (!p.isInGame() || (cardsInHand = p.getCardsIn(ZoneType.Hand)).isEmpty()) continue;
            CardCollection revealed = new CardCollection();
            if (sa.hasParam("Random")) {
                CardCollection valid = new CardCollection(cardsInHand);
                if (sa.hasParam("RevealValid")) {
                    valid = CardLists.getValidCards((Iterable<Card>)valid, sa.getParam("RevealValid"), p, host, (CardTraitBase)sa);
                }
                if (valid.isEmpty()) continue;
                int revealnum = Math.min(valid.size(), cnt);
                revealed.addAll(Aggregates.random(valid, revealnum));
            } else if (sa.hasParam("RevealDefined")) {
                revealed.addAll(AbilityUtils.getDefinedCards(host, sa.getParam("RevealDefined"), sa));
            } else if (sa.hasParam("RevealAllValid")) {
                revealed.addAll(CardLists.getValidCards((Iterable<Card>)cardsInHand, sa.getParam("RevealAllValid"), p, host, (CardTraitBase)sa));
            } else {
                CardCollection valid = new CardCollection(cardsInHand);
                if (sa.hasParam("RevealValid")) {
                    valid = CardLists.getValidCards((Iterable<Card>)valid, sa.getParam("RevealValid"), p, host, (CardTraitBase)sa);
                }
                if (valid.isEmpty()) continue;
                if (cnt > valid.size()) {
                    cnt = valid.size();
                }
                int min2 = cnt;
                if (anyNumber) {
                    cnt = valid.size();
                    min2 = 0;
                } else if (optional) {
                    min2 = 0;
                }
                revealed.addAll(p.getController().chooseCardsToRevealFromHand(min2, cnt, valid));
            }
            if (sa.hasParam("RevealToAll") || sa.hasParam("Random")) {
                boolean revealTitle = sa.hasParam("RevealTitle");
                game.getAction().reveal((CardCollectionView)revealed, p, false, revealTitle ? sa.getParam("RevealTitle") : "", !revealTitle);
            } else {
                game.getAction().reveal(revealed, p);
            }
            if (!sa.hasParam("RememberRevealed")) continue;
            host.addRemembered(revealed);
        }
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        PlayerCollection tgtPlayers = RevealEffect.getTargetPlayers(sa);
        if (tgtPlayers.size() > 0) {
            sb.append(tgtPlayers.get(0)).append(" reveals ");
            if (sa.hasParam("AnyNumber")) {
                sb.append("any number of cards ");
            } else if (sa.hasParam("NumCards")) {
                int numCards = sa.getHostCard() != null ? AbilityUtils.calculateAmount(sa.getHostCard(), "NumCards", sa) : (StringUtils.isNumeric(sa.getParam("NumCards")) ? Integer.parseInt(sa.getParam("NumCards")) : 0);
                sb.append(numCards > 1 ? numCards + " cards " : "a card ");
            } else {
                sb.append("a card ");
            }
            if (sa.hasParam("Random")) {
                sb.append("at random ");
            }
            sb.append("from their hand.");
        } else {
            sb.append("Error - no target players for RevealHand. ");
        }
        return sb.toString();
    }
}

