/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameObject;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.replacement.ReplacementResult;
import forge.game.spellability.SpellAbility;
import forge.util.collect.FCollection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ReplaceSplitDamageEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card card = sa.getHostCard();
        Game game = card.getGame();
        if (!sa.isReplacementAbility()) {
            return;
        }
        String varValue = sa.getParamOrDefault("VarName", "1");
        Map originalParams = (Map)sa.getReplacingObject(AbilityKey.OriginalParams);
        Integer dmg = (Integer)sa.getReplacingObject(AbilityKey.DamageAmount);
        int prevent = AbilityUtils.calculateAmount(card, varValue, sa);
        FCollection<GameObject> list = AbilityUtils.getDefinedObjects(card, sa.getParam("DamageTarget"), sa);
        if (prevent > 0 && list.size() > 0 && list.get(0) instanceof GameEntity) {
            int n = Math.min(dmg, prevent);
            if (originalParams.get((Object)AbilityKey.DividedShieldAmount) != null) {
                n = Math.min(n, (Integer)originalParams.get((Object)AbilityKey.DividedShieldAmount));
            }
            dmg = dmg - n;
            if (card.isImmutable() && (prevent -= n) <= 0) {
                game.getAction().exileEffect(card);
            } else if (!StringUtils.isNumeric(varValue)) {
                sa.setSVar(varValue, "Number$" + prevent);
                card.updateAbilityTextForView();
            }
            GameEntity obj = (GameEntity)list.get(0);
            originalParams.put(AbilityKey.Affected, obj);
            originalParams.put(AbilityKey.DamageAmount, n);
        }
        if (dmg <= 0) {
            originalParams.put(AbilityKey.ReplacementResult, ReplacementResult.Replaced);
            return;
        }
        originalParams.put(AbilityKey.ReplacementResult, ReplacementResult.Updated);
    }
}

