/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import forge.game.GameEntity;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CounterType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.replacement.ReplacementResult;
import forge.game.spellability.SpellAbility;
import java.util.ArrayList;
import java.util.Map;

public class ReplaceCounterEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card card = sa.getHostCard();
        if (!sa.isReplacementAbility()) {
            return;
        }
        Map originalParams = (Map)sa.getReplacingObject(AbilityKey.OriginalParams);
        Map counterTable = (Map)sa.getReplacingObject(AbilityKey.CounterMap);
        if (counterTable.size() > 1 && sa.hasParam("ChooseCounter")) {
            GameEntity ge = (GameEntity)sa.getReplacingObject(AbilityKey.Object);
            Player chooser = ge instanceof Player ? (Player)ge : ((Card)ge).getController();
            HashMultimap<CounterType, Player> playerMap = HashMultimap.create();
            for (Map.Entry entry : counterTable.entrySet()) {
                for (CounterType ct : ((Map)entry.getValue()).keySet()) {
                    playerMap.put(ct, (Player)((Optional)entry.getKey()).orNull());
                }
            }
            for (Map.Entry entry : playerMap.asMap().entrySet()) {
                Optional<Player> p = Optional.fromNullable(chooser.getController().chooseSingleEntityForEffect(new PlayerCollection((Iterable)entry.getValue()), sa, "Choose Player for " + ((CounterType)entry.getKey()).getName(), null));
                sa.setReplacingObject(AbilityKey.CounterNum, ((Map)counterTable.get(p)).get(entry.getKey()));
                int value = AbilityUtils.calculateAmount(card, sa.getParam("Amount"), sa);
                if (value <= 0) {
                    ((Map)counterTable.get(p)).remove(entry.getKey());
                    continue;
                }
                ((Map)counterTable.get(p)).put((CounterType)entry.getKey(), value);
            }
        } else {
            for (Map.Entry e : counterTable.entrySet()) {
                if (!sa.matchesValidParam("ValidSource", ((Optional)e.getKey()).orNull())) continue;
                if (sa.hasParam("ValidCounterType")) {
                    CounterType ct = CounterType.getType(sa.getParam("ValidCounterType"));
                    if (!((Map)e.getValue()).containsKey(ct)) continue;
                    sa.setReplacingObject(AbilityKey.CounterNum, ((Map)e.getValue()).get(ct));
                    int value = AbilityUtils.calculateAmount(card, sa.getParam("Amount"), sa);
                    if (value <= 0) {
                        ((Map)e.getValue()).remove(ct);
                        continue;
                    }
                    ((Map)e.getValue()).put(ct, value);
                    continue;
                }
                ArrayList<CounterType> toRemove = Lists.newArrayList();
                for (Map.Entry entry : ((Map)e.getValue()).entrySet()) {
                    sa.setReplacingObject(AbilityKey.CounterNum, entry.getValue());
                    int value = AbilityUtils.calculateAmount(card, sa.getParam("Amount"), sa);
                    if (value <= 0) {
                        toRemove.add((CounterType)entry.getKey());
                        continue;
                    }
                    entry.setValue(value);
                }
                ((Map)e.getValue()).keySet().removeAll(toRemove);
            }
        }
        originalParams.put(AbilityKey.ReplacementResult, ReplacementResult.Updated);
    }
}

