/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.StaticData;
import forge.card.CardRulesPredicates;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.game.Game;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardFactory;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.item.PaperCard;
import forge.util.Aggregates;
import java.util.ArrayList;

public class PlayLandVariantEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card random;
        ColorSet color;
        Card source = sa.getHostCard();
        Player activator = sa.getActivatingPlayer();
        Game game = source.getGame();
        String landType = sa.getParam("Clone");
        ArrayList<PaperCard> cards = Lists.newArrayList(StaticData.instance().getCommonCards().getUniqueCards());
        if ("BasicLand".equals(landType)) {
            Predicate cpp = Predicates.compose(CardRulesPredicates.Presets.IS_BASIC_LAND, PaperCard::getRules);
            cards = Lists.newArrayList(Iterables.filter(cards, cpp));
        }
        if ((color = source.getColor()).isColorless()) {
            return;
        }
        ArrayList<String> landNames = Lists.newArrayList();
        for (int i = 0; i < MagicColor.WUBRG.length; i = (int)((byte)(i + 1))) {
            if (!color.hasAnyColor(MagicColor.WUBRG[i])) continue;
            landNames.add((String)MagicColor.Constant.BASIC_LANDS.get(i));
            landNames.add((String)MagicColor.Constant.SNOW_LANDS.get(i));
        }
        Predicate cp = Predicates.compose(landNames::contains, PaperCard::getName);
        cards = Lists.newArrayList(Iterables.filter(cards, cp));
        do {
            if (cards.isEmpty()) {
                return;
            }
            PaperCard ran = Aggregates.random(cards);
            random = CardFactory.getCard(ran, activator, game);
            cards.remove(ran);
        } while (!activator.canPlayLand(random, false, random.getFirstSpellAbility()));
        source.addCloneState(CardFactory.getCloneStates(random, source, sa), game.getNextTimestamp());
        source.updateStateForView();
        activator.playLandNoCheck(source, sa);
    }
}

