/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.StaticData;
import forge.card.CardRulesPredicates;
import forge.card.CardStateName;
import forge.card.GamePieceType;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardFactoryUtil;
import forge.game.card.CardZoneTable;
import forge.game.cost.Cost;
import forge.game.cost.CostDiscard;
import forge.game.cost.CostPart;
import forge.game.cost.CostReveal;
import forge.game.keyword.Keyword;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementHandler;
import forge.game.replacement.ReplacementLayer;
import forge.game.spellability.AlternativeCost;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityPredicates;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.item.PaperCard;
import forge.util.Aggregates;
import forge.util.CardTranslation;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PlayEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(sa.getActivatingPlayer().toString()).append(" ");
        if (sa.hasParam("ValidSA")) {
            sb.append(sa.hasParam("Optional") ? "may cast " : "cast ");
        } else {
            sb.append(sa.hasParam("Optional") ? "may play " : "plays ");
        }
        CardCollection tgtCards = PlayEffect.getDefinedCardsOrTargeted(sa);
        if (sa.hasParam("Valid")) {
            sb.append("cards");
        } else if (sa.hasParam("DefinedDesc")) {
            sb.append(sa.getParam("DefinedDesc"));
        } else {
            sb.append(Lang.joinHomogenous(tgtCards));
        }
        if (sa.hasParam("WithoutManaCost")) {
            sb.append(" without paying ").append(tgtCards.size() == 1 ? "its" : "their").append(" mana cost");
        }
        if (sa.hasParam("IfDesc")) {
            sb.append(" ").append(sa.getParam("IfDesc"));
        }
        sb.append(".");
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void resolve(SpellAbility sa) {
        String[] valid;
        CardCollection tgtCards;
        Card source = sa.getHostCard();
        Game game = source.getGame();
        boolean optional = sa.hasParam("Optional");
        boolean remember = sa.hasParam("RememberPlayed");
        boolean imprint = sa.hasParam("ImprintPlayed");
        boolean forget = sa.hasParam("ForgetPlayed");
        boolean hasTotalCMCLimit = sa.hasParam("WithTotalCMC");
        boolean altCost = sa.hasParam("WithoutManaCost") || sa.hasParam("PlayCost");
        int totalCMCLimit = Integer.MAX_VALUE;
        Player controller = sa.hasParam("Controller") ? (Player)AbilityUtils.getDefinedPlayers(source, sa.getParam("Controller"), sa).get(false) : sa.getActivatingPlayer();
        long controlledByTimeStamp = -1L;
        Player controlledByPlayer = null;
        if (sa.hasParam("ControlledByPlayer")) {
            controlledByTimeStamp = game.getNextTimestamp();
            controlledByPlayer = (Player)AbilityUtils.getDefinedPlayers(source, sa.getParam("ControlledByPlayer"), sa).get(false);
        }
        CardCollection cardCollection = new CardCollection();
        if (sa.hasParam("Valid")) {
            ImmutableList<ZoneType> zones = sa.hasParam("ValidZone") ? ZoneType.listValueOf(sa.getParam("ValidZone")) : ImmutableList.of(ZoneType.Hand);
            tgtCards = new CardCollection(AbilityUtils.filterListByType(game.getCardsIn(zones), sa.getParam("Valid"), sa));
            if (sa.hasParam("ShowCards")) {
                CardCollectionView cardCollectionView = AbilityUtils.filterListByType(game.getCardsIn(zones), sa.getParam("ShowCards"), sa);
            }
        } else if (sa.hasParam("AnySupportedCard")) {
            Predicate cpp;
            valid = sa.getParam("AnySupportedCard");
            ArrayList<Object> cards = null;
            if (valid.startsWith("Names:")) {
                cards = new ArrayList();
                for (String string : valid.substring(6).split(",")) {
                    String string2 = string.replace(";", ",");
                    cards.add(StaticData.instance().getCommonCards().getUniqueByName(string2));
                }
            } else if (valid.equalsIgnoreCase("sorcery")) {
                cards = Lists.newArrayList(StaticData.instance().getCommonCards().getUniqueCards());
                cpp = Predicates.compose(CardRulesPredicates.Presets.IS_SORCERY, PaperCard::getRules);
                cards = Lists.newArrayList(Iterables.filter(cards, cpp));
            } else if (valid.equalsIgnoreCase("instant")) {
                cards = Lists.newArrayList(StaticData.instance().getCommonCards().getUniqueCards());
                cpp = Predicates.compose(CardRulesPredicates.Presets.IS_INSTANT, PaperCard::getRules);
                cards = Lists.newArrayList(Iterables.filter(cards, cpp));
            }
            if (!sa.hasParam("RandomCopied")) return;
            CardCollection choice = new CardCollection();
            String num = sa.getParamOrDefault("RandomNum", "1");
            int ncopied = AbilityUtils.calculateAmount(source, num, sa);
            for (PaperCard cp : Aggregates.random(cards, ncopied)) {
                Card possibleCard = Card.fromPaperCard(cp, sa.getActivatingPlayer());
                if (sa.getActivatingPlayer().isAI() && possibleCard.getRules() != null && possibleCard.getRules().getAiHints().getRemAIDecks()) continue;
                possibleCard.setOwner(sa.getActivatingPlayer());
                choice.add(possibleCard);
            }
            if (sa.hasParam("ChoiceNum")) {
                System.err.println("Offering random spells to copy: " + choice.toString());
                int n = AbilityUtils.calculateAmount(source, sa.getParam("ChoiceNum"), sa);
                tgtCards = new CardCollection(controller.getController().chooseCardsForEffect(choice, sa, source + " - " + Localizer.getInstance().getMessage("lblChooseUpTo", new Object[0]) + " " + Lang.nounWithNumeral(n, "card"), 0, n, true, null));
            } else {
                tgtCards = choice;
            }
            System.err.println("Copying random spell(s): " + tgtCards.toString());
        } else if (sa.hasParam("CopyFromChosenName")) {
            Object name = source.getNamedCard();
            if (((String)name).trim().isEmpty() && ((String)(name = controller.getNamedCard())).trim().isEmpty()) {
                return;
            }
            Card card = Card.fromPaperCard(StaticData.instance().getCommonCards().getUniqueByName((String)name), controller);
            card.setCopiedPermanent(card);
            card.setGamePieceType(GamePieceType.TOKEN);
            card.setZone(controller.getZone(ZoneType.None));
            tgtCards = new CardCollection(card);
        } else {
            tgtCards = new CardCollection();
            for (Card c : PlayEffect.getTargetCards(sa)) {
                Card gameCard;
                if (c.equalsWithGameTimestamp(gameCard = game.getCardState(c, null))) {
                    tgtCards.add(gameCard);
                    continue;
                }
                if (!sa.hasParam("ZoneRegardless")) continue;
                tgtCards.add(c);
            }
        }
        if (tgtCards.isEmpty()) {
            return;
        }
        if (sa.hasParam("ValidSA")) {
            valid = sa.getParam("ValidSA").split(",");
            Iterator it = tgtCards.iterator();
            while (it.hasNext()) {
                Card c = (Card)it.next();
                if (Iterables.any(AbilityUtils.getBasicSpellsFromPlayEffect(c, controller), SpellAbilityPredicates.isValid(valid, controller, source, sa))) continue;
                tgtCards.asSet().remove(c);
                it.remove();
            }
            if (tgtCards.isEmpty()) {
                return;
            }
        }
        int amount = 1;
        if (sa.hasParam("Amount")) {
            amount = sa.getParam("Amount").equals("All") ? tgtCards.size() : AbilityUtils.calculateAmount(source, sa.getParam("Amount"), sa);
        }
        if (hasTotalCMCLimit) {
            totalCMCLimit = AbilityUtils.calculateAmount(source, sa.getParam("WithTotalCMC"), sa);
        }
        if (controlledByPlayer != null) {
            controller.addController(controlledByTimeStamp, controlledByPlayer);
        }
        boolean singleOption = tgtCards.size() == 1 && amount == 1 && optional;
        HashMap<String, Object> params = hasTotalCMCLimit ? new HashMap<String, Object>() : null;
        EnumMap<AbilityKey, CardCollection> moveParams = AbilityKey.newMap();
        moveParams.put(AbilityKey.LastStateBattlefield, sa.getLastStateBattlefield());
        moveParams.put(AbilityKey.LastStateGraveyard, sa.getLastStateGraveyard());
        while (!tgtCards.isEmpty() && amount > 0 && totalCMCLimit >= 0) {
            SpellAbility tgtSA;
            String prompt;
            boolean bl;
            void var16_16;
            if (hasTotalCMCLimit) {
                Iterator it = tgtCards.iterator();
                String[] stringArray = new String[]{"Spell.cmcLE" + totalCMCLimit};
                while (it.hasNext()) {
                    Card c = (Card)it.next();
                    if (Iterables.any(AbilityUtils.getBasicSpellsFromPlayEffect(c, controller), SpellAbilityPredicates.isValid(stringArray, controller, c, sa))) continue;
                    tgtCards.asSet().remove(c);
                    it.remove();
                }
                if (tgtCards.isEmpty()) break;
                params.put("CMCLimit", totalCMCLimit);
            }
            controller.getController().tempShowCards((Iterable<Card>)var16_16);
            Card tgtCard = controller.getController().chooseSingleEntityForEffect(tgtCards, sa, Localizer.getInstance().getMessage("lblSelectCardToPlay", new Object[0]), !singleOption && optional, params);
            controller.getController().endTempShowCards();
            if (tgtCard == null) break;
            boolean bl2 = false;
            if (tgtCard.isFaceDown()) {
                tgtCard.forceTurnFaceUp();
                bl = true;
            }
            if (sa.hasParam("ShowCardToActivator")) {
                game.getAction().revealTo(tgtCard, controller);
            }
            String string = prompt = sa.hasParam("CastTransformed") ? "lblDoYouWantPlayCardTransformed" : "lblDoYouWantPlayCard";
            if (singleOption && !controller.getController().confirmAction(sa, null, Localizer.getInstance().getMessage(prompt, CardTranslation.getTranslatedName(tgtCard.getName())), tgtCard, null)) {
                if (!bl) break;
                tgtCard.turnFaceDownNoUpdate();
                tgtCard.updateStateForView();
                break;
            }
            if (!sa.hasParam("AllowRepeats")) {
                tgtCards.remove(tgtCard);
            }
            if (sa.hasParam("CopyCard")) {
                Card original = tgtCard;
                Zone zone = tgtCard.getZone();
                tgtCard = Card.fromPaperCard(tgtCard.getPaperCard(), controller);
                tgtCard.setGamePieceType(GamePieceType.TOKEN);
                tgtCard.setZone(zone);
                tgtCard.setCopiedPermanent(original);
                if (zone != null) {
                    zone.add(tgtCard);
                }
            }
            CardStateName state = CardStateName.Original;
            if (sa.hasParam("CastTransformed")) {
                if (!tgtCard.changeToState(CardStateName.Transformed)) {
                    --amount;
                    System.err.println("CastTransformed failed for '" + tgtCard + "'.");
                    continue;
                }
                state = CardStateName.Transformed;
            }
            List<SpellAbility> sas = AbilityUtils.getSpellsFromPlayEffect(tgtCard, controller, state, !altCost);
            if (sa.hasParam("ValidSA")) {
                String[] valid2 = sa.getParam("ValidSA").split(",");
                sas.removeIf(sp -> !sp.isValid(valid2, controller, source, (CardTraitBase)sa));
            }
            if (hasTotalCMCLimit) {
                Iterator<SpellAbility> it = sas.iterator();
                while (it.hasNext()) {
                    SpellAbility s3 = it.next();
                    if (s3.getPayCosts().getTotalMana().getCMC() <= totalCMCLimit) continue;
                    it.remove();
                }
            }
            if (sas.isEmpty()) continue;
            if (sa.hasParam("CastFaceDown")) {
                tgtSA = CardFactoryUtil.abilityCastFaceDown(tgtCard.getCurrentState(), false, "Morph");
                tgtSA.setCastFromPlayEffect(true);
            } else {
                tgtSA = controller.getController().getAbilityToPlay(tgtCard, sas);
            }
            if (tgtSA == null) {
                if (!bl) continue;
                tgtCard.turnFaceDownNoUpdate();
                tgtCard.updateStateForView();
                continue;
            }
            CardZoneTable triggerList = new CardZoneTable(game.getLastStateBattlefield(), game.getLastStateGraveyard());
            Zone originZone = tgtCard.getZone();
            if (tgtSA.isLandAbility()) {
                Zone currentZone;
                tgtSA.resolve();
                --amount;
                if (remember) {
                    source.addRemembered(tgtCard);
                }
                if (imprint) {
                    source.addImprintedCard(tgtCard);
                }
                if (forget) {
                    source.removeRemembered(tgtCard);
                }
                if (!originZone.equals(currentZone = game.getCardState(tgtCard).getZone())) {
                    triggerList.put(originZone.getZoneType(), currentZone.getZoneType(), game.getCardState(tgtCard));
                }
                triggerList.triggerChangesZoneAll(game, sa);
                continue;
            }
            int tgtCMC = tgtSA.getPayCosts().getTotalMana().getCMC();
            if (altCost && tgtSA.costHasManaX() && tgtSA.getPayCosts().getCostMana().getXMin() > 0) continue;
            boolean unpayableCost = tgtSA.getPayCosts().getCostMana().getMana().isNoCost();
            if (sa.hasParam("WithoutManaCost")) {
                tgtSA = tgtSA.copyWithNoManaCost();
            } else if (sa.hasParam("PlayCost")) {
                Object abCost;
                String string3 = sa.getParam("PlayCost");
                if (string3.equals("ManaCost")) {
                    if (unpayableCost) continue;
                    abCost = new Cost(source.getManaCost(), false);
                } else if (string3.equals("SuspendCost")) {
                    abCost = Iterables.find(tgtCard.getNonManaAbilities(), s2 -> s2.isKeyword(Keyword.SUSPEND)).getPayCosts();
                } else {
                    void var32_48;
                    if (string3.contains("ConvertedManaCost")) {
                        if (unpayableCost) continue;
                        String costcmc = Integer.toString(tgtCard.getCMC());
                        String string4 = string3.replace("ConvertedManaCost", costcmc);
                    }
                    abCost = new Cost((String)var32_48, false);
                }
                tgtSA = tgtSA.copyWithManaCostReplaced(tgtSA.getActivatingPlayer(), (Cost)abCost);
            } else if (unpayableCost) continue;
            if (!optional) {
                for (CostPart costPart : tgtSA.getPayCosts().getCostParts()) {
                    if (!(costPart instanceof CostDiscard) && !(costPart instanceof CostReveal) || costPart.getType().equals("Card") || costPart.getType().equals("Random")) continue;
                    optional = true;
                    break;
                }
                if (!optional) {
                    tgtSA.getPayCosts().setMandatory(true);
                }
            }
            if (sa.hasParam("PlayReduceCost")) {
                String reduce = sa.getParam("PlayReduceCost");
                tgtSA.putParam("ReduceCost", reduce);
                if (!StringUtils.isNumeric(reduce)) {
                    tgtSA.setSVar(reduce, sa.getSVar(reduce));
                }
            }
            if (sa.hasParam("PlayRaiseCost")) {
                String raise = sa.getParam("PlayRaiseCost");
                tgtSA.putParam("RaiseCost", raise);
            }
            if (sa.hasParam("Madness")) {
                tgtSA.setAlternativeCost(AlternativeCost.Madness);
            }
            if (sa.hasParam("CastTransformed")) {
                tgtSA.putParam("CastTransformed", "True");
            }
            if (sa.hasParam("ManaConversion")) {
                tgtSA.putParam("ManaConversion", sa.getParam("ManaConversion"));
            }
            if (tgtSA.usesTargeting() && !optional) {
                tgtSA.getTargetRestrictions().setMandatory(true);
            }
            if (sa.hasParam("ReplaceGraveyard") && (!sa.hasParam("ReplaceGraveyardValid") || tgtSA.isValid(sa.getParam("ReplaceGraveyardValid").split(","), controller, source, (CardTraitBase)sa))) {
                PlayEffect.addReplaceGraveyardEffect(tgtCard, source, sa, tgtSA, sa.getParam("ReplaceGraveyard"));
            }
            if (sa.hasParam("ReplaceIlluMask")) {
                this.addIllusionaryMaskReplace(tgtCard, sa);
            }
            if (controlledByPlayer != null) {
                tgtSA.setControlledByPlayer(controlledByTimeStamp, controlledByPlayer);
                controller.pushPaidForSA(tgtSA);
                tgtSA.setManaCostBeingPaid(new ManaCostBeingPaid(tgtSA.getPayCosts().getCostMana().getManaCostFor(tgtSA)));
            }
            if (controller.getController().playSaFromPlayEffect(tgtSA)) {
                Zone zone;
                Card played = tgtSA.getHostCard();
                if (remember) {
                    source.addRemembered(played);
                }
                if (imprint) {
                    source.addImprintedCard(played);
                }
                if (sa.hasParam("ForgetRemembered")) {
                    source.clearRemembered();
                }
                if (forget) {
                    source.removeRemembered(tgtCard);
                }
                if (!(zone = game.getCardState(tgtCard).getZone()).equals(originZone)) {
                    triggerList.put(originZone == null ? null : originZone.getZoneType(), zone.getZoneType(), game.getCardState(tgtCard));
                }
                triggerList.triggerChangesZoneAll(game, sa);
            }
            --amount;
            totalCMCLimit -= tgtCMC;
        }
        if (controlledByPlayer == null) return;
        controller.removeController(controlledByTimeStamp);
        controller.popPaidForSA();
    }

    public static void addReplaceGraveyardEffect(Card c, Card hostCard, SpellAbility sa, SpellAbility tgtSA, String zone) {
        Game game = hostCard.getGame();
        Player controller = sa.getActivatingPlayer();
        String name = hostCard.getName() + "'s Effect";
        String image = hostCard.getImageKey();
        Card eff = PlayEffect.createEffect(sa, controller, name, image);
        eff.addRemembered(c);
        String repeffstr = "Event$ Moved | ValidCard$ Card.IsRemembered | Origin$ Stack | Destination$ Graveyard | Description$ If that card would be put into your graveyard this turn, exile it instead.";
        String effect = "DB$ ChangeZone | Defined$ ReplacedCard | Origin$ Stack | Destination$ " + zone;
        ReplacementEffect re = ReplacementHandler.parseReplacement(repeffstr, eff, true);
        re.setLayer(ReplacementLayer.Other);
        re.setOverridingAbility(AbilityFactory.getAbility(effect, eff));
        eff.addReplacementEffect(re);
        PlayEffect.addExileOnMovedTrigger(eff, "Stack");
        if (sa.isIntrinsic()) {
            eff.copyChangedTextFrom(hostCard);
        }
        game.getEndOfTurn().addUntil(PlayEffect.exileEffectCommand(game, eff));
        tgtSA.addRollbackEffect(eff);
        game.getAction().moveToCommand(eff, sa);
    }

    protected void addIllusionaryMaskReplace(Card c, SpellAbility sa) {
        Card hostCard = sa.getHostCard();
        Game game = hostCard.getGame();
        Player controller = sa.getActivatingPlayer();
        String name = hostCard + "'s Effect";
        String image = hostCard.getImageKey();
        Card eff = PlayEffect.createEffect(sa, controller, name, image);
        eff.addRemembered(c);
        String[] repeffstrs = new String[]{"Event$ AssignDealDamage | ValidCard$ Card.IsRemembered+faceDown | Description$ If the creature that spell becomes as it resolves has not been turned face up and would assign or deal damage, be dealt damage, or become tapped, instead it's turned face up and assigns or deals damage, is dealt damage, or becomes tapped.", "Event$ DealtDamage | ValidCard$ Card.IsRemembered+faceDown", "Event$ Tap | ValidCard$ Card.IsRemembered+faceDown"};
        String effect = "DB$ SetState | Defined$ ReplacedCard | Mode$ TurnFaceUp";
        for (String repStr : repeffstrs) {
            ReplacementEffect re = ReplacementHandler.parseReplacement(repStr, eff, true);
            re.putParam("ReplacementResult", "Updated");
            re.setLayer(ReplacementLayer.Other);
            re.setOverridingAbility(AbilityFactory.getAbility(effect, eff));
            eff.addReplacementEffect(re);
        }
        PlayEffect.addExileOnMovedTrigger(eff, "Battlefield");
        PlayEffect.addExileOnCounteredTrigger(eff);
        game.getAction().moveToCommand(eff, sa);
    }
}

