/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbilityCantPhase;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.EnumMap;
import java.util.Iterator;

public class PhasesEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        CardCollection tgtCards = PhasesEffect.getTargetCards(sa);
        sb.append(Lang.joinHomogenous(tgtCards));
        sb.append(tgtCards.size() == 1 ? " phases out." : " phase out.");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        CardCollectionView tgtCards;
        Player activator = sa.getActivatingPlayer();
        Game game = activator.getGame();
        Card source = sa.getHostCard();
        boolean phaseInOrOut = sa.hasParam("PhaseInOrOut");
        boolean wontPhaseInNormal = sa.hasParam("WontPhaseInNormal");
        if (sa.hasParam("AllValid")) {
            tgtCards = phaseInOrOut ? game.getCardsIncludePhasingIn(ZoneType.Battlefield) : game.getCardsIn(ZoneType.Battlefield);
            tgtCards = AbilityUtils.filterListByType(tgtCards, sa.getParam("AllValid"), sa);
        } else {
            tgtCards = PhasesEffect.getDefinedCardsOrTargeted(sa);
        }
        if (sa.hasParam("AnyNumber")) {
            tgtCards = activator.getController().chooseCardsForEffect(tgtCards, sa, Localizer.getInstance().getMessage("lblChooseAnyNumberToPhase", new Object[0]), 0, tgtCards.size(), true, null);
        }
        CardCollection phasedOut = new CardCollection();
        if (phaseInOrOut) {
            CardCollection toPhase = new CardCollection();
            for (Card tgtC : tgtCards) {
                if (tgtC.isPhasedOut() && StaticAbilityCantPhase.cantPhaseIn(tgtC) || !tgtC.isPhasedOut() && StaticAbilityCantPhase.cantPhaseOut(tgtC)) continue;
                toPhase.add(tgtC);
            }
            Iterator iterator = toPhase.iterator();
            while (iterator.hasNext()) {
                Card tgtC;
                tgtC = (Card)iterator.next();
                tgtC.phase(false);
                if (tgtC.isPhasedOut()) {
                    phasedOut.add(tgtC);
                    tgtC.setWontPhaseInNormal(wontPhaseInNormal);
                    continue;
                }
                if (sa.hasParam("Tapped")) {
                    tgtC.setTapped(true);
                } else if (sa.hasParam("Untapped")) {
                    tgtC.setTapped(false);
                }
                tgtC.setWontPhaseInNormal(false);
            }
        } else {
            for (Card tgtC : tgtCards) {
                if (tgtC.isPhasedOut() || StaticAbilityCantPhase.cantPhaseOut(tgtC)) continue;
                tgtC.phase(false);
                if (!tgtC.isPhasedOut()) continue;
                if (sa.hasParam("RememberAffected")) {
                    source.addRemembered(tgtC);
                }
                phasedOut.add(tgtC);
                tgtC.setWontPhaseInNormal(wontPhaseInNormal);
            }
        }
        if (sa.hasParam("RememberValids")) {
            source.addRemembered(tgtCards);
        }
        if (!phasedOut.isEmpty()) {
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Cards, phasedOut);
            game.getTriggerHandler().runTrigger(TriggerType.PhaseOutAll, runParams, false);
        }
    }
}

