/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Maps;
import forge.game.CardTraitBase;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.PlayerZone;
import forge.game.zone.ZoneType;
import forge.util.CardTranslation;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.HashMap;

public class PeekAndRevealEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        String who;
        Player peeker = sa.getActivatingPlayer();
        int numPeek = sa.hasParam("PeekAmount") ? AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("PeekAmount"), sa) : 1;
        String verb = sa.hasParam("NoReveal") || sa.hasParam("RevealOptional") ? " looks at " : " reveals ";
        String defined = sa.getParamOrDefault("Defined", "");
        PlayerCollection libraryPlayers = PeekAndRevealEffect.getDefinedPlayersOrTargeted(sa);
        String defString = Lang.joinHomogenous(libraryPlayers);
        String string = defined.equals("Player") && verb.equals(" reveals ") ? "Each player" : (who = sa.hasParam("NoPeek") && verb.equals(" reveals ") ? defString : "");
        String whose = defined.equals("Player") && verb.equals(" looks at ") ? "each player's" : (libraryPlayers.size() == 1 && libraryPlayers.get(0) == peeker ? "their" : defString + "'s");
        StringBuilder sb = new StringBuilder();
        sb.append(who.isEmpty() ? peeker : who);
        sb.append(verb).append("the top ");
        sb.append(numPeek > 1 ? Lang.getNumeral(numPeek) + " cards " : "card ").append("of ").append(whose);
        sb.append(" library.");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.getHostCard();
        boolean rememberRevealed = sa.hasParam("RememberRevealed");
        boolean imprintRevealed = sa.hasParam("ImprintRevealed");
        boolean noPeek = sa.hasParam("NoPeek");
        String revealValid = sa.getParamOrDefault("RevealValid", "Card");
        String peekAmount = sa.getParamOrDefault("PeekAmount", "1");
        int numPeek = AbilityUtils.calculateAmount(source, peekAmount, sa);
        ZoneType srcZone = sa.hasParam("SourceZone") ? ZoneType.smartValueOf(sa.getParam("SourceZone")) : ZoneType.Library;
        PlayerCollection srcZonePlayers = PeekAndRevealEffect.getDefinedPlayersOrTargeted(sa);
        Player peekingPlayer = sa.getActivatingPlayer();
        for (Player zoneToPeek : srcZonePlayers) {
            HashMap<Integer, Card> cachedMap;
            boolean doReveal;
            PlayerZone playerZone = zoneToPeek.getZone(srcZone);
            numPeek = Math.min(numPeek, playerZone.size());
            CardCollection peekCards = new CardCollection();
            for (int i = 0; i < numPeek; ++i) {
                peekCards.add(playerZone.get(i));
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("Revealed", peekCards);
            CardCollection revealableCards = CardLists.getValidCards((Iterable<Card>)peekCards, revealValid, peekingPlayer, source, (CardTraitBase)sa);
            boolean bl = doReveal = !sa.hasParam("NoReveal") && !revealableCards.isEmpty();
            if (!noPeek) {
                peekingPlayer.getController().reveal(peekCards, srcZone, zoneToPeek, CardTranslation.getTranslatedName(source.getName()) + " - " + Localizer.getInstance().getMessage("lblLookingCardFrom", new Object[0]));
            }
            if (doReveal && sa.hasParam("RevealOptional")) {
                doReveal = peekingPlayer.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblRevealCardToOtherPlayers", new Object[0]), params);
            }
            if (doReveal) {
                peekingPlayer.getGame().getAction().reveal((CardCollectionView)revealableCards, srcZone, zoneToPeek, !noPeek, CardTranslation.getTranslatedName(source.getName()) + " - " + Localizer.getInstance().getMessage("lblRevealingCardFrom", new Object[0]));
                if (rememberRevealed) {
                    cachedMap = Maps.newHashMap();
                    for (Card c : revealableCards) {
                        source.addRemembered(CardCopyService.getLKICopy(c, cachedMap));
                    }
                }
                if (!imprintRevealed) continue;
                cachedMap = Maps.newHashMap();
                for (Card c : revealableCards) {
                    source.addImprintedCard(CardCopyService.getLKICopy(c, cachedMap));
                }
                continue;
            }
            if (!sa.hasParam("RememberPeeked")) continue;
            cachedMap = Maps.newHashMap();
            for (Card c : revealableCards) {
                source.addRemembered(CardCopyService.getLKICopy(c, cachedMap));
            }
        }
    }
}

