/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Sets;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.util.Lang;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class LifeGainEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        String amountStr = sa.getParam("LifeAmount");
        String spellDesc = sa.getParam("SpellDescription");
        sb.append(Lang.joinHomogenous(LifeGainEffect.getDefinedPlayersOrTargeted(sa)));
        if (sb.length() == 0 && spellDesc != null) {
            return spellDesc;
        }
        sb.append(LifeGainEffect.getDefinedPlayersOrTargeted(sa).size() > 1 ? " gain " : " gains ");
        if (!StringUtils.isNumeric(amountStr) && spellDesc != null && spellDesc.contains("life equal to")) {
            sb.append(spellDesc.substring(spellDesc.indexOf("life equal to")));
        } else if (!amountStr.equals("AFLifeLost") || sa.hasSVar(amountStr)) {
            int amount = AbilityUtils.calculateAmount(sa.getHostCard(), amountStr, sa);
            sb.append(amount).append(" life.");
        } else {
            sb.append("life equal to the life lost this way.");
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        String amount = sa.getParam("LifeAmount");
        boolean variableAmount = amount.equals("AFNotDrawnNum");
        if (variableAmount) {
            amount = "X";
        }
        List<Player> tgts = LifeGainEffect.getTargetPlayersWithDuplicates(true, "Defined", sa);
        for (Player p : Sets.newHashSet(tgts)) {
            if (!p.isInGame()) continue;
            if (variableAmount) {
                sa.setSVar("AFNotDrawnNum", sa.getSVar("AFNotDrawnNum_" + p.getId()));
            }
            int lifeAmount = AbilityUtils.calculateAmount(sa.getHostCard(), amount, sa);
            p.gainLife(lifeAmount *= Collections.frequency(tgts, p), sa.getHostCard(), sa);
        }
    }
}

