/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Maps;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import java.util.HashMap;
import java.util.Map;

public class LifeExchangeEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        Player activatingPlayer = sa.getActivatingPlayer();
        PlayerCollection tgtPlayers = LifeExchangeEffect.getTargetPlayers(sa);
        if (tgtPlayers.size() == 1) {
            sb.append(activatingPlayer).append(" exchanges life totals with ");
            sb.append(tgtPlayers.get(0));
        } else if (tgtPlayers.size() > 1) {
            sb.append(tgtPlayers.get(0)).append(" exchanges life totals with ");
            sb.append(tgtPlayers.get(1));
        }
        sb.append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        int diff;
        Player p2;
        Player p1;
        Card source = sa.getHostCard();
        PlayerCollection tgtPlayers = LifeExchangeEffect.getTargetPlayers(sa);
        if (tgtPlayers.size() == 1) {
            p1 = sa.getActivatingPlayer();
            p2 = (Player)tgtPlayers.get(0);
        } else {
            p1 = (Player)tgtPlayers.get(0);
            p2 = (Player)tgtPlayers.get(1);
        }
        int life1 = p1.getLife();
        int life2 = p2.getLife();
        if (sa.hasParam("RememberDifference")) {
            int diff2 = life1 - life2;
            source.addRemembered(diff2);
        }
        HashMap<Player, Integer> lossMap = Maps.newHashMap();
        if (life1 > life2 && p1.canLoseLife() && p2.canGainLife()) {
            diff = life1 - life2;
            int lost = p1.loseLife(diff, false, false);
            p2.gainLife(diff, source, sa);
            if (lost > 0) {
                lossMap.put(p1, lost);
            }
        } else if (life2 > life1 && p2.canLoseLife() && p1.canGainLife()) {
            diff = life2 - life1;
            int lost = p2.loseLife(diff, false, false);
            p1.gainLife(diff, source, sa);
            if (lost > 0) {
                lossMap.put(p2, lost);
            }
        }
        if (!lossMap.isEmpty()) {
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromPIMap(lossMap);
            source.getGame().getTriggerHandler().runTrigger(TriggerType.LifeLostAll, runParams, false);
        }
    }
}

