/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.CardTraitBase;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.spellability.SpellAbility;
import forge.util.Lang;

public class IntensifyEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        String these = sa.hasParam("DefinedDesc") ? sa.getParam("DefinedDesc") : Lang.joinHomogenous(IntensifyEffect.getDefinedCardsOrTargeted(sa));
        int amount = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParamOrDefault("Amount", "1"), sa);
        sb.append(sa.getActivatingPlayer()).append(" perpetually increases the intensity of ").append(these);
        sb.append(" by ").append(amount).append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        int amount = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParamOrDefault("Amount", "1"), sa);
        CardCollection toIntensify = sa.hasParam("AllDefined") ? CardLists.getValidCards((Iterable<Card>)host.getGame().getCardsInGame(), sa.getParam("AllDefined"), sa.getActivatingPlayer(), host, (CardTraitBase)sa) : IntensifyEffect.getDefinedCardsOrTargeted(sa);
        for (Card tgtC : toIntensify) {
            tgtC.addIntensity(amount);
        }
    }
}

