/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardZoneTable;
import forge.game.spellability.SpellAbility;
import java.util.EnumMap;

public class HauntEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Game game;
        Card card;
        Card host = sa.getHostCard();
        if (host.isPermanent() && sa.hasTriggeringObject(AbilityKey.NewCard)) {
            host = (Card)sa.getTriggeringObject(AbilityKey.NewCard);
        }
        if ((card = (game = host.getGame()).getCardState(host, null)) == null) {
            return;
        }
        if (sa.usesTargeting() && !card.isToken() && host.equalsWithGameTimestamp(card)) {
            EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
            CardZoneTable zoneMovements = AbilityKey.addCardZoneTableParams(moveParams, sa);
            Card moved = game.getAction().exile(card, sa, moveParams);
            sa.getTargetCard().addHauntedBy(moved);
            zoneMovements.triggerChangesZoneAll(game, sa);
        } else if (!sa.usesTargeting() && card.getHaunting() != null) {
            card.getHaunting().removeHauntedBy(card);
            card.setHaunting(null);
        }
    }
}

