/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Maps;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardZoneTable;
import forge.game.card.CounterEnumType;
import forge.game.player.Player;
import forge.game.replacement.ReplacementResult;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.CardTranslation;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class ExploreEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        CardCollection tgt = ExploreEffect.getTargetCards(sa);
        sb.append(Lang.joinHomogenous(tgt));
        sb.append(" ");
        sb.append(tgt.size() > 1 ? "explore" : "explores");
        sb.append(". ");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        int amount = AbilityUtils.calculateAmount(host, sa.getParamOrDefault("Num", "1"), sa);
        CardCollectionView tgts = GameActionUtil.orderCardsByTheirOwners(game, ExploreEffect.getTargetCards(sa), ZoneType.Battlefield, sa);
        for (Card c : tgts) {
            Player pl = c.getController();
            for (int i = 0; i < amount; ++i) {
                Card gamec;
                if (game.getReplacementHandler().run(ReplacementType.Explore, AbilityKey.mapFromAffected(c)) != ReplacementResult.NotReplaced) continue;
                GameEntityCounterTable table = new GameEntityCounterTable();
                EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
                CardZoneTable triggerList = AbilityKey.addCardZoneTableParams(moveParams, sa);
                boolean revealedLand = false;
                CardCollection top = pl.getTopXCardsFromLibrary(1);
                if (!top.isEmpty()) {
                    game.getAction().reveal(top, pl, false, Localizer.getInstance().getMessage("lblRevealedForExplore", new Object[0]) + " - ");
                    Card r = (Card)top.getFirst();
                    if (r.isLand()) {
                        game.getAction().moveTo(ZoneType.Hand, r, sa, moveParams);
                        revealedLand = true;
                    } else {
                        HashMap<String, Object> params = Maps.newHashMap();
                        params.put("RevealedCard", r);
                        if (pl.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblPutThisCardToYourGraveyard", CardTranslation.getTranslatedName(r.getName())), r, params)) {
                            game.getAction().moveTo(ZoneType.Graveyard, r, sa, moveParams);
                        }
                    }
                }
                if (!revealedLand && (gamec = game.getCardState(c)).isInPlay() && gamec.equalsWithGameTimestamp(c)) {
                    c.addCounter(CounterEnumType.P1P1, 1, pl, table);
                }
                pl.addExploredThisTurn();
                Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(c);
                if (!top.isEmpty()) {
                    runParams.put(AbilityKey.Explored, top.getFirst());
                }
                game.getTriggerHandler().runTrigger(TriggerType.Explores, runParams, false);
                table.replaceCounterEffect(game, sa, true);
                triggerList.triggerChangesZoneAll(game, sa);
            }
        }
    }
}

