/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.ImageKeys;
import forge.card.CardRarity;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.IHasSVars;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.ability.effects.CountersNoteEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCopyService;
import forge.game.card.CardFactoryUtil;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementHandler;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerHandler;
import forge.game.zone.ZoneType;
import forge.util.TextUtil;
import forge.util.collect.FCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;

public class EffectEffect
extends SpellAbilityEffect {
    /*
     * WARNING - void declaration
     */
    @Override
    public void resolve(SpellAbility sa) {
        void var12_21;
        PlayerCollection effectOwner;
        String string;
        Card hostCard = sa.getHostCard();
        Game game = hostCard.getGame();
        String[] effectAbilities = null;
        String[] effectTriggers = null;
        String[] effectStaticAbilities = null;
        String[] effectReplacementEffects = null;
        FCollection<Object> rememberList = null;
        String effectImprinted = null;
        String noteCounterDefined = null;
        String duration = sa.getParam("Duration");
        if (!EffectEffect.checkValidDuration(duration, sa)) {
            return;
        }
        if (sa.hasParam("Abilities")) {
            effectAbilities = sa.getParam("Abilities").split(",");
        }
        if (sa.hasParam("Triggers")) {
            effectTriggers = sa.getParam("Triggers").split(",");
        }
        if (sa.hasParam("StaticAbilities")) {
            effectStaticAbilities = sa.getParam("StaticAbilities").split(",");
        }
        if (sa.hasParam("ReplacementEffects")) {
            effectReplacementEffects = sa.getParam("ReplacementEffects").split(",");
        }
        if (sa.hasParam("RememberSpell")) {
            rememberList = new FCollection<GameObject>();
            for (String rem : sa.getParam("RememberSpell").split(",")) {
                rememberList.addAll((Collection<Object>)AbilityUtils.getDefinedSpellAbilities(hostCard, rem, sa));
            }
        }
        if (sa.hasParam("RememberObjects")) {
            rememberList = new FCollection();
            for (String rem : sa.getParam("RememberObjects").split(",")) {
                rememberList.addAll((Collection<Object>)AbilityUtils.getDefinedEntities(hostCard, rem, (CardTraitBase)sa));
            }
            if (sa.hasParam("ForgetCounter")) {
                CounterType counterType = CounterType.getType(sa.getParam("ForgetCounter"));
                rememberList = new FCollection<Card>(CardLists.filter(Iterables.filter(rememberList, Card.class), CardPredicates.hasCounter(counterType)));
            }
            if (rememberList.isEmpty() && (sa.hasParam("ForgetOnMoved") || sa.hasParam("ExileOnMoved") || sa.hasParam("ForgetCounter") || sa.hasParam("ForgetOnPhasedIn"))) {
                return;
            }
        }
        if (sa.hasParam("RememberLKI")) {
            rememberList = new FCollection();
            for (String rem : sa.getParam("RememberLKI").split(",")) {
                CardCollection def = AbilityUtils.getDefinedCards(hostCard, rem, sa);
                for (Card c : def) {
                    rememberList.add(CardCopyService.getLKICopy(c));
                }
            }
            if (rememberList.isEmpty() && (sa.hasParam("ForgetOnMoved") || sa.hasParam("ExileOnMoved"))) {
                return;
            }
        }
        if (sa.hasParam("ImprintCards")) {
            effectImprinted = sa.getParam("ImprintCards");
        }
        if (sa.hasParam("NoteCounterDefined")) {
            noteCounterDefined = sa.getParam("NoteCounterDefined");
        }
        if ((string = sa.getParam("Name")) == null) {
            String string2 = hostCard + (sa.hasParam("Boon") ? "'s Boon" : "'s Effect");
        }
        PlayerCollection playerCollection = effectOwner = sa.hasParam("EffectOwner") ? AbilityUtils.getDefinedPlayers(hostCard, sa.getParam("EffectOwner"), sa) : new PlayerCollection(sa.getActivatingPlayer());
        if (sa.hasParam("Unique")) {
            for (Player eo : effectOwner.threadSafeIterable()) {
                if (!eo.isCardInCommand((String)var12_21)) continue;
                effectOwner.remove(eo);
            }
        }
        if (effectOwner.isEmpty()) {
            return;
        }
        String image = sa.hasParam("Image") ? ImageKeys.getTokenKey(sa.getParam("Image")) : (var12_21.startsWith("Emblem") ? ImageKeys.getTokenKey(TextUtil.fastReplace(TextUtil.fastReplace(TextUtil.fastReplace(var12_21.toLowerCase(), " \u2014 ", "_"), ",", ""), " ", "_").toLowerCase()) : hostCard.getImageKey());
        EnumMap<AbilityKey, CardCollection> params = AbilityKey.newMap();
        params.put(AbilityKey.LastStateBattlefield, sa.getLastStateBattlefield());
        params.put(AbilityKey.LastStateGraveyard, sa.getLastStateGraveyard());
        for (Player controller : effectOwner) {
            Card eff = EffectEffect.createEffect(sa, controller, (String)var12_21, image);
            eff.setSetCode(hostCard.getSetCode());
            if (var12_21.startsWith("Emblem")) {
                eff.setRarity(CardRarity.Common);
            } else {
                eff.setRarity(hostCard.getRarity());
            }
            if (effectAbilities != null) {
                for (String s2 : effectAbilities) {
                    SpellAbility grantedAbility = AbilityFactory.getAbility(eff, s2, (IHasSVars)sa);
                    eff.addSpellAbility(grantedAbility);
                    grantedAbility.setIntrinsic(true);
                }
            }
            if (effectTriggers != null) {
                for (String s2 : effectTriggers) {
                    Trigger parsedTrigger = TriggerHandler.parseTrigger(AbilityUtils.getSVar(sa, s2), eff, true, (IHasSVars)sa);
                    parsedTrigger.setActiveZone(EnumSet.of(ZoneType.Command));
                    parsedTrigger.setIntrinsic(true);
                    eff.addTrigger(parsedTrigger);
                }
            }
            if (effectStaticAbilities != null) {
                for (String s2 : effectStaticAbilities) {
                    StaticAbility addedStaticAbility = eff.addStaticAbility(AbilityUtils.getSVar(sa, s2));
                    if (addedStaticAbility == null) continue;
                    addedStaticAbility.putParam("EffectZone", "Command");
                    addedStaticAbility.setIntrinsic(true);
                }
            }
            if (effectReplacementEffects != null) {
                for (String s2 : effectReplacementEffects) {
                    String actualReplacement = AbilityUtils.getSVar(sa, s2);
                    ReplacementEffect parsedReplacement = ReplacementHandler.parseReplacement(actualReplacement, eff, true, (IHasSVars)eff.getCurrentState());
                    parsedReplacement.setActiveZone(EnumSet.of(ZoneType.Command));
                    parsedReplacement.setIntrinsic(true);
                    eff.addReplacementEffect(parsedReplacement);
                }
            }
            if (sa.hasParam("RememberKeywords")) {
                List<String> effectKeywords = Arrays.asList(sa.getParam("RememberKeywords").split(","));
                if (sa.hasParam("SharedKeywordsZone")) {
                    String[] stringArray;
                    List<ZoneType> zones = ZoneType.listValueOf(sa.getParam("SharedKeywordsZone"));
                    if (sa.hasParam("SharedRestrictions")) {
                        stringArray = sa.getParam("SharedRestrictions").split(",");
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = "Card";
                    }
                    String[] restrictions = stringArray;
                    effectKeywords = CardFactoryUtil.sharedKeywords(effectKeywords, restrictions, zones, hostCard, sa);
                }
                if (effectKeywords != null) {
                    eff.addRemembered(effectKeywords);
                }
            }
            if (rememberList != null) {
                eff.addRemembered(rememberList);
                if (sa.hasParam("ForgetOnMoved")) {
                    EffectEffect.addForgetOnMovedTrigger(eff, sa.getParam("ForgetOnMoved"));
                    if (!"Stack".equals(sa.getParam("ForgetOnMoved")) && !"False".equalsIgnoreCase(sa.getParam("ForgetOnCast"))) {
                        EffectEffect.addForgetOnCastTrigger(eff, "Card.IsRemembered");
                    }
                } else if (sa.hasParam("ExileOnMoved")) {
                    EffectEffect.addExileOnMovedTrigger(eff, sa.getParam("ExileOnMoved"));
                }
                if (sa.hasParam("ForgetOnPhasedIn")) {
                    EffectEffect.addForgetOnPhasedInTrigger(eff);
                }
                if (sa.hasParam("ForgetCounter")) {
                    EffectEffect.addForgetCounterTrigger(eff, sa.getParam("ForgetCounter"));
                }
            } else if (sa.hasParam("ForgetOnCast")) {
                EffectEffect.addForgetOnCastTrigger(eff, sa.getParam("ForgetOnCast"));
            }
            if (sa.hasParam("ExileOnLost")) {
                EffectEffect.addExileOnLostTrigger(eff);
            }
            if (sa.hasParam("ExileOnCounter")) {
                EffectEffect.addExileCounterTrigger(eff, sa.getParam("ExileOnCounter"));
            }
            if (effectImprinted != null) {
                eff.addImprintedCards(AbilityUtils.getDefinedCards(hostCard, effectImprinted, sa));
            }
            if (noteCounterDefined != null) {
                for (Card c : AbilityUtils.getDefinedCards(hostCard, noteCounterDefined, sa)) {
                    CountersNoteEffect.noteCounters(c, eff);
                }
            }
            if (hostCard.hasChosenColor()) {
                eff.setChosenColors(Lists.newArrayList(hostCard.getChosenColors()));
            }
            if (hostCard.hasChosenCard()) {
                eff.setChosenCards(hostCard.getChosenCards());
            }
            if (hostCard.hasChosenPlayer()) {
                eff.setChosenPlayer(hostCard.getChosenPlayer());
            }
            if (hostCard.hasChosenType()) {
                eff.setChosenType(hostCard.getChosenType());
            }
            if (hostCard.hasChosenType2()) {
                eff.setChosenType2(hostCard.getChosenType2());
            }
            if (hostCard.hasNamedCard()) {
                eff.setNamedCards(Lists.newArrayList(hostCard.getNamedCards()));
            }
            if (sa.hasParam("SetChosenNumber")) {
                eff.setChosenNumber(AbilityUtils.calculateAmount(hostCard, sa.getParam("SetChosenNumber"), sa));
            } else if (hostCard.hasChosenNumber()) {
                eff.setChosenNumber(hostCard.getChosenNumber());
            }
            if (sa.isIntrinsic()) {
                eff.copyChangedTextFrom(hostCard);
            }
            if (sa.hasParam("AtEOT")) {
                EffectEffect.registerDelayedTrigger(sa, sa.getParam("AtEOT"), Lists.newArrayList(hostCard));
            }
            if (duration == null || !duration.equals("Permanent")) {
                EffectEffect.addUntilCommand(sa, EffectEffect.exileEffectCommand(game, eff), controller);
            }
            if (sa.hasParam("ImprintOnHost")) {
                hostCard.addImprintedCard(eff);
            }
            game.getAction().moveToCommand(eff, sa);
        }
    }
}

