/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Sets;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbilityCantDraw;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;

public class DrawEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        PlayerCollection tgtPlayers;
        StringBuilder sb = new StringBuilder();
        if (sa.hasParam("IfDesc")) {
            if (sa.getParam("IfDesc").equals("True") && sa.hasParam("SpellDescription")) {
                String ifDesc = sa.getParam("SpellDescription");
                sb.append(ifDesc, 0, ifDesc.indexOf(",") + 1);
            } else {
                sb.append(sa.getParam("IfDesc"));
            }
            sb.append(" ");
        }
        if (!(tgtPlayers = DrawEffect.getDefinedPlayersOrTargeted(sa)).isEmpty()) {
            int numCards = sa.hasParam("NumCards") ? AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("NumCards"), sa) : 1;
            sb.append(Lang.joinHomogenous(tgtPlayers));
            if (tgtPlayers.size() > 1) {
                sb.append(" each");
            }
            sb.append(Lang.joinVerb(tgtPlayers, " draw")).append(" ");
            sb.append(sa.hasParam("NumCardsDesc") ? sa.getParam("NumCardsDesc") : (numCards == 1 ? "a card" : Lang.getNumeral(numCards) + " cards"));
            sb.append(".");
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.getHostCard();
        boolean upto = sa.hasParam("Upto");
        boolean optional = sa.hasParam("OptionalDecider") || upto;
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        moveParams.put(AbilityKey.LastStateBattlefield, sa.getLastStateBattlefield());
        moveParams.put(AbilityKey.LastStateGraveyard, sa.getLastStateGraveyard());
        List<Player> tgts = DrawEffect.getTargetPlayersWithDuplicates(true, "Defined", sa);
        for (Player p : Sets.newHashSet(tgts)) {
            if (!p.isInGame()) continue;
            int numCards = sa.hasParam("NumCards") ? AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("NumCards"), sa) : 1;
            if (optional && !upto && !p.canDrawAmount(numCards *= Collections.frequency(tgts, p)) || optional && !p.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblDoYouWantDrawCards", Lang.nounWithAmount(numCards, " card")), null)) continue;
            int actualNum = numCards;
            if (upto) {
                actualNum = StaticAbilityCantDraw.canDrawAmount(p, actualNum);
            }
            if (actualNum <= 0) continue;
            if (upto) {
                actualNum = p.getController().chooseNumber(sa, Localizer.getInstance().getMessage("lblHowManyCardDoYouWantDraw", new Object[0]), 0, actualNum);
            }
            CardCollectionView drawn = p.drawCards(actualNum, sa, moveParams);
            if (sa.hasParam("Reveal")) {
                p.getGame().getAction().reveal(drawn, p, !sa.getParam("Reveal").equals("All"));
            }
            if (sa.hasParam("RememberDrawn")) {
                source.addRemembered(drawn);
            }
            sa.setSVar("AFNotDrawnNum_" + p.getId(), "Number$" + drawn.size());
        }
    }
}

