/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.StaticData;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardZoneTable;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;

public class DraftEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        Card source = sa.getHostCard();
        Player player = (Player)AbilityUtils.getDefinedPlayers(source, sa.getParam("Defined"), sa).get(false);
        ZoneType zone = ZoneType.smartValueOf(sa.getParamOrDefault("Zone", "Hand"));
        StringBuilder sb = new StringBuilder();
        sb.append(player).append(" drafts a card from ").append(source.getName()).append("'s spellbook");
        if (zone.equals((Object)ZoneType.Hand)) {
            sb.append(".");
        } else if (zone.equals((Object)ZoneType.Battlefield)) {
            sb.append(" and puts it onto the battlefield.");
        } else if (zone.equals((Object)ZoneType.Exile)) {
            sb.append(sa.hasParam("ExileFaceDown") ? " and exiles it face down." : ", then exiles it.");
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        moveParams.put(AbilityKey.LastStateBattlefield, sa.getLastStateBattlefield());
        moveParams.put(AbilityKey.LastStateGraveyard, sa.getLastStateGraveyard());
        Card source = sa.getHostCard();
        Player player = (Player)AbilityUtils.getDefinedPlayers(source, sa.getParam("Defined"), sa).get(false);
        Game game = player.getGame();
        ZoneType zone = ZoneType.smartValueOf(sa.getParamOrDefault("Zone", "Hand"));
        List<String> spellbook = Arrays.asList(sa.getParamOrDefault("Spellbook", "").split(","));
        int numToDraft = AbilityUtils.calculateAmount(source, sa.getParamOrDefault("DraftNum", "1"), sa);
        CardCollection drafted = new CardCollection();
        for (int i = 0; i < numToDraft; ++i) {
            Collections.shuffle(spellbook);
            ArrayList<Card> draftOptions = new ArrayList<Card>();
            for (String name : spellbook.subList(0, 3)) {
                name = name.replace(";", ",");
                Card cardOption = Card.fromPaperCard(StaticData.instance().getCommonCards().getUniqueByName(name), player);
                cardOption.setTokenCard(true);
                draftOptions.add(cardOption);
            }
            Card chosenCard = player.getController().chooseSingleCardForZoneChange(ZoneType.None, new ArrayList<ZoneType>(), sa, new CardCollection((Iterable<Card>)draftOptions), null, Localizer.getInstance().getMessage("lblChooseCardDraft", new Object[0]), false, player);
            game.getAction().moveTo(ZoneType.None, chosenCard, sa, moveParams);
            drafted.add(chosenCard);
        }
        CardZoneTable triggerList = new CardZoneTable();
        for (Card c : drafted) {
            if (zone.equals((Object)ZoneType.Exile) && !c.canExiledBy(sa, true)) continue;
            Card made = game.getAction().moveTo(zone, c, sa, moveParams);
            if (zone.equals((Object)ZoneType.Exile)) {
                DraftEffect.handleExiledWith(made, sa);
                if (sa.hasParam("ExileFaceDown")) {
                    made.turnFaceDown(true);
                }
            }
            if (c != null) {
                triggerList.put(ZoneType.None, made.getZone().getZoneType(), made);
            }
            if (!sa.hasParam("RememberDrafted")) continue;
            source.addRemembered(made);
        }
        triggerList.triggerChangesZoneAll(game, sa);
        if (zone.equals((Object)ZoneType.Library)) {
            player.shuffle(sa);
        }
    }
}

