/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Maps;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardZoneTable;
import forge.game.event.GameEventCombatChanged;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.PlayerZone;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.MyRandom;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;

public class DigUntilEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        String desc = sa.getParamOrDefault("ValidDescription", "Card");
        int untilAmount = 1;
        boolean isNumeric = true;
        if (sa.hasParam("Amount")) {
            isNumeric = StringUtils.isNumeric(sa.getParam("Amount"));
            untilAmount = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("Amount"), sa);
        }
        sb.append(Lang.joinHomogenous(DigUntilEffect.getTargetPlayers(sa)));
        ZoneType revealed = ZoneType.smartValueOf(sa.getParam("RevealedDestination"));
        sb.append(ZoneType.Exile.equals((Object)revealed) ? "exiles cards from their library until they exile " : "reveals cards from their library until revealing ");
        String noun = "Card".equals(desc) ? " card" : desc + " card";
        sb.append(isNumeric ? Lang.nounWithNumeralExceptOne(untilAmount, noun) : "X " + noun);
        if (untilAmount != 1) {
            sb.append("s");
        }
        if (sa.hasParam("MaxRevealed")) {
            untilAmount = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("MaxRevealed"), sa);
            sb.append(" or ").append(untilAmount).append(" card/s");
        }
        sb.append(".");
        if (!sa.hasParam("NoPutDesc")) {
            sb.append(" Put ");
            ZoneType found = ZoneType.smartValueOf(sa.getParam("FoundDestination"));
            if (found != null) {
                sb.append(untilAmount > 1 || !isNumeric ? "those cards" : "that card");
                sb.append(" ");
                if (ZoneType.Hand.equals((Object)found)) {
                    sb.append("into their hand ");
                }
                if (ZoneType.Battlefield.equals((Object)found)) {
                    sb.append("onto the battlefield ");
                    if (sa.hasParam("Tapped")) {
                        sb.append("tapped ");
                    }
                }
                if (ZoneType.Graveyard.equals((Object)revealed)) {
                    sb.append("and all other cards into their graveyard.");
                }
                if (ZoneType.Exile.equals((Object)revealed)) {
                    sb.append("and exile all other cards revealed this way.");
                }
                if (ZoneType.Library.equals((Object)revealed)) {
                    int revealedLibPos = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("RevealedLibraryPosition"), sa);
                    sb.append("and the rest on ").append(revealedLibPos < 0 ? "the bottom " : "on top ");
                    sb.append("of their library").append(sa.hasParam("RevealRandomOrder") ? " in a random order." : ".");
                }
            } else if (revealed != null && ZoneType.Hand.equals((Object)revealed)) {
                sb.append("all cards revealed this way into their hand");
            }
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        int untilAmount = 1;
        if (sa.hasParam("Amount") && (untilAmount = AbilityUtils.calculateAmount(host, sa.getParam("Amount"), sa)) == 0) {
            return;
        }
        Integer maxRevealed = null;
        if (sa.hasParam("MaxRevealed")) {
            maxRevealed = AbilityUtils.calculateAmount(host, sa.getParam("MaxRevealed"), sa);
        }
        String[] type = new String[]{"Card"};
        if (sa.hasParam("Valid")) {
            type = sa.getParam("Valid").split(",");
        }
        boolean remember = sa.hasParam("RememberFound");
        boolean imprint = sa.hasParam("ImprintFound");
        ZoneType foundDest = ZoneType.smartValueOf(sa.getParam("FoundDestination"));
        ZoneType optionalNoDestination = ZoneType.smartValueOf(sa.getParamOrDefault("OptionalNoDestination", "None"));
        int foundLibPos = AbilityUtils.calculateAmount(host, sa.getParam("FoundLibraryPosition"), sa);
        ZoneType revealedDest = ZoneType.smartValueOf(sa.getParam("RevealedDestination"));
        int revealedLibPos = AbilityUtils.calculateAmount(host, sa.getParam("RevealedLibraryPosition"), sa);
        ZoneType noneFoundDest = ZoneType.smartValueOf(sa.getParam("NoneFoundDestination"));
        int noneFoundLibPos = AbilityUtils.calculateAmount(host, sa.getParam("NoneFoundLibraryPosition"), sa);
        ZoneType digSite = sa.hasParam("DigZone") ? ZoneType.smartValueOf(sa.getParam("DigZone")) : ZoneType.Library;
        boolean shuffle = sa.hasParam("Shuffle");
        boolean optional = sa.hasParam("Optional");
        boolean optionalFound = sa.hasParam("OptionalFoundMove");
        boolean sequential = digSite == ZoneType.Library && revealedDest != null && revealedDest.equals((Object)foundDest);
        CardZoneTable table = new CardZoneTable(game.copyLastStateBattlefield(), game.copyLastStateGraveyard());
        CardZoneTable tableSeq = null;
        if (!sequential) {
            tableSeq = new CardZoneTable(table.getLastStateBattlefield(), table.getLastStateGraveyard());
        }
        boolean combatChanged = false;
        for (Player p : DigUntilEffect.getTargetPlayers(sa)) {
            EnumMap<AbilityKey, Object> moveParams;
            Card c;
            if (p == null || !p.isInGame() || optional && !p.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblDoYouWantDigYourLibrary", new Object[0]), null)) continue;
            CardCollection found = new CardCollection();
            CardCollection revealed = new CardCollection();
            PlayerZone library = p.getZone(digSite);
            int maxToDig = maxRevealed != null ? maxRevealed.intValue() : library.size();
            for (int i = 0; i < maxToDig; ++i) {
                c = library.get(i);
                revealed.add(c);
                if (!c.isValid(type, sa.getActivatingPlayer(), host, (CardTraitBase)sa)) continue;
                found.add(c);
                if (sa.hasParam("ForgetOtherRemembered")) {
                    host.clearRemembered();
                }
                if (remember) {
                    host.addRemembered(c);
                }
                if (imprint) {
                    host.addImprintedCard(c);
                }
                if (found.size() == untilAmount) break;
            }
            if (shuffle && sa.hasParam("ShuffleCondition") && sa.getParam("ShuffleCondition").equals("NoneFound")) {
                shuffle = found.isEmpty();
            }
            if (revealed.size() > 0) {
                game.getAction().reveal(revealed, p, false);
            }
            if (foundDest != null) {
                Iterator itr = sequential ? revealed.iterator() : found.iterator();
                while (itr.hasNext()) {
                    c = (Card)itr.next();
                    if (optionalFound && !p.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblDoYouWantPutCardToZone", foundDest.getTranslatedName()), null)) {
                        if (ZoneType.None.equals((Object)optionalNoDestination)) {
                            itr.remove();
                            continue;
                        }
                        foundDest = optionalNoDestination;
                    }
                    if (sequential) {
                        tableSeq = new CardZoneTable(table.getLastStateBattlefield(), table.getLastStateGraveyard());
                    }
                    moveParams = AbilityKey.newMap();
                    AbilityKey.addCardZoneTableParams(moveParams, tableSeq);
                    if (foundDest.equals((Object)ZoneType.Battlefield)) {
                        moveParams.put(AbilityKey.SimultaneousETB, (Object)new CardCollection(c));
                        if (sa.hasParam("GainControl")) {
                            c.setController(sa.getActivatingPlayer(), game.getNextTimestamp());
                        }
                        if (sa.hasParam("AttachedTo")) {
                            CardCollection list = AbilityUtils.getDefinedCards(c, sa.getParam("AttachedTo"), sa);
                            if (list.isEmpty()) {
                                list = CardLists.getValidCards((Iterable<Card>)table.getLastStateBattlefield(), sa.getParam("AttachedTo"), c.getController(), c, (CardTraitBase)sa);
                            }
                            if (!list.isEmpty()) {
                                list = CardLists.filter((Iterable<Card>)list, CardPredicates.canBeAttached(c, sa));
                            }
                            if (!list.isEmpty()) {
                                HashMap<String, Object> params = Maps.newHashMap();
                                params.put("Attach", c);
                                Card attachedTo = p.getController().chooseSingleEntityForEffect(list, sa, Localizer.getInstance().getMessage("lblSelectACardAttachSourceTo", c.toString()), params);
                                c.attachToEntity(game.getCardState(attachedTo), sa, true);
                            } else if (c.isAura()) continue;
                        }
                        if (sa.hasParam("Tapped")) {
                            c.setTapped(true);
                        }
                        game.getAction().moveTo(foundDest, c, sa, moveParams);
                        if (DigUntilEffect.addToCombat(c, sa, "Attacking", "Blocking")) {
                            combatChanged = true;
                        }
                    } else if (!sa.hasParam("NoMoveFound")) {
                        game.getAction().moveTo(foundDest, c, foundLibPos, sa, moveParams);
                    }
                    if (!sequential) continue;
                    tableSeq.triggerChangesZoneAll(game, sa);
                }
                revealed.removeAll(found);
            }
            if (sa.hasParam("RememberRevealed")) {
                host.addRemembered(revealed);
            }
            if (sa.hasParam("ImprintRevealed")) {
                host.addImprintedCards(revealed);
            }
            if (sa.hasParam("RevealRandomOrder")) {
                Collections.shuffle(revealed, MyRandom.getRandom());
            }
            if (!sa.hasParam("NoMoveRevealed") && !sequential) {
                ZoneType finalDest = revealedDest;
                int finalPos = revealedLibPos;
                if (sa.hasParam("NoneFoundDestination") && found.size() < untilAmount) {
                    finalDest = noneFoundDest;
                    finalPos = noneFoundLibPos;
                }
                if (finalDest.isKnown() && revealed.size() >= 2) {
                    revealed = (CardCollection)p.getController().orderMoveToZoneList(revealed, finalDest, sa);
                }
                if (finalDest == ZoneType.Library && !shuffle && !sa.hasParam("RevealRandomOrder") && revealed.size() >= 2) {
                    revealed = (CardCollection)p.getController().orderMoveToZoneList(revealed, finalDest, sa);
                }
                moveParams = AbilityKey.newMap();
                AbilityKey.addCardZoneTableParams(moveParams, table);
                for (Card c2 : revealed) {
                    game.getAction().moveTo(finalDest, c2, finalPos, sa, moveParams);
                }
            }
            if (!shuffle) continue;
            p.shuffle(sa);
        }
        if (combatChanged) {
            game.updateCombatForView();
            game.fireEvent(new GameEventCombatChanged());
        }
        if (!sequential) {
            tableSeq.triggerChangesZoneAll(game, sa);
        }
        table.triggerChangesZoneAll(game, sa);
    }
}

