/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.GameCommand;
import forge.card.MagicColor;
import forge.game.Game;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordInterface;
import forge.game.spellability.SpellAbility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;

public class DebuffEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        ArrayList<String> kws = Lists.newArrayList();
        if (sa.hasParam("Keywords")) {
            kws.addAll(Arrays.asList(sa.getParam("Keywords").split(" & ")));
        }
        StringBuilder sb = new StringBuilder();
        CardCollection tgtCards = DebuffEffect.getTargetCards(sa);
        if (tgtCards.size() > 0) {
            Iterator it = tgtCards.iterator();
            while (it.hasNext()) {
                Card tgtC = (Card)it.next();
                if (tgtC.isFaceDown()) {
                    sb.append("Morph");
                } else {
                    sb.append(tgtC);
                }
                if (!it.hasNext()) continue;
                sb.append(" ");
            }
            sb.append(" loses ");
            sb.append(kws);
            if (!"Permanent".equals(sa.getParam("Duration"))) {
                sb.append(" until end of turn");
            }
            sb.append(".");
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        ArrayList<String> kws = Lists.newArrayList();
        if (sa.hasParam("Keywords")) {
            kws.addAll(Arrays.asList(sa.getParam("Keywords").split(" & ")));
        }
        Game game = sa.getActivatingPlayer().getGame();
        final long timestamp = game.getNextTimestamp();
        for (final Card tgtC : DebuffEffect.getTargetCards(sa)) {
            String colString;
            Card gameCard;
            if (!tgtC.isInPlay() || tgtC.isPhasedOut() || (gameCard = game.getCardState(tgtC, null)) == null || !tgtC.equalsWithGameTimestamp(gameCard)) continue;
            ArrayList<String> addedKW = Lists.newArrayList();
            ArrayList<String> removedKW = Lists.newArrayList();
            if (sa.hasParam("AllSuffixKeywords") && sa.getParam("AllSuffixKeywords").equals("walk")) {
                for (KeywordInterface keywordInterface : tgtC.getKeywords(Keyword.LANDWALK)) {
                    removedKW.add(keywordInterface.getOriginal());
                }
            }
            boolean ProtectionFromColor = false;
            for (String kw3 : kws) {
                if (!kw3.startsWith("Protection from ")) continue;
                for (byte col : MagicColor.WUBRG) {
                    colString = MagicColor.toLongString(col);
                    if (!kw3.endsWith(colString)) continue;
                    String wardString = StringUtils.capitalize(colString) + ":" + colString;
                    for (KeywordInterface inst : tgtC.getKeywords(Keyword.PROTECTION)) {
                        String keyword = inst.getOriginal();
                        if (!keyword.startsWith("Protection:") || !keyword.contains(wardString)) continue;
                        removedKW.add(keyword);
                    }
                }
                ProtectionFromColor = true;
            }
            if (ProtectionFromColor) {
                String string;
                ArrayList<String> allColorsProtect;
                String string2 = "Protection from each color";
                if (tgtC.hasKeyword(string2)) {
                    allColorsProtect = Lists.newArrayList();
                    for (byte col : MagicColor.WUBRG) {
                        allColorsProtect.add("Protection from " + MagicColor.toLongString(col));
                    }
                    allColorsProtect.removeAll(kws);
                    addedKW.addAll(allColorsProtect);
                    removedKW.add(string2);
                }
                if (tgtC.hasKeyword(string = "Protection:Card.nonColorless:each color:Aura")) {
                    allColorsProtect = Lists.newArrayList();
                    for (byte col : MagicColor.WUBRG) {
                        colString = MagicColor.toLongString(col);
                        if (kws.contains("Protection from " + colString)) continue;
                        allColorsProtect.add("Protection:Card." + StringUtils.capitalize(colString) + ":" + colString + ":Aura");
                    }
                    addedKW.addAll(allColorsProtect);
                    removedKW.add(string);
                }
            }
            removedKW.addAll(kws);
            tgtC.addChangedCardKeywords(addedKW, removedKW, false, timestamp, null);
            if ("Permanent".equals(sa.getParam("Duration"))) continue;
            GameCommand gameCommand = new GameCommand(){
                private static final long serialVersionUID = 5387486776282932314L;

                @Override
                public void run() {
                    tgtC.removeChangedCardKeywords(timestamp, 0L);
                }
            };
            DebuffEffect.addUntilCommand(sa, gameCommand);
        }
    }
}

