/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CounterType;
import forge.game.player.Player;
import forge.game.player.PlayerController;
import forge.game.spellability.SpellAbility;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class CountersRemoveEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        String counterName = sa.getParam("CounterType");
        String num = sa.getParamOrDefault("CounterNum", "1");
        int amount = 0;
        if (!num.equals("All") && !num.equals("Any")) {
            amount = AbilityUtils.calculateAmount(sa.getHostCard(), num, sa);
        }
        sb.append("Remove ");
        if (sa.hasParam("UpTo")) {
            sb.append("up to ");
        }
        if ("All".matches(counterName)) {
            sb.append("all counter");
        } else if ("Any".matches(counterName)) {
            if (amount == 1) {
                sb.append("a counter");
            } else {
                sb.append(amount).append(" ").append(" counter");
            }
        } else {
            sb.append(amount).append(" ").append(CounterType.getType(counterName).getName()).append(" counter");
        }
        if (amount != 1) {
            sb.append("s");
        }
        sb.append(" from");
        sb.append(Lang.joinHomogenous(CountersRemoveEffect.getTargetCards(sa)));
        sb.append(Lang.joinHomogenous(CountersRemoveEffect.getTargetPlayers(sa)));
        sb.append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card card = sa.getHostCard();
        Game game = card.getGame();
        Player activator = sa.getActivatingPlayer();
        PlayerController pc = activator.getController();
        String type = sa.getParam("CounterType");
        String num = sa.getParamOrDefault("CounterNum", "1");
        int cntToRemove = 0;
        if (!num.equals("All") && !num.equals("Any")) {
            cntToRemove = AbilityUtils.calculateAmount(card, num, sa);
        }
        if (sa.hasParam("Optional")) {
            String ctrs;
            String string = cntToRemove > 1 ? Localizer.getInstance().getMessage("lblCounters", new Object[0]) : (ctrs = num.equals("All") ? Localizer.getInstance().getMessage("lblAllCounters", new Object[0]) : Localizer.getInstance().getMessage("lblACounters", new Object[0]));
            if (!pc.confirmAction(sa, null, Localizer.getInstance().getMessage("lblRemove", new Object[0]) + " " + ctrs + "?", null)) {
                return;
            }
        }
        CounterType counterType = null;
        if (!type.equals("Any") && !type.equals("All")) {
            try {
                counterType = CounterType.getType(type);
            }
            catch (Exception e) {
                System.out.println("Counter type doesn't match, nor does an SVar exist with the type name.");
                return;
            }
        }
        boolean rememberRemoved = sa.hasParam("RememberRemoved");
        boolean rememberAmount = sa.hasParam("RememberAmount");
        int totalRemoved = 0;
        for (Player tgtPlayer : CountersRemoveEffect.getTargetPlayers(sa)) {
            if (!tgtPlayer.isInGame()) continue;
            if (type.equals("All")) {
                for (Map.Entry<CounterType, Integer> e : Lists.newArrayList(tgtPlayer.getCounters().entrySet())) {
                    totalRemoved += tgtPlayer.subtractCounter(e.getKey(), (int)e.getValue(), activator);
                }
                continue;
            }
            if (num.equals("All")) {
                cntToRemove = tgtPlayer.getCounters(counterType);
            }
            if (type.equals("Any")) {
                totalRemoved += this.removeAnyType(tgtPlayer, cntToRemove, sa);
                continue;
            }
            totalRemoved += tgtPlayer.subtractCounter(counterType, cntToRemove, activator);
        }
        CardCollectionView srcCards = null;
        String typeforPrompt = counterType == null ? "" : counterType.getName();
        String title = Localizer.getInstance().getMessage("lblChooseCardsToTakeTargetCounters", typeforPrompt);
        title = title.replace("  ", " ");
        if (sa.hasParam("ValidSource")) {
            srcCards = game.getCardsIn(ZoneType.Battlefield);
            srcCards = CardLists.getValidCards((Iterable<Card>)srcCards, sa.getParam("ValidSource"), activator, card, (CardTraitBase)sa);
            if (num.equals("Any")) {
                HashMap<String, Object> params = Maps.newHashMap();
                params.put("CounterType", counterType);
                srcCards = pc.chooseCardsForEffect(srcCards, sa, title, 0, srcCards.size(), true, params);
            }
        } else if (sa.hasParam("Choices") && counterType != null) {
            ZoneType choiceZone = sa.hasParam("ChoiceZone") ? ZoneType.smartValueOf(sa.getParam("ChoiceZone")) : ZoneType.Battlefield;
            CardCollection choices = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(choiceZone), sa.getParam("Choices"), activator, card, (CardTraitBase)sa);
            int min2 = 1;
            int max = 1;
            if (sa.hasParam("ChoiceOptional")) {
                min2 = 0;
                max = choices.size();
            }
            srcCards = pc.chooseCardsForEffect(choices, sa, title, min2, max, min2 == 0, null);
        } else {
            srcCards = CountersRemoveEffect.getTargetCards(sa);
        }
        for (Card tgtCard : srcCards) {
            Card gameCard = game.getCardState(tgtCard, null);
            if (gameCard == null || !tgtCard.equalsWithGameTimestamp(gameCard)) continue;
            Zone zone = game.getZoneOf(gameCard);
            if (type.equals("All")) {
                for (Map.Entry<CounterType, Integer> e : Lists.newArrayList(gameCard.getCounters().entrySet())) {
                    totalRemoved += gameCard.subtractCounter(e.getKey(), (int)e.getValue(), activator);
                }
                game.updateLastStateForCard(gameCard);
                continue;
            }
            if (num.equals("All") || num.equals("Any")) {
                cntToRemove = gameCard.getCounters(counterType);
            }
            if (type.equals("Any")) {
                totalRemoved += this.removeAnyType(gameCard, cntToRemove, sa);
                continue;
            }
            if (!tgtCard.canRemoveCounters(counterType)) continue;
            cntToRemove = Math.min(cntToRemove, gameCard.getCounters(counterType));
            if ((zone.is(ZoneType.Battlefield) || zone.is(ZoneType.Exile)) && (sa.hasParam("UpTo") || num.equals("Any"))) {
                HashMap<String, Object> params = Maps.newHashMap();
                params.put("Target", gameCard);
                params.put("CounterType", counterType);
                title = Localizer.getInstance().getMessage("lblSelectRemoveCountersNumberOfTarget", type);
                cntToRemove = pc.chooseNumber(sa, title, 0, cntToRemove, params);
            }
            if (cntToRemove <= 0) continue;
            gameCard.subtractCounter(counterType, cntToRemove, activator);
            if (rememberRemoved) {
                for (int i = 0; i < cntToRemove; ++i) {
                    card.addRemembered(Pair.of(counterType, i));
                }
            }
            game.updateLastStateForCard(gameCard);
            totalRemoved += cntToRemove;
        }
        if (totalRemoved > 0 && rememberAmount) {
            card.addRemembered(totalRemoved);
        }
    }

    protected int removeAnyType(GameEntity entity, int cntToRemove, SpellAbility sa) {
        boolean rememberRemoved = sa.hasParam("RememberRemoved");
        int removed = 0;
        Card card = sa.getHostCard();
        Game game = card.getGame();
        Player activator = sa.getActivatingPlayer();
        PlayerController pc = activator.getController();
        HashMap<CounterType, Integer> tgtCounters = Maps.newHashMap(entity.getCounters());
        for (CounterType ct : ImmutableList.copyOf(tgtCounters.keySet())) {
            if (entity.canRemoveCounters(ct)) continue;
            tgtCounters.remove(ct);
        }
        while (cntToRemove > 0 && !tgtCounters.isEmpty()) {
            HashMap<String, Object> params = Maps.newHashMap();
            params.put("Target", entity);
            String prompt = Localizer.getInstance().getMessage("lblSelectCountersTypeToRemove", new Object[0]);
            CounterType chosenType = pc.chooseCounterType(ImmutableList.copyOf(tgtCounters.keySet()), sa, prompt, params);
            int max = Math.min(cntToRemove, (Integer)tgtCounters.get(chosenType));
            tgtCounters.remove(chosenType);
            int remaining = Aggregates.sum(tgtCounters.values(), Functions.identity());
            int min2 = sa.hasParam("UpTo") ? 0 : Math.max(1, max - remaining);
            prompt = Localizer.getInstance().getMessage("lblSelectRemoveCountersNumberOfTarget", chosenType.getName());
            params = Maps.newHashMap();
            params.put("Target", entity);
            params.put("CounterType", chosenType);
            int chosenAmount = pc.chooseNumber(sa, prompt, min2, max, params);
            if (chosenAmount > 0) {
                removed += chosenAmount;
                entity.subtractCounter(chosenType, chosenAmount, activator);
                if (entity instanceof Card) {
                    Card gameCard = (Card)entity;
                    game.updateLastStateForCard(gameCard);
                }
                if (rememberRemoved) {
                    for (int i = 0; i < chosenAmount; ++i) {
                        card.addRemembered(Pair.of(chosenType, i));
                    }
                }
                cntToRemove -= chosenAmount;
                continue;
            }
            if (!sa.hasParam("UpTo")) continue;
            break;
        }
        return removed;
    }
}

