/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CounterType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.Map;

public class CountersRemoveAllEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        CounterType cType = CounterType.getType(sa.getParam("CounterType"));
        int amount = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("CounterNum"), sa);
        String zone = sa.getParamOrDefault("ValidZone", "Battlefield");
        String amountString = Integer.toString(amount);
        if (sa.hasParam("AllCounters")) {
            amountString = "all";
        }
        sb.append("Remove ").append(amount).append(" ").append(cType.getName()).append(" counter");
        if (!amountString.equals("1")) {
            sb.append("s");
        }
        sb.append(" from each valid ");
        if (zone.matches("Battlefield")) {
            sb.append("permanent.");
        } else {
            sb.append("card in ").append(zone).append(".");
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        String type = sa.getParam("CounterType");
        int counterAmount = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("CounterNum"), sa);
        String valid = sa.getParam("ValidCards");
        ZoneType zone = sa.hasParam("ValidZone") ? ZoneType.smartValueOf(sa.getParam("ValidZone")) : ZoneType.Battlefield;
        Game game = sa.getActivatingPlayer().getGame();
        CardCollectionView cards = game.getCardsIn(zone);
        cards = CardLists.getValidCards((Iterable<Card>)cards, valid, sa.getActivatingPlayer(), sa.getHostCard(), (CardTraitBase)sa);
        if (sa.usesTargeting()) {
            Player pl = sa.getTargets().getFirstTargetedPlayer();
            cards = CardLists.filterControlledBy((Iterable<Card>)cards, pl);
        }
        int numberRemoved = 0;
        for (Card tgtCard : cards) {
            if (sa.hasParam("AllCounterTypes")) {
                for (Map.Entry<CounterType, Integer> e : Lists.newArrayList(tgtCard.getCounters().entrySet())) {
                    numberRemoved += tgtCard.subtractCounter(e.getKey(), (int)e.getValue(), sa.getActivatingPlayer());
                }
                continue;
            }
            if (sa.hasParam("AllCounters")) {
                counterAmount = tgtCard.getCounters(CounterType.getType(type));
            }
            if (counterAmount <= 0) continue;
            numberRemoved += tgtCard.subtractCounter(CounterType.getType(type), counterAmount, sa.getActivatingPlayer());
            game.updateLastStateForCard(tgtCard);
        }
        if (sa.hasParam("RememberAmount")) {
            sa.getHostCard().addRemembered(numberRemoved);
        }
    }
}

