/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CounterType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Lang;

public class CountersPutAllEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        CounterType cType = CounterType.getType(sa.getParam("CounterType"));
        int amount = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParamOrDefault("CounterNum", "1"), sa);
        String zone = sa.getParamOrDefault("ValidZone", "Battlefield");
        sb.append("Put ");
        sb.append(Lang.nounWithNumeralExceptOne(amount, cType.getName().toLowerCase() + " counter"));
        sb.append(" on each ");
        if (sa.hasParam("ValidCardsDesc")) {
            sb.append(sa.getParam("ValidCardsDesc")).append(".");
        } else {
            sb.append("valid ");
            if (zone.matches("Battlefield")) {
                sb.append("permanent.");
            } else {
                sb.append("card in ").append(zone).append(".");
            }
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Player activator = sa.getActivatingPlayer();
        CounterType type = CounterType.getType(sa.getParam("CounterType"));
        int counterAmount = AbilityUtils.calculateAmount(host, sa.getParamOrDefault("CounterNum", "1"), sa);
        String valid = sa.getParam("ValidCards");
        ZoneType zone = sa.hasParam("ValidZone") ? ZoneType.smartValueOf(sa.getParam("ValidZone")) : ZoneType.Battlefield;
        Game game = activator.getGame();
        if (counterAmount <= 0) {
            return;
        }
        CardCollectionView cards = game.getCardsIn(zone);
        cards = CardLists.getValidCards((Iterable<Card>)cards, valid, activator, host, (CardTraitBase)sa);
        if (sa.usesTargeting()) {
            Player pl = sa.getTargets().getFirstTargetedPlayer();
            cards = CardLists.filterControlledBy((Iterable<Card>)cards, pl);
        }
        Player placer = activator;
        String placerPerCard = "";
        if (sa.hasParam("Placer")) {
            String pstr = sa.getParam("Placer");
            if (pstr.equals("Controller")) {
                placerPerCard = "Controller";
            } else if (pstr.equals("Owner")) {
                placerPerCard = "Owner";
            } else {
                placer = (Player)AbilityUtils.getDefinedPlayers(host, pstr, sa).get(false);
            }
        }
        GameEntityCounterTable table = new GameEntityCounterTable();
        for (Card tgtCard : cards) {
            if (placerPerCard.equals("Controller")) {
                placer = tgtCard.getController();
            } else if (placerPerCard.equals("Owner")) {
                placer = tgtCard.getOwner();
            }
            if (sa.hasParam("AmountByChosenMap")) {
                int index;
                String[] parse = sa.getParam("AmountByChosenMap").split(" INDEX ");
                int n = index = parse.length > 1 ? Integer.parseInt(parse[1]) : 0;
                if (index >= host.getChosenMap().get(placer).size()) continue;
                Card chosen = (Card)host.getChosenMap().get(placer).get(index);
                counterAmount = AbilityUtils.xCount(chosen, parse[0], sa);
            }
            tgtCard.addCounter(type, counterAmount, placer, table);
        }
        if (sa.hasParam("ValidCards2") || sa.hasParam("CounterType2") || sa.hasParam("CounterNum2")) {
            ZoneType zone2;
            CounterType type2 = sa.hasParam("CounterType2") ? CounterType.getType(sa.getParam("CounterType2")) : type;
            ZoneType zoneType = zone2 = sa.hasParam("ValidZone2") ? ZoneType.smartValueOf(sa.getParam("ValidZone2")) : zone;
            if (sa.hasParam("ValidCards2")) {
                cards = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(zone2), sa.getParam("ValidCards2"), activator, host, (CardTraitBase)sa);
                if (sa.usesTargeting()) {
                    cards = CardLists.filterControlledBy((Iterable<Card>)cards, sa.getTargets().getFirstTargetedPlayer());
                }
            }
            int counterAmount2 = sa.hasParam("CounterNum2") ? AbilityUtils.calculateAmount(host, sa.getParam("CounterNum2"), sa) : counterAmount;
            for (Card tgtCard : cards) {
                if (placerPerCard.equals("Controller")) {
                    placer = tgtCard.getController();
                }
                tgtCard.addCounter(type2, counterAmount2, placer, table);
            }
        }
        table.replaceCounterEffect(game, sa, true);
        if (sa.hasParam("RememberCards")) {
            host.addRemembered(table.columnKeySet());
        }
    }
}

