/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CounterType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import java.util.Map;

public class CountersNoteEffect
extends SpellAbilityEffect {
    static final String MODE_STORE = "Store";
    static final String MODE_LOAD = "Load";
    static final String NOTE_COUNTERS = "NoteCounters";

    @Override
    public void resolve(SpellAbility sa) {
    }

    public static void noteCounters(Card notee, Card source) {
        for (Map.Entry<CounterType, Integer> counter : notee.getCounters().entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append(NOTE_COUNTERS).append(counter.getKey().getName());
            source.setSVar(sb.toString(), counter.getValue().toString());
        }
    }

    public static void loadCounters(Card notee, Card source, Player p, SpellAbility sa, Map<AbilityKey, Object> moveParams) {
        GameEntityCounterTable table = new GameEntityCounterTable();
        for (Map.Entry<String, String> svar : source.getSVars().entrySet()) {
            String key = svar.getKey();
            if (!key.startsWith(NOTE_COUNTERS)) continue;
            CounterType cType = CounterType.getType(key.substring(NOTE_COUNTERS.length()));
            int cAmount = Integer.parseInt(svar.getValue());
            table.put(sa.getActivatingPlayer(), notee, cType, cAmount);
        }
        moveParams.put(AbilityKey.CounterTable, table);
    }
}

