/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.GameEntityCounterTable;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CounterType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.util.Lang;
import java.util.Map;

public class CountersMultiplyEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        CounterType counterType = this.getCounterType(sa);
        sb.append("Double the number of ");
        if (counterType != null) {
            sb.append(counterType.getName());
            sb.append(" counters");
        } else {
            sb.append("each kind of counter");
        }
        sb.append(" on ");
        sb.append(Lang.joinHomogenous(CountersMultiplyEffect.getTargetCards(sa)));
        sb.append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        Player player = sa.getActivatingPlayer();
        CounterType counterType = this.getCounterType(sa);
        int n = Integer.parseInt(sa.getParamOrDefault("Multiplier", "2")) - 1;
        GameEntityCounterTable table = new GameEntityCounterTable();
        for (Card tgtCard : CountersMultiplyEffect.getTargetCards(sa)) {
            Card gameCard = game.getCardState(tgtCard, null);
            if (gameCard == null || !tgtCard.equalsWithGameTimestamp(gameCard)) continue;
            if (counterType != null) {
                gameCard.addCounter(counterType, gameCard.getCounters(counterType) * n, player, table);
                continue;
            }
            for (Map.Entry<CounterType, Integer> e : gameCard.getCounters().entrySet()) {
                gameCard.addCounter(e.getKey(), e.getValue() * n, player, table);
            }
        }
        table.replaceCounterEffect(game, sa, true);
    }

    private CounterType getCounterType(SpellAbility sa) {
        if (sa.hasParam("CounterType")) {
            try {
                return CounterType.getType(sa.getParam("CounterType"));
            }
            catch (Exception e) {
                System.out.println("Counter type doesn't match, nor does an SVar exist with the type name.");
                return null;
            }
        }
        return null;
    }
}

