/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterType;
import forge.game.player.Player;
import forge.game.player.PlayerController;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.CardTranslation;
import forge.util.Localizer;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CountersMoveEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        CardCollection tgtCards = CountersMoveEffect.getDefinedCardsOrTargeted(sa);
        Card source = null;
        if (sa.usesTargeting() && sa.getMinTargets() == 2) {
            if (tgtCards.size() < 2) {
                return "";
            }
            source = (Card)tgtCards.remove(0);
        } else {
            CardCollection srcCards = CountersMoveEffect.getDefinedCardsOrTargeted(sa, "Source");
            if (srcCards.size() > 0) {
                source = (Card)srcCards.get(0);
            }
        }
        String countername = sa.getParam("CounterType");
        String counterAmount = sa.getParamOrDefault("CounterNum", "1");
        int amount = 0;
        if (!"Any".equals(counterAmount) && !"All".equals(counterAmount)) {
            amount = AbilityUtils.calculateAmount(sa.getHostCard(), counterAmount, sa);
        }
        sb.append("Move ");
        if ("Any".matches(countername)) {
            if (amount == 1) {
                sb.append("a counter");
            } else {
                sb.append(amount).append(" ").append(" counter");
            }
        } else if ("All".equals(countername)) {
            sb.append("all counter");
        } else {
            sb.append(amount).append(" ").append(countername).append(" counter");
        }
        if (amount != 1) {
            sb.append("s");
        }
        sb.append(" from ").append(source).append(" to ");
        try {
            sb.append(tgtCards.get(0));
        }
        catch (IndexOutOfBoundsException exception) {
            System.out.println(TextUtil.concatWithSpace("Somehow this is missing targets?", source.toString()));
        }
        sb.append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        String counterName = sa.getParam("CounterType");
        String counterNum = sa.getParamOrDefault("CounterNum", "1");
        Player activator = sa.getActivatingPlayer();
        PlayerController pc = activator.getController();
        Game game = host.getGame();
        CounterType cType = null;
        if (!counterName.matches("Any") && !counterName.matches("All")) {
            try {
                cType = CounterType.getType(counterName);
            }
            catch (Exception e) {
                System.out.println("Counter type doesn't match, nor does an SVar exist with the type name.");
                return;
            }
        }
        GameEntityCounterTable table = new GameEntityCounterTable();
        if (sa.hasParam("ValidSource")) {
            CardCollectionView srcCards = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), sa.getParam("ValidSource"), activator, host, (CardTraitBase)sa);
            CardCollection tgtCards = CountersMoveEffect.getDefinedCardsOrTargeted(sa);
            if (tgtCards.isEmpty()) {
                return;
            }
            Card dest = (Card)tgtCards.get(0);
            Card cur = game.getCardState(dest, null);
            if (cur == null || !cur.equalsWithGameTimestamp(dest)) {
                return;
            }
            dest = cur;
            HashMap<String, Object> params = Maps.newHashMap();
            params.put("Target", dest);
            if ("All".equals(counterName)) {
                if (counterNum.equals("Any")) {
                    srcCards = CardLists.filter((Iterable<Card>)srcCards, CardPredicates.hasCounters());
                    srcCards = activator.getController().chooseCardsForEffect(srcCards, sa, Localizer.getInstance().getMessage("lblChooseTakeCountersCard", "any"), 0, srcCards.size(), true, params);
                }
            } else {
                if (!dest.canReceiveCounters(cType)) {
                    return;
                }
                srcCards = CardLists.filter((Iterable<Card>)srcCards, CardPredicates.hasCounter(cType));
                if (counterNum.equals("Any")) {
                    params.put("CounterType", cType);
                    srcCards = activator.getController().chooseCardsForEffect(srcCards, sa, Localizer.getInstance().getMessage("lblChooseTakeCountersCard", cType.getName()), 0, srcCards.size(), true, params);
                }
            }
            HashMap<CounterType, Integer> countersToAdd = Maps.newHashMap();
            for (Card card : srcCards) {
                if ("All".equals(counterName)) {
                    HashMap<CounterType, Integer> tgtCounters = Maps.newHashMap(card.getCounters());
                    for (Map.Entry e : tgtCounters.entrySet()) {
                        this.removeCounter(sa, card, dest, (CounterType)e.getKey(), counterNum, countersToAdd);
                    }
                    continue;
                }
                this.removeCounter(sa, card, dest, cType, counterNum, countersToAdd);
            }
            for (Map.Entry entry : countersToAdd.entrySet()) {
                dest.addCounter((CounterType)entry.getKey(), (int)((Integer)entry.getValue()), activator, table);
            }
            game.updateLastStateForCard(dest);
        } else if (sa.hasParam("ValidDefined")) {
            CardCollection srcCards = CountersMoveEffect.getDefinedCardsOrTargeted(sa, "Source");
            if (srcCards.isEmpty()) {
                return;
            }
            Card source = (Card)srcCards.get(0);
            if (source.getCounters(cType) <= 0) {
                return;
            }
            HashMap<String, Object> params = Maps.newHashMap();
            params.put("CounterType", cType);
            params.put("Source", source);
            CardCollectionView tgtCards = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), sa.getParam("ValidDefined"), activator, host, (CardTraitBase)sa);
            if (counterNum.equals("Any")) {
                tgtCards = activator.getController().chooseCardsForEffect(tgtCards, sa, Localizer.getInstance().getMessage("lblChooseCardToGetCountersFrom", cType.getName(), CardTranslation.getTranslatedName(source.getName())), 0, tgtCards.size(), true, params);
            }
            boolean updateSource = false;
            for (Card dest : tgtCards) {
                Card card;
                if (source.equals(dest) || !dest.canReceiveCounters(cType) || !source.canRemoveCounters(cType) || (card = game.getCardState(dest, null)) == null || !card.equalsWithGameTimestamp(dest)) continue;
                params = Maps.newHashMap();
                params.put("CounterType", cType);
                params.put("Source", source);
                params.put("Target", card);
                int cnum = activator.getController().chooseNumber(sa, Localizer.getInstance().getMessage("lblPutHowManyTargetCounterOnCard", cType.getName(), CardTranslation.getTranslatedName(card.getName())), 0, source.getCounters(cType), params);
                if (cnum <= 0) continue;
                source.subtractCounter(cType, cnum, activator);
                card.addCounter(cType, cnum, activator, table);
                game.updateLastStateForCard(card);
                updateSource = true;
            }
            if (updateSource) {
                game.updateLastStateForCard(source);
            }
        } else {
            GameEntity source = null;
            CardCollection tgtCards = CountersMoveEffect.getDefinedCardsOrTargeted(sa);
            if (sa.usesTargeting() && sa.getMinTargets() == 2) {
                if (tgtCards.size() < 2) {
                    return;
                }
                source = (Card)tgtCards.remove(0);
            } else {
                CardCollection srcCards = CountersMoveEffect.getDefinedCardsOrTargeted(sa, "Source");
                if (srcCards.size() > 0) {
                    source = (Card)srcCards.get(0);
                }
            }
            if (source == null) {
                return;
            }
            if (!source.hasCounters()) {
                return;
            }
            for (Card dest : tgtCards) {
                Map<CounterType, Integer> tgtCounters;
                Card cur;
                if (null == dest || source.equals(dest) || (cur = game.getCardState(dest, null)) == null || !cur.equalsWithGameTimestamp(dest)) continue;
                HashMap<CounterType, Integer> countersToAdd = Maps.newHashMap();
                if ("All".equals(counterName)) {
                    tgtCounters = Maps.newHashMap(source.getCounters());
                    for (Map.Entry e : tgtCounters.entrySet()) {
                        this.removeCounter(sa, (Card)source, cur, (CounterType)e.getKey(), counterNum, countersToAdd);
                    }
                } else if ("EachNotOn".equals(counterName)) {
                    tgtCounters = Maps.newHashMap(source.getCounters());
                    for (Map.Entry e : tgtCounters.entrySet()) {
                        if (cur.getCounters((CounterType)e.getKey()) > 0) continue;
                        this.removeCounter(sa, (Card)source, cur, (CounterType)e.getKey(), counterNum, countersToAdd);
                    }
                } else if ("Any".equals(counterName)) {
                    Map.Entry e;
                    tgtCounters = source.getCounters();
                    ArrayList<CounterType> arrayList = Lists.newArrayList();
                    e = tgtCounters.keySet().iterator();
                    while (e.hasNext()) {
                        CounterType ct = (CounterType)e.next();
                        if (!dest.canReceiveCounters(ct) || !((Card)source).canRemoveCounters(cType)) continue;
                        arrayList.add(ct);
                    }
                    if (arrayList.isEmpty()) {
                        return;
                    }
                    while (!arrayList.isEmpty()) {
                        HashMap<String, Object> params = Maps.newHashMap();
                        params.put("Source", source);
                        params.put("Target", dest);
                        String title = Localizer.getInstance().getMessage("lblSelectRemoveCounterType", new Object[0]);
                        CounterType chosenType = pc.chooseCounterType(arrayList, sa, title, params);
                        this.removeCounter(sa, (Card)source, cur, chosenType, counterNum, countersToAdd);
                        if (counterNum.equals("Any")) {
                            arrayList.remove(chosenType);
                            continue;
                        }
                        break;
                    }
                } else {
                    this.removeCounter(sa, (Card)source, cur, cType, counterNum, countersToAdd);
                }
                for (Map.Entry entry : countersToAdd.entrySet()) {
                    cur.addCounter((CounterType)entry.getKey(), (int)((Integer)entry.getValue()), activator, table);
                }
            }
            game.updateLastStateForCard((Card)source);
        }
        table.replaceCounterEffect(game, sa, true);
    }

    protected void removeCounter(SpellAbility sa, Card src, Card dest, CounterType cType, String counterNum, Map<CounterType, Integer> countersToAdd) {
        Card host = sa.getHostCard();
        Player activator = sa.getActivatingPlayer();
        PlayerController pc = activator.getController();
        Game game = host.getGame();
        if (src.equals(dest)) {
            return;
        }
        if (!dest.canReceiveCounters(cType)) {
            return;
        }
        if (!src.canRemoveCounters(cType)) {
            return;
        }
        int cmax = src.getCounters(cType);
        if (cmax <= 0) {
            return;
        }
        int cnum = 0;
        if (counterNum.equals("All")) {
            cnum = cmax;
        } else if (counterNum.equals("Any")) {
            HashMap<String, Object> params = Maps.newHashMap();
            params.put("CounterType", cType);
            params.put("Source", src);
            params.put("Target", dest);
            int min2 = sa.hasParam("NonZero") && countersToAdd.isEmpty() ? 1 : 0;
            cnum = pc.chooseNumber(sa, Localizer.getInstance().getMessage("lblTakeHowManyTargetCounterFromCard", cType.getName(), CardTranslation.getTranslatedName(src.getName())), min2, cmax, params);
        } else {
            cnum = Math.min(cmax, AbilityUtils.calculateAmount(host, counterNum, sa));
        }
        if (cnum > 0) {
            src.subtractCounter(cType, cnum, activator);
            game.updateLastStateForCard(src);
            countersToAdd.put(cType, countersToAdd.getOrDefault(cType, 0) + cnum);
        }
    }
}

