/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameObject;
import forge.game.GameObjectPredicates;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardFactory;
import forge.game.player.Player;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbilityCantBeCopied;
import forge.game.zone.ZoneType;
import forge.util.CardTranslation;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.collect.FCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CopySpellAbilityEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        List<SpellAbility> tgtSpells = CopySpellAbilityEffect.getTargetSpells(sa);
        sb.append("Copy ");
        Iterator<SpellAbility> it = tgtSpells.iterator();
        while (it.hasNext()) {
            sb.append(it.next().getHostCard());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        int amount = 1;
        if (sa.hasParam("Amount")) {
            amount = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("Amount"), sa);
        }
        if (amount > 1) {
            sb.append(" ").append(Lang.getNumeral(amount)).append(" times");
        }
        sb.append(".");
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void resolve(SpellAbility sa) {
        Card card = sa.getHostCard();
        Game game = card.getGame();
        int amount = 1;
        if (sa.hasParam("Amount")) {
            amount = AbilityUtils.calculateAmount(card, sa.getParam("Amount"), sa);
        }
        List<SpellAbility> tgtSpells = CopySpellAbilityEffect.getTargetSpells(sa);
        tgtSpells.removeIf(tgtSA -> StaticAbilityCantBeCopied.cantBeCopied(tgtSA.getHostCard()));
        if (tgtSpells.isEmpty() || amount == 0) {
            return;
        }
        List<Player> controllers = Lists.newArrayList(sa.getActivatingPlayer());
        if (sa.hasParam("Controller")) {
            controllers = AbilityUtils.getDefinedPlayers(card, sa.getParam("Controller"), sa);
        }
        boolean isOptional = sa.hasParam("Optional");
        for (Player controller : controllers) {
            ArrayList<SpellAbility> copies = Lists.newArrayList();
            List<SpellAbility> copySpells = tgtSpells;
            if (sa.hasParam("SingleChoice")) {
                SpellAbility chosenSA = controller.getController().chooseSingleSpellForEffect(tgtSpells, sa, Localizer.getInstance().getMessage("lblSelectASpellCopy", new Object[0]), ImmutableMap.of());
                copySpells = Lists.newArrayList(chosenSA);
            }
            for (SpellAbility chosenSA : copySpells) {
                void var17_28;
                SpellAbility copy;
                if (isOptional && !controller.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblDoyouWantCopyTheSpell", CardTranslation.getTranslatedName(chosenSA.getHostCard().getName())), null)) continue;
                if (sa.hasParam("CopyForEachCanTarget")) {
                    SpellAbility targetedSA = this.getTargetedSA(chosenSA);
                    if (targetedSA == null) continue;
                    FCollection<GameObject> all = new FCollection<GameObject>(Iterables.filter(targetedSA.getTargetRestrictions().getAllCandidates(targetedSA, true), GameObjectPredicates.restriction(sa.getParam("CopyForEachCanTarget").split(","), sa.getActivatingPlayer(), card, sa)));
                    all.removeAll(CopySpellAbilityEffect.getTargetPlayers(targetedSA));
                    if (sa.hasParam("ChooseOnlyOne")) {
                        SpellAbility spellAbility;
                        GameObject choice = controller.getController().chooseSingleEntityForEffect(all, sa, Localizer.getInstance().getMessage("lblChooseOne", new Object[0]), null);
                        if (choice != null && this.changeToLegalTarget(spellAbility = CardFactory.copySpellAbilityAndPossiblyHost(sa, chosenSA, controller), (GameEntity)choice, targetedSA)) {
                            copies.add(spellAbility);
                        }
                    } else {
                        for (GameEntity gameEntity : all) {
                            copy = CardFactory.copySpellAbilityAndPossiblyHost(sa, chosenSA, controller);
                            this.resetFirstTargetOnCopy(copy, gameEntity, targetedSA);
                            copies.add(copy);
                        }
                    }
                } else if (sa.hasParam("DefinedTarget")) {
                    SpellAbility targetedSA;
                    FCollection<GameEntity> tgts = AbilityUtils.getDefinedEntities(card, sa.getParam("DefinedTarget"), (CardTraitBase)sa);
                    if (tgts.isEmpty() || (targetedSA = this.getTargetedSA(chosenSA)) == null) continue;
                    FCollection<GameEntity> newTgts = new FCollection<GameEntity>();
                    for (GameEntity e : tgts) {
                        if (e instanceof Player) {
                            FCollection<GameEntity> choices = new FCollection<GameEntity>(e);
                            choices.addAll(((Player)e).getCardsIn(ZoneType.Battlefield));
                            newTgts.add(controller.getController().chooseSingleEntityForEffect(choices, sa, Localizer.getInstance().getMessage("lblChooseOne", new Object[0]), null));
                            continue;
                        }
                        newTgts.add(e);
                    }
                    for (GameEntity e : newTgts) {
                        SpellAbility copy3 = CardFactory.copySpellAbilityAndPossiblyHost(sa, chosenSA, controller);
                        if (!this.changeToLegalTarget(copy3, e, targetedSA)) continue;
                        copies.add(copy3);
                    }
                } else {
                    for (int i = 0; i < amount; ++i) {
                        SpellAbility copy4 = CardFactory.copySpellAbilityAndPossiblyHost(sa, chosenSA, controller);
                        if (sa.hasParam("IgnoreFreeze")) {
                            copy4.putParam("IgnoreFreeze", "True");
                        }
                        if (sa.hasParam("MayChooseTarget")) {
                            copy4.setMayChooseNewTargets(true);
                        }
                        if (sa.hasParam("Epic")) {
                            copy4.getHostCard().removeIntrinsicKeyword("Epic");
                            SpellAbility sub = copy4;
                            while (sub.getSubAbility() != null && !sub.hasParam("Epic")) {
                                sub = sub.getSubAbility();
                            }
                            if (sub != null) {
                                sub.getParent().setSubAbility(sub.getSubAbility());
                            }
                        }
                        copies.add(copy4);
                    }
                }
                if (copies.isEmpty()) continue;
                int addAmount = copies.size();
                Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(controller);
                repParams.put(AbilityKey.SpellAbility, chosenSA);
                repParams.put(AbilityKey.Amount, addAmount);
                switch (game.getReplacementHandler().run(ReplacementType.CopySpell, repParams)) {
                    case NotReplaced: {
                        break;
                    }
                    case Updated: {
                        addAmount = (Integer)repParams.get((Object)AbilityKey.Amount);
                        break;
                    }
                    default: {
                        addAmount = 0;
                    }
                }
                if (addAmount <= 0) continue;
                int extraAmount = addAmount - copies.size();
                boolean bl = false;
                while (var17_28 < extraAmount) {
                    copy = CardFactory.copySpellAbilityAndPossiblyHost(sa, chosenSA, controller);
                    copy.setMayChooseNewTargets(true);
                    copies.add(copy);
                    ++var17_28;
                }
            }
            controller.getController().orderAndPlaySimultaneousSa(copies);
            if (!sa.hasParam("RememberCopies")) continue;
            card.addRemembered(copies);
        }
    }

    private boolean changeToLegalTarget(SpellAbility copy, GameEntity tgt, SpellAbility targetedSA) {
        SpellAbility targetedCopy = this.getTargetedSA(copy);
        if (targetedCopy == null) {
            return false;
        }
        if (!targetedCopy.canTarget(tgt)) {
            return false;
        }
        this.resetFirstTargetOnCopy(targetedCopy, tgt, targetedSA);
        return true;
    }

    private void resetFirstTargetOnCopy(SpellAbility copy, GameEntity obj, SpellAbility targetedSA) {
        for (SpellAbility subAb = copy; subAb != null; subAb = subAb.getSubAbility()) {
            subAb.resetFirstTarget(obj, targetedSA);
        }
    }

    private SpellAbility getTargetedSA(SpellAbility targetedSA) {
        while (targetedSA != null && (!targetedSA.usesTargeting() || targetedSA.getTargets().isEmpty())) {
            targetedSA = targetedSA.getSubAbility();
        }
        return targetedSA;
    }
}

