/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.ImageKeys;
import forge.StaticData;
import forge.card.CardRarity;
import forge.card.CardRulesPredicates;
import forge.card.CardStateName;
import forge.card.GamePieceType;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.effects.TokenEffectBase;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardFactory;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardZoneTable;
import forge.game.card.TokenCreateTable;
import forge.game.event.GameEventCombatChanged;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.util.Aggregates;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.PredicateString;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class CopyPermanentEffect
extends TokenEffectBase {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        if (sa.hasParam("Populate")) {
            return "Populate. (Create a token that's a copy of a creature token you control.)";
        }
        StringBuilder sb = new StringBuilder();
        Player activator = sa.getActivatingPlayer();
        int numCopies = sa.hasParam("NumCopies") ? AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("NumCopies"), sa) : 1;
        sb.append(activator).append(" creates ");
        if (sa.hasParam("DefinedName")) {
            sb.append(Lang.nounWithNumeralExceptOne(numCopies, sa.getParam("DefinedName") + " token"));
        } else {
            CardCollection tgtCards = CopyPermanentEffect.getTargetCards(sa);
            boolean justOne = tgtCards.size() == 1;
            boolean addKWs = sa.hasParam("AddKeywords");
            sb.append(Lang.nounWithNumeralExceptOne(numCopies, "token"));
            sb.append(numCopies == 1 ? " that's a copy" : " that are copies").append(" of ");
            sb.append(Lang.joinHomogenous(tgtCards));
            if (addKWs) {
                ArrayList<String> keywords = Lists.newArrayList();
                keywords.addAll(Arrays.asList(sa.getParam("AddKeywords").split(" & ")));
                if (sa.getDescription().contains("except")) {
                    sb.append(", except ").append(justOne ? "it has " : "they have ");
                } else {
                    sb.append(". ").append(justOne ? "It gains " : "They gain ");
                }
                sb.append(Lang.joinHomogenous(keywords).toLowerCase());
            }
            if (sa.hasParam("AddTriggers")) {
                String trigStg;
                String oDesc = sa.getDescription();
                String string = trigStg = oDesc.contains("\"") ? oDesc.substring(oDesc.indexOf("\""), oDesc.lastIndexOf("\"") + 1) : "[trigger text parsing error]";
                if (addKWs) {
                    sb.append(" and ").append(trigStg);
                } else {
                    sb.append(". ").append(justOne ? "It gains " : "They gain ").append(trigStg);
                }
            } else {
                sb.append(".");
            }
            if (sa.hasParam("AtEOT")) {
                String atEOT = sa.getParam("AtEOT");
                String verb = "Sacrifice ";
                if (atEOT.startsWith("Exile")) {
                    verb = "Exile ";
                }
                sb.append(" ").append(verb).append(justOne ? "it " : "them ").append("at ");
                String when = "the beginning of the next end step.";
                if (atEOT.endsWith("Combat")) {
                    when = "end of combat.";
                }
                sb.append(when);
            }
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Player activator = sa.getActivatingPlayer();
        Game game = host.getGame();
        boolean useZoneTable = true;
        boolean chosenMap = "ChosenMap".equals(sa.getParam("Defined"));
        CardZoneTable triggerList = sa.getChangeZoneTable();
        if (triggerList == null) {
            triggerList = new CardZoneTable();
            useZoneTable = false;
        }
        if (sa.hasParam("ChangeZoneTable")) {
            sa.setChangeZoneTable(triggerList);
            useZoneTable = true;
        }
        MutableBoolean combatChanged = new MutableBoolean(false);
        TokenCreateTable tokenTable = new TokenCreateTable();
        if (sa.hasParam("Optional") && !activator.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblCopyPermanentConfirm", new Object[0]), null)) {
            return;
        }
        int numCopies = sa.hasParam("NumCopies") ? AbilityUtils.calculateAmount(host, sa.getParam("NumCopies"), sa) : 1;
        List<Player> controllers = Lists.newArrayList();
        if (sa.hasParam("Controller")) {
            controllers = AbilityUtils.getDefinedPlayers(host, sa.getParam("Controller"), sa);
        } else if (chosenMap) {
            controllers.addAll(host.getChosenMap().keySet());
        }
        if (controllers.isEmpty()) {
            controllers.add(activator);
        }
        for (Player controller : controllers) {
            Predicate cpp;
            if (!controller.isInGame()) continue;
            List<Card> tgtCards = Lists.newArrayList();
            if (sa.hasParam("ValidSupportedCopy")) {
                ArrayList<PaperCard> cards = Lists.newArrayList(StaticData.instance().getCommonCards().getUniqueCards());
                String valid = sa.getParam("ValidSupportedCopy");
                if (valid.contains("X")) {
                    valid = TextUtil.fastReplace(valid, "X", Integer.toString(AbilityUtils.calculateAmount(host, "X", sa)));
                }
                if (StringUtils.containsIgnoreCase(valid, "creature")) {
                    cpp = Predicates.compose(CardRulesPredicates.Presets.IS_CREATURE, PaperCard::getRules);
                    cards = Lists.newArrayList(Iterables.filter(cards, cpp));
                }
                if (StringUtils.containsIgnoreCase(valid, "equipment")) {
                    cpp = Predicates.compose(CardRulesPredicates.Presets.IS_EQUIPMENT, PaperCard::getRules);
                    cards = Lists.newArrayList(Iterables.filter(cards, cpp));
                }
                if (sa.hasParam("RandomCopied")) {
                    ArrayList<PaperCard> copysource = Lists.newArrayList(cards);
                    ArrayList<Card> choice = Lists.newArrayList();
                    String num = sa.getParamOrDefault("RandomNum", "1");
                    int ncopied = AbilityUtils.calculateAmount(host, num, sa);
                    while (ncopied > 0 && !copysource.isEmpty()) {
                        PaperCard cp = Aggregates.random(copysource);
                        Card possibleCard = Card.fromPaperCard(cp, activator);
                        if (possibleCard.isValid(valid, host.getController(), host, (CardTraitBase)sa)) {
                            if (host.getController().isAI() && possibleCard.getRules() != null && possibleCard.getRules().getAiHints().getRemAIDecks()) continue;
                            choice.add(possibleCard);
                            --ncopied;
                        }
                        copysource.remove(cp);
                    }
                    tgtCards = choice;
                    System.err.println("Copying random permanent(s): " + tgtCards.toString());
                }
            } else if (sa.hasParam("DefinedName")) {
                ArrayList<PaperCard> cards = Lists.newArrayList(StaticData.instance().getCommonCards().getUniqueCards());
                String name = sa.getParam("DefinedName");
                if (name.equals("NamedCard") && !host.getNamedCard().isEmpty()) {
                    name = host.getNamedCard();
                }
                if (!(cards = Lists.newArrayList(Iterables.filter(cards, cpp = Predicates.compose(CardRulesPredicates.name(PredicateString.StringOp.EQUALS, name), PaperCard::getRules)))).isEmpty()) {
                    tgtCards.add(Card.fromPaperCard((IPaperCard)cards.get(0), controller));
                }
            } else if (sa.hasParam("Choices")) {
                Player chooser = activator;
                if (sa.hasParam("Chooser")) {
                    String choose = sa.getParam("Chooser");
                    chooser = (Player)AbilityUtils.getDefinedPlayers(host, choose, sa).get(false);
                }
                CardCollectionView choices = sa.hasParam("Defined") ? CopyPermanentEffect.getDefinedCardsOrTargeted(sa) : game.getCardsIn(ZoneType.Battlefield);
                if (!(choices = CardLists.getValidCards((Iterable<Card>)choices, sa.getParam("Choices"), activator, host, (CardTraitBase)sa)).isEmpty()) {
                    Card choosen;
                    String title;
                    String string = title = sa.hasParam("ChoiceTitle") ? sa.getParam("ChoiceTitle") : Localizer.getInstance().getMessage("lblChooseaCard", new Object[0]);
                    if (sa.hasParam("WithDifferentNames")) {
                        while (!choices.isEmpty()) {
                            choosen = chooser.getController().chooseSingleEntityForEffect(choices, sa, title, true, null);
                            if (choosen != null) {
                                tgtCards.add(choosen);
                                choices = CardLists.filter((Iterable<Card>)choices, Predicates.not(CardPredicates.sharesNameWith(choosen)));
                                continue;
                            }
                            if (!chooser.getController().confirmAction(sa, PlayerActionConfirmMode.OptionalChoose, Localizer.getInstance().getMessage("lblCancelChooseConfirm", new Object[0]), null)) continue;
                            break;
                        }
                    } else {
                        choosen = chooser.getController().chooseSingleEntityForEffect(choices, sa, title, false, null);
                        if (choosen != null) {
                            tgtCards.add(choosen);
                        }
                    }
                }
            } else if (chosenMap) {
                if (sa.hasParam("ChosenMapIndex")) {
                    int index = Integer.parseInt(sa.getParam("ChosenMapIndex"));
                    if (index >= host.getChosenMap().get(controller).size()) continue;
                    tgtCards.add((Card)host.getChosenMap().get(controller).get(index));
                } else {
                    tgtCards = host.getChosenMap().get(controller);
                }
            } else {
                tgtCards = CopyPermanentEffect.getDefinedCardsOrTargeted(sa);
            }
            for (Card c : tgtCards) {
                if (c.isInstant() || c.isSorcery()) continue;
                if (sa.hasParam("ForEach")) {
                    for (Player p : AbilityUtils.getDefinedPlayers(host, sa.getParam("ForEach"), sa)) {
                        if (sa.hasParam("OptionalForEach") && !activator.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblCopyPermanentConfirm", new Object[0]) + " (" + p + ")", null)) continue;
                        Card proto = CopyPermanentEffect.getProtoType(sa, c, controller);
                        proto.addRemembered(p);
                        tokenTable.put(controller, proto, numCopies);
                    }
                    continue;
                }
                tokenTable.put(controller, CopyPermanentEffect.getProtoType(sa, c, controller), numCopies);
            }
        }
        this.makeTokenTable(tokenTable, true, triggerList, combatChanged, sa);
        if (!useZoneTable) {
            triggerList.triggerChangesZoneAll(game, sa);
        }
        if (combatChanged.isTrue()) {
            game.updateCombatForView();
            game.fireEvent(new GameEventCombatChanged());
        }
    }

    public static Card getProtoType(SpellAbility sa, Card original, Player newOwner) {
        Card copy;
        if (sa.hasParam("DefinedName")) {
            copy = original;
            String name = TextUtil.fastReplace(TextUtil.fastReplace(original.getName(), ",", ""), " ", "_").toLowerCase();
            String set = sa.getOriginalHost().getSetCode();
            copy.getCurrentState().setRarity(CardRarity.Token);
            copy.getCurrentState().setSetCode(set);
            copy.getCurrentState().setImageKey(ImageKeys.getTokenKey(name + "_" + set.toLowerCase()));
        } else {
            Card host = sa.getHostCard();
            int id = newOwner == null ? 0 : newOwner.getGame().nextCardId();
            copy = CardFactory.getCard(original.getPaperCard(), newOwner, id, host.getGame());
            if (original.isTransformable()) {
                copy.setBackSide(original.isBackSide());
                if (original.isTransformed()) {
                    copy.incrementTransformedTimestamp();
                }
            }
            copy.setStates(CardFactory.getCloneStates(original, copy, sa));
            if (original.isTransformable()) {
                copy.setState(original.isTransformed() ? CardStateName.Transformed : CardStateName.Original, true, true);
            } else {
                copy.setState(copy.getCurrentStateName(), true, true);
            }
        }
        copy.setTokenSpawningAbility(sa);
        copy.setGamePieceType(GamePieceType.TOKEN);
        return copy;
    }
}

