/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Iterables;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;

public class ControlSpellEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        PlayerCollection newController = ControlSpellEffect.getTargetPlayers(sa, "NewController");
        if (newController.isEmpty()) {
            newController.add(sa.getActivatingPlayer());
        }
        sb.append(newController).append(" gains control of ");
        for (SpellAbility spell : ControlSpellEffect.getTargetSpells(sa)) {
            Card c = spell.getHostCard();
            sb.append(" ");
            if (c.isFaceDown()) {
                sb.append("Morph");
                continue;
            }
            sb.append(c);
        }
        sb.append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.getHostCard();
        boolean exchange = sa.getParam("Mode").equals("Exchange");
        boolean remember = sa.hasParam("Remember");
        PlayerCollection controllers = ControlSpellEffect.getDefinedPlayersOrTargeted(sa, "NewController");
        Player newController = controllers.isEmpty() ? sa.getActivatingPlayer() : (Player)controllers.get(0);
        Game game = newController.getGame();
        for (SpellAbility spell : ControlSpellEffect.getTargetSpells(sa)) {
            GameObject obj;
            Card tgtC = spell.getHostCard();
            long tStamp = game.getNextTimestamp();
            SpellAbilityStackInstance si = game.getStack().getInstanceMatchingSpellAbilityID(spell);
            if (exchange && (obj = (GameObject)Iterables.getFirst(ControlSpellEffect.getDefinedOrTargeted(sa, "DefinedExchange"), null)) instanceof Card) {
                Card c = (Card)obj;
                if (!c.isInPlay() || si == null || !c.canBeControlledBy(si.getActivatingPlayer()) || c.getController().equals(si.getActivatingPlayer())) continue;
                if (remember) {
                    source.addRemembered(c);
                }
                c.addTempController(si.getActivatingPlayer(), tStamp);
                c.runChangeControllerCommands();
            }
            if (remember) {
                source.addRemembered(tgtC);
            }
            if (tgtC.getController() != newController) {
                tgtC.runChangeControllerCommands();
            }
            tgtC.addTempController(newController, tStamp);
            si.setActivatingPlayer(newController);
        }
    }
}

