/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Maps;
import forge.game.CardTraitBase;
import forge.game.Direction;
import forge.game.Game;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ControlGainVariantEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        return sa.getDescription();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.getHostCard();
        Game game = source.getGame();
        long tStamp = game.getNextTimestamp();
        String controller = sa.getParam("ChangeController");
        HashMap<Player, CardCollection> gainControl = Maps.newHashMap();
        PlayerCollection players = game.getPlayers();
        int aidx = players.indexOf(sa.getActivatingPlayer());
        if (aidx != -1) {
            Collections.rotate(players, -aidx);
        }
        CardCollection tgtCards = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), sa.getParam("AllValid"), source.getController(), source, (CardTraitBase)sa);
        if ("NextPlayerInChosenDirection".equals(controller) && source.getChosenDirection() != null) {
            for (Player player : players) {
                gainControl.put(player, CardLists.filterControlledBy((Iterable<Card>)tgtCards, game.getNextPlayerAfter(player, source.getChosenDirection())));
            }
        } else if ("CardOwner".equals(controller)) {
            for (Player player : players) {
                gainControl.put(player, CardLists.filter((Iterable<Card>)tgtCards, CardPredicates.isOwner(player)));
            }
        } else if ("Random".equals(controller)) {
            for (Card card : tgtCards) {
                Player p = Aggregates.random(players);
                if (gainControl.containsKey(p)) {
                    ((CardCollection)gainControl.get(p)).add(0, card);
                    continue;
                }
                gainControl.put(p, new CardCollection(card));
            }
        } else if ("ChooseNextPlayerInChosenDirection".equals(controller) && source.getChosenDirection() != null) {
            Player p = sa.getActivatingPlayer();
            do {
                CardCollection cardCollection = CardLists.filterControlledBy((Iterable<Card>)tgtCards, game.getNextPlayerAfter(p, source.getChosenDirection()));
                Card c = p.getController().chooseSingleEntityForEffect(cardCollection, sa, " ", null);
                if (c == null) continue;
                gainControl.put(p, new CardCollection(c));
            } while (!(p = game.getNextPlayerAfter(p, source.getChosenDirection())).equals(sa.getActivatingPlayer()));
        } else if ("ChooseFromPlayerToTheirRight".equals(controller)) {
            for (Player player : players) {
                CardCollection valid = CardLists.filterControlledBy((Iterable<Card>)tgtCards, game.getNextPlayerAfter(player, Direction.Right));
                Card c = sa.getActivatingPlayer().getController().chooseSingleEntityForEffect(valid, sa, "Choose one for the new Controller: " + player.getName(), null);
                if (c == null) continue;
                gainControl.put(player, new CardCollection(c));
            }
        }
        for (Map.Entry entry : gainControl.entrySet()) {
            Player newController = (Player)entry.getKey();
            for (Card tgtC : (CardCollection)entry.getValue()) {
                if (!tgtC.isInPlay() || !tgtC.canBeControlledBy(newController)) continue;
                tgtC.addTempController(newController, tStamp);
            }
        }
    }
}

