/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.GameCommand;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.event.GameEventCardStatsChanged;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.CardTranslation;
import forge.util.Localizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;

public class ControlGainEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        List<String> keywords;
        StringBuilder sb = new StringBuilder();
        PlayerCollection newController = ControlGainEffect.getDefinedPlayersOrTargeted(sa, "NewController");
        if (newController.isEmpty()) {
            newController.add(sa.getActivatingPlayer());
        }
        sb.append(newController.get(0)).append(" gains control of");
        CardCollectionView tgts = this.getDefinedCards(sa);
        if (tgts.isEmpty()) {
            sb.append(" (nothing)");
        } else {
            for (Card c : tgts) {
                sb.append(" ");
                if (c.isFaceDown()) {
                    sb.append("Face-down creature (").append(c.getId()).append(')');
                    continue;
                }
                sb.append(c);
            }
        }
        if (sa.hasParam("LoseControl")) {
            String loseCont = sa.getParam("LoseControl");
            if (loseCont.contains("EOT")) {
                sb.append(" until end of turn");
            } else if (loseCont.contains("Untap")) {
                sb.append(" for as long as ").append(sa.getHostCard()).append(" remains tapped");
            } else if (loseCont.contains("LoseControl")) {
                sb.append(" for as long as you control ").append(sa.getHostCard());
            } else if (loseCont.contains("LeavesPlay")) {
                sb.append(" for as long as ").append(sa.getHostCard()).append("remains on the battlefield");
            } else if (loseCont.equals("StaticCommandCheck")) {
                sb.append(" for as long as that creature remains enchanted");
            } else if (loseCont.equals("UntilTheEndOfYourNextTurn")) {
                sb.append(" until the end of your next turn");
            }
        }
        sb.append(".");
        if (sa.hasParam("Untap")) {
            sb.append(" Untap it.");
        }
        List<String> list = keywords = sa.hasParam("AddKWs") ? Arrays.asList(sa.getParam("AddKWs").split(" & ")) : null;
        if (sa.hasParam("AddKWs")) {
            sb.append(" It gains ");
            for (int i = 0; i < keywords.size(); ++i) {
                sb.append(keywords.get(i).toLowerCase());
                sb.append(keywords.size() > 2 && i + 1 != keywords.size() ? ", " : "");
                sb.append(keywords.size() == 2 && i == 0 ? " " : "");
                sb.append(i + 2 == keywords.size() ? "and " : "");
            }
            sb.append(" until end of turn.");
        }
        return sb.toString();
    }

    private static void doLoseControl(Card c, Card host, long tStamp) {
        if (null == c || c.hasKeyword("Other players can't gain control of CARDNAME.")) {
            return;
        }
        Game game = host.getGame();
        if (c.isInPlay()) {
            c.removeTempController(tStamp);
            game.getAction().controllerChangeZoneCorrection(c);
        }
        host.removeGainControlTargets(c);
    }

    @Override
    public void resolve(SpellAbility sa) {
        CardCollectionView tgtCards;
        Card source = sa.getHostCard();
        Player activator = sa.getActivatingPlayer();
        boolean bUntap = sa.hasParam("Untap");
        boolean remember = sa.hasParam("RememberControlled");
        boolean forget = sa.hasParam("ForgetControlled");
        List<String> keywords = sa.hasParam("AddKWs") ? Arrays.asList(sa.getParam("AddKWs").split(" & ")) : null;
        List<String> lose = sa.hasParam("LoseControl") ? Arrays.asList(sa.getParam("LoseControl").split(",")) : null;
        PlayerCollection controllers = ControlGainEffect.getDefinedPlayersOrTargeted(sa, "NewController");
        Player newController = controllers.isEmpty() ? activator : (Player)controllers.get(0);
        Game game = newController.getGame();
        if (sa.hasParam("Choices")) {
            Player chooser = sa.hasParam("Chooser") ? (Player)AbilityUtils.getDefinedPlayers(source, sa.getParam("Chooser"), sa).get(false) : activator;
            CardCollection choices = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), sa.getParam("Choices"), activator, source, (CardTraitBase)sa);
            if (choices.isEmpty()) {
                return;
            }
            String title = sa.hasParam("ChoiceTitle") ? sa.getParam("ChoiceTitle") : Localizer.getInstance().getMessage("lblChooseaCard", new Object[0]) + " ";
            tgtCards = chooser.getController().chooseCardsForEffect(choices, sa, title, 1, 1, false, null);
        } else {
            tgtCards = this.getDefinedCards(sa);
        }
        if (tgtCards != null & sa.hasParam("ControlledByTarget")) {
            tgtCards = CardLists.filterControlledBy((Iterable<Card>)tgtCards, ControlGainEffect.getTargetPlayers(sa));
        }
        if (lose != null && lose.contains("LeavesPlay") && !source.isInPlay()) {
            return;
        }
        if (lose != null && lose.contains("LoseControl") && source.getController() != sa.getActivatingPlayer()) {
            return;
        }
        if (lose != null && lose.contains("Untap") && !source.isTapped()) {
            return;
        }
        CardCollection untapped = new CardCollection();
        for (final Card tgtC : tgtCards) {
            if (!tgtC.isInPlay() || !tgtC.canBeControlledBy(newController) || tgtC.isPhasedOut() || sa.hasParam("Optional") && !activator.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblGainControlConfirm", newController, CardTranslation.getTranslatedName(tgtC.getName())), null)) continue;
            if (!tgtC.equals(source) && !source.getGainControlTargets().contains(tgtC)) {
                source.addGainControlTarget(tgtC);
            }
            final long tStamp = game.getNextTimestamp();
            tgtC.addTempController(newController, tStamp);
            if (bUntap && tgtC.untap(true)) {
                untapped.add(tgtC);
            }
            if (keywords != null) {
                tgtC.addChangedCardKeywords(keywords, Lists.newArrayList(), false, tStamp, null);
                game.fireEvent(new GameEventCardStatsChanged(tgtC));
            }
            if (remember && !source.isRemembered(tgtC)) {
                source.addRemembered(tgtC);
            }
            if (forget && source.isRemembered(tgtC)) {
                source.removeRemembered(tgtC);
            }
            if (lose != null) {
                GameCommand loseControl = ControlGainEffect.getLoseControlCommand(tgtC, tStamp, source);
                if (lose.contains("LeavesPlay") && source != tgtC) {
                    source.addLeavesPlayCommand(loseControl);
                }
                if (lose.contains("Untap")) {
                    source.addUntapCommand(loseControl);
                }
                if (lose.contains("LoseControl")) {
                    source.addChangeControllerCommand(loseControl);
                }
                if (lose.contains("EOT")) {
                    game.getEndOfTurn().addUntil(loseControl);
                    tgtC.addChangedSVars(Collections.singletonMap("SacMe", "6"), tStamp, 0L);
                }
                if (lose.contains("EndOfCombat")) {
                    game.getEndOfCombat().addUntil(loseControl);
                    tgtC.addChangedSVars(Collections.singletonMap("SacMe", "6"), tStamp, 0L);
                }
                if (lose.contains("StaticCommandCheck")) {
                    String leftVar = sa.getSVar(sa.getParam("StaticCommandCheckSVar"));
                    String rightVar = sa.getParam("StaticCommandSVarCompare");
                    source.addStaticCommandList(new Object[]{leftVar, rightVar, tgtC, loseControl});
                }
                if (lose.contains("UntilSourceUnattached")) {
                    Card attachment = (Card)sa.getTriggeringObject(AbilityKey.Source);
                    attachment.addLeavesPlayCommand(loseControl);
                    attachment.addPhaseOutCommand(loseControl);
                    attachment.addUnattachCommand(loseControl);
                }
                if (lose.contains("UntilTheEndOfYourNextTurn")) {
                    if (game.getPhaseHandler().isPlayerTurn(sa.getActivatingPlayer())) {
                        game.getEndOfTurn().registerUntilEnd(sa.getActivatingPlayer(), loseControl);
                    } else {
                        game.getEndOfTurn().addUntilEnd(sa.getActivatingPlayer(), loseControl);
                    }
                }
            }
            if (keywords != null) {
                GameCommand untilKeywordEOT = new GameCommand(){
                    private static final long serialVersionUID = -42244224L;

                    @Override
                    public void run() {
                        tgtC.removeChangedCardKeywords(tStamp, 0L);
                    }
                };
                game.getEndOfTurn().addUntil(untilKeywordEOT);
            }
            game.getAction().controllerChangeZoneCorrection(tgtC);
        }
        if (!untapped.isEmpty()) {
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            HashMap<Player, CardCollection> map = Maps.newHashMap();
            map.put(activator, untapped);
            runParams.put(AbilityKey.Map, map);
            game.getTriggerHandler().runTrigger(TriggerType.UntapAll, runParams, false);
        }
    }

    private static GameCommand getLoseControlCommand(final Card c, final long tStamp, final Card hostCard) {
        GameCommand loseControl = new GameCommand(){
            private static final long serialVersionUID = 878543373519872418L;

            @Override
            public void run() {
                ControlGainEffect.doLoseControl(c, hostCard, tStamp);
                c.removeChangedSVars(tStamp, 0L);
            }
        };
        return loseControl;
    }

    private CardCollectionView getDefinedCards(SpellAbility sa) {
        Game game = sa.getHostCard().getGame();
        if (sa.hasParam("AllValid")) {
            return AbilityUtils.filterListByType(game.getCardsIn(ZoneType.Battlefield), sa.getParam("AllValid"), sa);
        }
        return ControlGainEffect.getDefinedCardsOrTargeted(sa);
    }
}

