/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.event.GameEventRandomLog;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.util.CardTranslation;
import forge.util.Localizer;

public class CleanUpEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.hasParam("Defined") ? (Card)CleanUpEffect.getDefinedCardsOrTargeted(sa).get(false) : sa.getHostCard();
        Game game = source.getGame();
        String logMessage = "";
        if (sa.hasParam("Log")) {
            logMessage = this.logOutput(sa, source);
        }
        if (sa.hasParam("ClearRemembered")) {
            source.clearRemembered();
            game.getCardState(source).clearRemembered();
        }
        if (sa.hasParam("ForgetDefined")) {
            for (GameEntity ge : AbilityUtils.getDefinedEntities(source, sa.getParam("ForgetDefined"), (CardTraitBase)sa)) {
                source.removeRemembered(ge);
            }
        }
        if (sa.hasParam("ClearImprinted")) {
            source.clearImprintedCards();
            game.getCardState(source).clearImprintedCards();
        }
        if (sa.hasParam("ClearTriggered")) {
            game.getTriggerHandler().clearDelayedTrigger(source);
        }
        if (sa.hasParam("ClearCoinFlips")) {
            source.clearFlipResult();
        }
        if (sa.hasParam("ClearChosenCard")) {
            source.setChosenCards(null);
        }
        if (sa.hasParam("ClearChosenPlayer")) {
            source.setChosenPlayer(null);
        }
        if (sa.hasParam("ClearChosenType")) {
            source.setChosenType("");
            source.setChosenType2("");
        }
        if (sa.hasParam("ClearChosenColor")) {
            source.setChosenColors(null);
        }
        if (sa.hasParam("ClearNamedCard")) {
            source.setNamedCards(Lists.newArrayList());
        }
        if (sa.hasParam("Log")) {
            source.getController().getGame().fireEvent(new GameEventRandomLog(logMessage));
        }
    }

    protected String logOutput(SpellAbility sa, Card source) {
        String chPlay;
        String chCard;
        StringBuilder log = new StringBuilder();
        String name = CardTranslation.getTranslatedName(source.getName());
        String linebreak = "\r\n";
        if (sa.hasParam("ClearRemembered") && source.getRememberedCount() != 0) {
            for (Object o : source.getRemembered()) {
                String rem = o.toString();
                if (o instanceof Card) {
                    log.append(log.length() > 0 ? linebreak : "");
                    log.append(Localizer.getInstance().getMessage("lblChosenCard", name, rem));
                    continue;
                }
                if (!(o instanceof Player)) continue;
                log.append(log.length() > 0 ? linebreak : "");
                log.append(Localizer.getInstance().getMessage("lblChosenPlayer", name, rem));
            }
        }
        String string = chCard = sa.hasParam("ClearChosenCard") && source.hasChosenCard() ? source.getChosenCards().toString().replace("[", "").replace("]", "") : "";
        if (chCard.length() > 0 && !log.toString().contains(chCard)) {
            log.append(log.length() > 0 ? linebreak : "");
            String message = source.getChosenCards().size() > 1 ? "lblChosenMultiCard" : "lblChosenCard";
            log.append(Localizer.getInstance().getMessage(message, name, chCard));
        }
        String string2 = chPlay = sa.hasParam("ClearChosenPlayer") && source.hasChosenPlayer() ? source.getChosenPlayer().toString() : "";
        if (chPlay.length() > 0 && !log.toString().contains(chPlay)) {
            log.append(log.length() > 0 ? linebreak : "");
            log.append(Localizer.getInstance().getMessage("lblChosenPlayer", name, chPlay));
        }
        log.append(log.length() > 0 ? "" : Localizer.getInstance().getMessage("lblNoValidChoice", name));
        return log.toString();
    }
}

