/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.GameLogEntryType;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.util.Aggregates;
import forge.util.Lang;
import forge.util.Localizer;

public class ChoosePlayerEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Lang.joinHomogenous(ChoosePlayerEffect.getTargetPlayers(sa)));
        sb.append("chooses a player.");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card card = sa.getHostCard();
        Game game = card.getGame();
        PlayerCollection choices = sa.hasParam("Choices") ? AbilityUtils.getDefinedPlayers(card, sa.getParam("Choices"), sa) : game.getPlayersInTurnOrder();
        String choiceDesc = sa.hasParam("ChoiceTitle") ? sa.getParam("ChoiceTitle") : Localizer.getInstance().getMessage("lblChoosePlayer", new Object[0]);
        boolean random = sa.hasParam("Random");
        boolean secret = sa.hasParam("Secretly");
        for (Player p : ChoosePlayerEffect.getTargetPlayers(sa)) {
            Player chosen;
            if (!p.isInGame()) continue;
            if (random) {
                chosen = choices.isEmpty() ? null : Aggregates.random(choices);
            } else {
                Player player = chosen = choices.isEmpty() ? null : p.getController().chooseSingleEntityForEffect(choices, sa, choiceDesc, sa.hasParam("Optional"), null);
            }
            if (null != chosen) {
                SpellAbility chosenSA;
                if (secret) {
                    card.setSecretChosenPlayer(chosen);
                } else if (sa.hasParam("Protect")) {
                    card.setProtectingPlayer(chosen);
                } else {
                    card.setChosenPlayer(chosen);
                }
                if (sa.hasParam("ForgetOtherRemembered")) {
                    card.clearRemembered();
                }
                if (sa.hasParam("RememberChosen")) {
                    card.addRemembered(chosen);
                }
                if (!secret) {
                    if (sa.hasParam("DontNotify")) {
                        game.getGameLog().add(GameLogEntryType.INFORMATION, Localizer.getInstance().getMessage("lblPlayerPickedChosen", sa.getActivatingPlayer(), chosen));
                    } else {
                        game.getAction().notifyOfValue(sa, p, Localizer.getInstance().getMessage("lblPlayerPickedChosen", sa.getActivatingPlayer(), chosen), null);
                    }
                }
                if ((chosenSA = sa.getAdditionalAbility("ChooseSubAbility")) == null) continue;
                if (!chosenSA.getHostCard().equals(sa.getHostCard())) {
                    System.out.println("Warning: ChooseSubAbility had the wrong host set (potentially after cloning the root SA), attempting to correct...");
                    chosenSA.setHostCard(sa.getHostCard());
                }
                AbilityUtils.resolve(chosenSA);
                continue;
            }
            SpellAbility notChosenSA = sa.getAdditionalAbility("CantChooseSubAbility");
            if (notChosenSA == null) continue;
            if (!notChosenSA.getHostCard().equals(sa.getHostCard())) {
                System.out.println("Warning: CantChooseSubAbility had the wrong host set (potentially after cloning the root SA), attempting to correct...");
                notChosenSA.setHostCard(sa.getHostCard());
            }
            AbilityUtils.resolve(notChosenSA);
        }
    }
}

