/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class ChooseNumberEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Lang.joinHomogenous(ChooseNumberEffect.getTargetPlayers(sa)));
        sb.append(" chooses a number.");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.getHostCard();
        boolean random = sa.hasParam("Random");
        boolean anyNumber = sa.hasParam("ChooseAnyNumber");
        boolean secretlyChoose = sa.hasParam("Secretly");
        String sMin = sa.getParamOrDefault("Min", "0");
        int min2 = AbilityUtils.calculateAmount(source, sMin, sa);
        String sMax = sa.getParamOrDefault("Max", "99");
        int max = AbilityUtils.calculateAmount(source, sMax, sa);
        HashMap<Player, Integer> chooseMap = Maps.newHashMap();
        boolean guessedCorrect = false;
        Pair<Player, Integer> guessPair = null;
        ArrayList<Integer> choices = new ArrayList<Integer>();
        for (Player p : ChooseNumberEffect.getTargetPlayers(sa)) {
            Player guesser;
            Integer chosen;
            if (!p.isInGame()) continue;
            if (random) {
                chosen = MyRandom.getRandom().nextInt(max - min2 + 1) + min2;
                p.getGame().getAction().notifyOfValue(sa, p, Integer.toString(chosen), null);
            } else {
                String title;
                String string = title = sa.hasParam("ListTitle") ? sa.getParam("ListTitle") : Localizer.getInstance().getMessage("lblChooseNumber", new Object[0]);
                if (anyNumber) {
                    Integer value = p.getController().announceRequirements(sa, title);
                    chosen = value == null ? 0 : value;
                } else if (sa.hasParam("RemoveChoices")) {
                    for (int i = min2; i <= max; ++i) {
                        choices.add(i);
                    }
                    for (Object o : source.getRemembered()) {
                        if (!(o instanceof Integer)) continue;
                        choices.remove((Integer)o);
                    }
                    if (choices.isEmpty()) continue;
                    chosen = p.getController().chooseNumber(sa, title, choices, null);
                } else {
                    chosen = p.getController().chooseNumber(sa, title, min2, max);
                }
            }
            if (secretlyChoose && sa.hasParam("KeepSecret")) {
                source.setChosenNumber(chosen, true);
            } else if (secretlyChoose) {
                chooseMap.put(p, chosen);
            } else {
                source.setChosenNumber(chosen, false);
            }
            if (sa.hasParam("Notify")) {
                p.getGame().getAction().notifyOfValue(sa, source, Localizer.getInstance().getMessage("lblPlayerPickedChosen", p.getName(), chosen), p);
            }
            if (!sa.hasParam("Guesser") || chosen == null) continue;
            PlayerCollection gChoices = AbilityUtils.getDefinedPlayers(source, sa.getParam("Guesser"), sa);
            Player player = guesser = choices.isEmpty() ? null : p.getController().chooseSingleEntityForEffect(gChoices, sa, Localizer.getInstance().getMessage("lblChoosePlayer", new Object[0]), false, null);
            if (guesser != null && chooseMap.containsValue((guessPair = Pair.of(guesser, guesser.getController().chooseNumber(sa, Localizer.getInstance().getMessage("lblChooseNumber", new Object[0]), choices, null))).getValue())) {
                guessedCorrect = true;
            }
            source.getGame().incPiledGuessedSA();
        }
        if (secretlyChoose && !chooseMap.isEmpty()) {
            SpellAbility sub;
            StringBuilder sb = new StringBuilder();
            ArrayList<Player> highestNum = Lists.newArrayList();
            ArrayList<Player> lowestNum = Lists.newArrayList();
            int highest = 0;
            int lowest = Integer.MAX_VALUE;
            if (guessPair != null) {
                sb.append(Localizer.getInstance().getMessage("lblPlayerGuessedNum", ((Player)guessPair.getKey()).getName(), String.valueOf(guessPair.getValue())));
                sb.append("\r\n");
            }
            for (Map.Entry ev : chooseMap.entrySet()) {
                int num = (Integer)ev.getValue();
                Player player = (Player)ev.getKey();
                sb.append(Localizer.getInstance().getMessage("lblPlayerChoseNum", player.getName(), String.valueOf(num)));
                sb.append("\r\n");
                if (num > highest) {
                    highestNum.clear();
                    highest = num;
                }
                if (num == highest) {
                    highestNum.add(player);
                }
                if (num < lowest) {
                    lowestNum.clear();
                    lowest = num;
                }
                if (num != lowest) continue;
                lowestNum.add(player);
            }
            boolean matched = highestNum.size() == chooseMap.size();
            source.getGame().getAction().notifyOfValue(sa, source, sb.toString(), null);
            if (sa.hasParam("ChooseNumberSubAbility")) {
                sub = sa.getAdditionalAbility("ChooseNumberSubAbility");
                for (Player player : chooseMap.keySet()) {
                    source.addRemembered(player);
                    source.setChosenNumber((Integer)chooseMap.get(player));
                    AbilityUtils.resolve(sub);
                    source.clearRemembered();
                }
            }
            if (sa.hasParam("Lowest")) {
                sub = sa.getAdditionalAbility("Lowest");
                for (Player player : lowestNum) {
                    source.addRemembered(player);
                    source.setChosenNumber(lowest);
                    AbilityUtils.resolve(sub);
                    source.clearRemembered();
                }
            }
            if (sa.hasParam("NotLowest")) {
                ArrayList<Player> notLowestNum = Lists.newArrayList();
                for (Player player : chooseMap.keySet()) {
                    if (lowestNum.contains(player)) continue;
                    notLowestNum.add(player);
                }
                SpellAbility sub2 = sa.getAdditionalAbility("NotLowest");
                for (Player player : notLowestNum) {
                    source.addRemembered(player);
                    AbilityUtils.resolve(sub2);
                    source.clearRemembered();
                }
            }
            if (sa.hasParam("Highest")) {
                sub = sa.getAdditionalAbility("Highest");
                for (Player player : highestNum) {
                    source.addRemembered(player);
                    source.setChosenNumber(highest);
                    AbilityUtils.resolve(sub);
                    source.clearRemembered();
                }
                if (sa.hasParam("RememberHighest")) {
                    source.addRemembered(highestNum);
                }
            }
            if (sa.hasParam("GuessCorrect") && guessedCorrect) {
                sub = sa.getAdditionalAbility("GuessCorrect");
                AbilityUtils.resolve(sub);
            }
            if (sa.hasParam("GuessWrong") && guessPair != null && !guessedCorrect) {
                sub = sa.getAdditionalAbility("GuessWrong");
                source.setChosenNumber((Integer)guessPair.getValue());
                source.addRemembered(guessPair.getKey());
                AbilityUtils.resolve(sub);
                source.clearChosenNumber();
                source.removeRemembered(guessPair.getKey());
            }
            if (matched && sa.hasParam("MatchedAbility")) {
                sub = sa.getAdditionalAbility("MatchedAbility");
                AbilityUtils.resolve(sub);
            }
            if (!matched && sa.hasParam("UnmatchedAbility")) {
                sub = sa.getAdditionalAbility("UnmatchedAbility");
                AbilityUtils.resolve(sub);
            }
        }
        if (sa.hasParam("RememberChosen")) {
            source.addRemembered(chooseMap.values());
        }
    }
}

