/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.game.Game;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardDamageMap;
import forge.game.card.CardZoneTable;
import forge.game.cost.Cost;
import forge.game.event.GameEventCardModeChosen;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.util.Aggregates;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.List;

public class ChooseGenericEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        PlayerCollection players = ChooseGenericEffect.getDefinedPlayersOrTargeted(sa);
        sb.append(Lang.joinHomogenous(players));
        sb.append(players.size() == 1 ? " chooses" : " choose").append(" from a list.");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        ArrayList<SpellAbility> abilities = Lists.newArrayList(sa.getAdditionalAbilityList("Choices"));
        if (sa.hasParam("NumRandomChoices")) {
            int n = AbilityUtils.calculateAmount(host, sa.getParam("NumRandomChoices"), sa);
            while (abilities.size() > n) {
                Aggregates.removeRandom(abilities);
            }
        }
        SpellAbility fallback = sa.getAdditionalAbility("FallbackAbility");
        int amount = AbilityUtils.calculateAmount(host, sa.getParamOrDefault("ChoiceAmount", "1"), sa);
        boolean tempRem = sa.hasParam("TempRemember");
        boolean secretly = sa.hasParam("Secretly");
        StringBuilder record = new StringBuilder();
        boolean changeZoneTable = sa.hasParam("ChangeZoneTable");
        boolean damageMap = sa.hasParam("DamageMap");
        if (damageMap) {
            sa.setDamageMap(new CardDamageMap());
            sa.setPreventMap(new CardDamageMap());
            sa.setCounterTable(new GameEntityCounterTable());
        }
        if (changeZoneTable) {
            sa.setChangeZoneTable(new CardZoneTable());
        }
        for (Player p : ChooseGenericEffect.getDefinedPlayersOrTargeted(sa)) {
            if (!p.isInGame()) {
                p = ChooseGenericEffect.getNewChooser(sa, sa.getActivatingPlayer(), p);
            }
            ArrayList<SpellAbility> saToRemove = Lists.newArrayList();
            for (SpellAbility saChoice : abilities) {
                Cost unlessCost;
                if (saChoice.getRestrictions() != null && !saChoice.getRestrictions().checkOtherRestrictions(host, saChoice, sa.getActivatingPlayer())) {
                    saToRemove.add(saChoice);
                    continue;
                }
                if (!saChoice.hasParam("UnlessCost") || (unlessCost = new Cost(saChoice.getParam("UnlessCost"), false)).canPay(sa, p, true)) continue;
                saToRemove.add(saChoice);
            }
            abilities.removeAll(saToRemove);
            List<Object> chosenSAs = Lists.newArrayList();
            String prompt = sa.getParamOrDefault("ChoicePrompt", "Choose");
            boolean random = false;
            if (sa.hasParam("AtRandom")) {
                random = true;
                chosenSAs = Aggregates.random(abilities, amount);
                int i = 0;
                while (sa.getParam("AtRandom").equals("Urza") && i < chosenSAs.size()) {
                    if (!((SpellAbility)chosenSAs.get(i)).usesTargeting()) {
                        ++i;
                        continue;
                    }
                    if (((SpellAbility)chosenSAs.get(i)).getTargetRestrictions().hasCandidates((SpellAbility)chosenSAs.get(i))) {
                        p.getController().chooseTargetsFor((SpellAbility)chosenSAs.get(i));
                        ++i;
                        continue;
                    }
                    chosenSAs.set(i, Aggregates.random(abilities));
                }
            } else if (!abilities.isEmpty()) {
                chosenSAs = p.getController().chooseSpellAbilitiesForEffect(abilities, sa, prompt, amount, ImmutableMap.of());
            }
            ArrayList<Player> oldRem = Lists.newArrayList(Iterables.filter(host.getRemembered(), Player.class));
            if (tempRem) {
                host.removeRemembered(oldRem);
                host.addRemembered(p);
            }
            if (!chosenSAs.isEmpty()) {
                for (SpellAbility spellAbility : chosenSAs) {
                    String chosenValue = spellAbility.getDescription();
                    if (sa.hasParam("ShowChoice")) {
                        boolean dontNotifySelf = sa.getParam("ShowChoice").equals("ExceptSelf");
                        game.getAction().notifyOfValue(sa, p, chosenValue, dontNotifySelf ? p : null);
                    } else if (secretly) {
                        if (record.length() > 0) {
                            record.append("\r\n");
                        }
                        record.append(Localizer.getInstance().getMessage("lblPlayerChooseValue", p, chosenValue));
                    }
                    if (sa.hasParam("SetChosenMode")) {
                        sa.getHostCard().setChosenMode(chosenValue);
                    }
                    game.fireEvent(new GameEventCardModeChosen(p, host.getName(), chosenValue, sa.hasParam("ShowChoice"), random));
                    AbilityUtils.resolve(spellAbility);
                }
            } else if (fallback != null) {
                game.fireEvent(new GameEventCardModeChosen(p, host.getName(), fallback.getDescription(), sa.hasParam("ShowChoice"), random));
                AbilityUtils.resolve(fallback);
            } else if (!random) {
                System.err.println("Warning: all Unless costs were unpayable for " + host.getName() + ", but it had no FallbackAbility defined. Doing nothing (this is most likely incorrect behavior).");
            }
            if (!tempRem) continue;
            host.removeRemembered(p);
            host.addRemembered(oldRem);
        }
        if (secretly) {
            game.getAction().notifyOfValue(sa, host, record.toString(), null);
        }
        if (damageMap) {
            game.getAction().dealDamage(false, sa.getDamageMap(), sa.getPreventMap(), sa.getCounterTable(), sa);
        }
        if (changeZoneTable) {
            sa.getChangeZoneTable().triggerChangesZoneAll(game, sa);
            sa.setChangeZoneTable(null);
        }
        if (sa.hasParam("Guess")) {
            game.incPiledGuessedSA();
        }
    }
}

