/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.card.MagicColor;
import forge.deck.DeckRecognizer;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.util.Aggregates;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ChooseColorEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Lang.joinHomogenous(ChooseColorEffect.getTargetPlayers(sa)));
        sb.append("chooses a color");
        if (sa.hasParam("OrColors")) {
            sb.append(" or colors");
        }
        sb.append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card card = sa.getHostCard();
        List<String> colorChoices = new ArrayList<String>(MagicColor.Constant.ONLY_COLORS);
        if (sa.hasParam("Choices")) {
            String[] restrictedChoices = sa.getParam("Choices").split(",");
            colorChoices = Arrays.asList(restrictedChoices);
        }
        if (sa.hasParam("Exclude")) {
            for (String s2 : sa.getParam("Exclude").split(",")) {
                colorChoices.remove(s2);
            }
        }
        for (Player p : ChooseColorEffect.getTargetPlayers(sa)) {
            int cntMin;
            if (!p.isInGame()) {
                p = ChooseColorEffect.getNewChooser(sa, sa.getActivatingPlayer(), p);
            }
            List<Object> chosenColors = new ArrayList();
            int n = cntMin = sa.hasParam("TwoColors") ? 2 : 1;
            int cntMax = sa.hasParam("TwoColors") ? 2 : (sa.hasParam("OrColors") ? colorChoices.size() : 1);
            String prompt = null;
            prompt = cntMax == 1 ? Localizer.getInstance().getMessage("lblChooseAColor", new Object[0]) : (cntMax > cntMin ? (cntMax >= 5 ? Localizer.getInstance().getMessage("lblAtLastChooseNumColors", Lang.getNumeral(cntMin)) : Localizer.getInstance().getMessage("lblChooseSpecifiedRangeColors", Lang.getNumeral(cntMin), Lang.getNumeral(cntMax))) : Localizer.getInstance().getMessage("lblChooseNColors", Lang.getNumeral(cntMax)));
            Player noNotify = p;
            if (sa.hasParam("Random")) {
                for (int i = 0; i < cntMin; ++i) {
                    String choice = Aggregates.random(colorChoices);
                    colorChoices.remove(choice);
                    chosenColors.add(choice);
                }
                noNotify = null;
            } else {
                chosenColors = p.getController().chooseColors(prompt, sa, cntMin, cntMax, colorChoices);
            }
            if (chosenColors.isEmpty()) {
                return;
            }
            card.setChosenColors(chosenColors);
            chosenColors = chosenColors.stream().map(DeckRecognizer::getLocalisedMagicColorName).collect(Collectors.toList());
            p.getGame().getAction().notifyOfValue(sa, p, Lang.joinHomogenous(chosenColors), noNotify);
        }
    }
}

