/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.card.CardType;
import forge.game.CardTraitBase;
import forge.game.Direction;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.player.DelayedReveal;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerView;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.CardTranslation;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ChooseCardEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        int numCards = sa.hasParam("Amount") ? AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("Amount"), sa) : 1;
        sb.append(Lang.joinHomogenous(ChooseCardEffect.getTargetPlayers(sa))).append(" ");
        if (sa.hasParam("Mandatory")) {
            sb.append(ChooseCardEffect.getTargetPlayers(sa).size() == 1 ? "chooses " : "choose ");
        } else {
            sb.append("may choose ");
        }
        String desc = sa.getParamOrDefault("ChoiceDesc", "card");
        if (!desc.contains("card") && !desc.contains("control")) {
            desc = desc + " card";
        }
        sb.append(Lang.nounWithNumeralExceptOne(numCards, desc));
        if (sa.hasParam("FromDesc")) {
            sb.append(" from ").append(sa.getParam("FromDesc"));
        } else if (sa.hasParam("ChoiceZone") && sa.getParam("ChoiceZone").equals("Hand")) {
            sb.append(" in their hand");
        }
        sb.append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        int minAmount;
        String amountValue;
        CardCollectionView choices;
        Card host = sa.getHostCard();
        Player activator = sa.getActivatingPlayer();
        Game game = activator.getGame();
        CardCollection allChosen = new CardCollection();
        PlayerCollection tgtPlayers = ChooseCardEffect.getDefinedPlayersOrTargeted(sa);
        List<ZoneType> choiceZone = Lists.newArrayList(ZoneType.Battlefield);
        if (sa.hasParam("ChoiceZone")) {
            choiceZone = ZoneType.listValueOf(sa.getParam("ChoiceZone"));
        }
        CardCollectionView cardCollectionView = choices = sa.hasParam("AllCards") ? game.getCardsInGame() : game.getCardsIn(choiceZone);
        if (sa.hasParam("Choices")) {
            choices = CardLists.getValidCards((Iterable<Card>)choices, sa.getParam("Choices"), activator, host, (CardTraitBase)sa);
        }
        if (sa.hasParam("TargetControls")) {
            choices = CardLists.filterControlledBy((Iterable<Card>)choices, (Player)tgtPlayers.get(0));
        }
        if (sa.hasParam("DefinedCards")) {
            choices = AbilityUtils.getDefinedCards(host, sa.getParam("DefinedCards"), sa);
        }
        if (sa.hasParam("IncludeSpellsOnStack")) {
            CardCollectionView stack = game.getCardsIn(ZoneType.Stack);
            CardCollection combined = new CardCollection();
            combined.addAll(stack);
            combined.addAll(choices);
            choices = combined;
        }
        int validAmount = (amountValue = sa.getParamOrDefault("Amount", "1")).equals("Random") ? Aggregates.randomInt(0, choices.size()) : AbilityUtils.calculateAmount(host, amountValue, sa);
        int n = minAmount = sa.hasParam("MinAmount") ? Integer.parseInt(sa.getParam("MinAmount")) : validAmount;
        if (validAmount <= 0) {
            return;
        }
        boolean revealTitle = sa.hasParam("RevealTitle");
        for (Player p : tgtPlayers) {
            CardCollection chosenPool;
            CardCollection valids;
            Card c;
            CardCollectionView pChoices = choices;
            CardCollection chosen = new CardCollection();
            if (!p.isInGame()) {
                p = ChooseCardEffect.getNewChooser(sa, activator, p);
            }
            if (sa.hasParam("ControlledByPlayer")) {
                String param = sa.getParam("ControlledByPlayer");
                pChoices = param.equals("Chooser") ? CardLists.filterControlledBy((Iterable<Card>)pChoices, p) : (param.equals("Left") || param.equals("Right") ? CardLists.filterControlledBy((Iterable<Card>)pChoices, game.getNextPlayerAfter(p, Direction.valueOf(param))) : CardLists.filterControlledBy((Iterable<Card>)pChoices, AbilityUtils.getDefinedPlayers(host, param, sa)));
            }
            boolean dontRevealToOwner = true;
            if (sa.hasParam("EachBasicType")) {
                CardCollection land = CardLists.filter((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.LANDS);
                String eachBasic = sa.getParam("EachBasicType");
                if (eachBasic.equals("Controlled")) {
                    land = CardLists.filterControlledBy((Iterable<Card>)land, p);
                }
                for (String type : CardType.getBasicTypes()) {
                    CardCollection cl = CardLists.getType(land, type);
                    if (cl.isEmpty()) continue;
                    String prompt = Localizer.getInstance().getMessage("lblChoose", new Object[0]) + " " + Lang.nounWithAmount(1, type);
                    c = p.getController().chooseSingleEntityForEffect(cl, sa, prompt, false, null);
                    if (c == null) continue;
                    chosen.add(c);
                }
            } else if (sa.hasParam("ChooseEach")) {
                String[] types;
                String[] stringArray;
                String s2 = sa.getParam("ChooseEach");
                if (s2.equals("Party")) {
                    String[] stringArray2 = new String[4];
                    stringArray2[0] = "Cleric";
                    stringArray2[1] = "Thief";
                    stringArray2[2] = "Warrior";
                    stringArray = stringArray2;
                    stringArray2[3] = "Wizard";
                } else {
                    stringArray = s2.split(" & ");
                }
                for (String type : types = stringArray) {
                    valids = CardLists.filter((Iterable<Card>)pChoices, CardPredicates.isType(type));
                    if (valids.isEmpty()) continue;
                    String prompt = Localizer.getInstance().getMessage("lblChoose", new Object[0]) + " " + Lang.nounWithNumeralExceptOne(1, type);
                    Card c2 = p.getController().chooseSingleEntityForEffect(valids, sa, prompt, !sa.hasParam("Mandatory"), null);
                    if (c2 == null) continue;
                    chosen.add(c2);
                }
            } else if (sa.hasParam("WithTotalPower")) {
                int totP = AbilityUtils.calculateAmount(host, sa.getParam("WithTotalPower"), sa);
                CardCollection negativeCreats = CardLists.filterLEPower(p.getCreaturesInPlay(), -1);
                int negativeNum = Aggregates.sum(negativeCreats, Card::getNetPower);
                CardCollection creature = CardLists.filterLEPower(p.getCreaturesInPlay(), totP - negativeNum);
                CardCollection chosenPool2 = new CardCollection();
                int chosenP = 0;
                while (!creature.isEmpty()) {
                    c = p.getController().chooseSingleEntityForEffect(creature, sa, Localizer.getInstance().getMessage("lblSelectCreatureWithTotalPowerLessOrEqualTo", totP - chosenP - negativeNum) + "\r\n(" + Localizer.getInstance().getMessage("lblSelected", new Object[0]) + ":" + chosenPool2 + ")\r\n(" + Localizer.getInstance().getMessage("lblTotalPowerNum", chosenP) + ")", chosenP <= totP, null);
                    if (c == null) {
                        if (!p.getController().confirmAction(sa, PlayerActionConfirmMode.OptionalChoose, Localizer.getInstance().getMessage("lblCancelChooseConfirm", new Object[0]), null)) continue;
                        break;
                    }
                    chosenP += c.getNetPower();
                    chosenPool2.add(c);
                    negativeCreats.remove(c);
                    negativeNum = Aggregates.sum(negativeCreats, Card::getNetPower);
                    creature = CardLists.filterLEPower(p.getCreaturesInPlay(), totP - chosenP - negativeNum);
                    creature.removeAll(chosenPool2);
                }
                chosen.addAll(chosenPool2);
            } else if (sa.hasParam("WithDifferentPowers")) {
                String restrict = sa.getParam("Choices");
                chosenPool = new CardCollection();
                String title = Localizer.getInstance().getMessage("lblChooseCreature", new Object[0]);
                Card choice = null;
                while (!pChoices.isEmpty() && chosenPool.size() < validAmount) {
                    boolean optional = chosenPool.size() >= minAmount;
                    CardCollection creature = (CardCollection)pChoices;
                    if (!chosenPool.isEmpty()) {
                        title = Localizer.getInstance().getMessage("lblChooseCreatureWithDiffPower", new Object[0]);
                    }
                    if ((choice = p.getController().chooseSingleEntityForEffect(creature, sa, title, optional, null)) == null) break;
                    chosenPool.add(choice);
                    restrict = restrict + (restrict.contains(".") ? "+powerNE" : ".powerNE") + choice.getNetPower();
                    pChoices = CardLists.getValidCards((Iterable<Card>)pChoices, restrict, activator, host, (CardTraitBase)sa);
                }
                if (choice != null) {
                    chosenPool.add(choice);
                }
                chosen.addAll(chosenPool);
            } else if (sa.hasParam("EachDifferentPower")) {
                ArrayList<Integer> powers = new ArrayList<Integer>();
                chosenPool = new CardCollection();
                for (Card c3 : pChoices) {
                    int pow = c3.getNetPower();
                    if (powers.contains(pow)) continue;
                    powers.add(c3.getNetPower());
                }
                Collections.sort(powers);
                String re = sa.getParam("Choices");
                re = re + (re.contains(".") ? "+powerEQ" : ".powerEQ");
                Iterator c3 = powers.iterator();
                while (c3.hasNext()) {
                    int i = (Integer)c3.next();
                    String restrict = re + i;
                    valids = CardLists.getValidCards((Iterable<Card>)pChoices, restrict, activator, host, (CardTraitBase)sa);
                    Card choice = p.getController().chooseSingleEntityForEffect(valids, sa, Localizer.getInstance().getMessage("lblChooseCreatureWithXPower", i), false, null);
                    chosenPool.add(choice);
                }
                chosen.addAll(chosenPool);
            } else if (sa.hasParam("ControlAndNot")) {
                String title = sa.hasParam("ChoiceTitle") ? sa.getParam("ChoiceTitle") : Localizer.getInstance().getMessage("lblChooseCreature", new Object[0]);
                CardCollection tgtPlayerCtrl = CardLists.filterControlledBy((Iterable<Card>)pChoices, p);
                chosen.addAll(p.getController().chooseCardsForEffect(tgtPlayerCtrl, sa, title + " you control", minAmount, validAmount, !sa.hasParam("Mandatory"), null));
                CardCollection notTgtPlayerCtrl = new CardCollection(pChoices);
                notTgtPlayerCtrl.removeAll(tgtPlayerCtrl);
                chosen.addAll(p.getController().chooseCardsForEffect(notTgtPlayerCtrl, sa, title + " you don't control", minAmount, validAmount, !sa.hasParam("Mandatory"), null));
            } else if (sa.hasParam("AtRandom") && !pChoices.isEmpty()) {
                chosen = new CardCollection((Iterable<Card>)Aggregates.random(pChoices, validAmount));
                dontRevealToOwner = false;
            } else {
                String title;
                String string = title = sa.hasParam("ChoiceTitle") ? sa.getParam("ChoiceTitle") : Localizer.getInstance().getMessage("lblChooseaCard", new Object[0]) + " ";
                if (sa.hasParam("ChoiceTitleAppend")) {
                    String tag = "";
                    String value = sa.getParam("ChoiceTitleAppend");
                    if (value.startsWith("Defined ")) {
                        tag = AbilityUtils.getDefinedPlayers(host, value.substring(8), sa).toString();
                    } else if (value.equals("ChosenType")) {
                        tag = host.getChosenType();
                    }
                    if (!tag.isEmpty()) {
                        title = title + " (" + tag + ")";
                    }
                }
                if (sa.hasParam("QuasiLibrarySearch")) {
                    Map.Entry<Long, Player> searchControlPlayer;
                    Long controlTimestamp = null;
                    if (activator.equals(p) && (searchControlPlayer = p.getControlledWhileSearching()) != null) {
                        controlTimestamp = searchControlPlayer.getKey();
                        p.addController(controlTimestamp, searchControlPlayer.getValue());
                    }
                    Player searched = (Player)AbilityUtils.getDefinedPlayers(host, sa.getParam("QuasiLibrarySearch"), sa).get(false);
                    int fetchNum = Math.min(searched.getCardsIn(ZoneType.Library).size(), 4);
                    CardCollectionView shown = !p.hasKeyword("LimitSearchLibrary") ? searched.getCardsIn(ZoneType.Library) : searched.getCardsIn(ZoneType.Library, fetchNum);
                    DelayedReveal delayedReveal = new DelayedReveal(shown, ZoneType.Library, PlayerView.get(searched), CardTranslation.getTranslatedName(host.getName()) + " - " + Localizer.getInstance().getMessage("lblLookingCardIn", new Object[0]) + " ");
                    Card choice = p.getController().chooseSingleEntityForEffect(pChoices, delayedReveal, sa, title, !sa.hasParam("Mandatory"), p, null);
                    if (choice == null) {
                        return;
                    }
                    chosen.add(choice);
                    if (controlTimestamp != null) {
                        p.removeController(controlTimestamp);
                    }
                } else {
                    chosen.addAll(p.getController().chooseCardsForEffect(pChoices, sa, title, minAmount, validAmount, !sa.hasParam("Mandatory"), null));
                }
            }
            if (sa.hasParam("Reveal") && !sa.hasParam("Secretly")) {
                game.getAction().reveal((CardCollectionView)chosen, p, dontRevealToOwner, revealTitle ? sa.getParam("RevealTitle") : Localizer.getInstance().getMessage("lblChosenCards", new Object[0]) + " ", !revealTitle);
            }
            if (sa.hasParam("ChosenMap")) {
                host.addToChosenMap(p, chosen);
            }
            allChosen.addAll(chosen);
        }
        if (sa.hasParam("Reveal") && sa.hasParam("Secretly")) {
            for (Player p : tgtPlayers) {
                game.getAction().reveal((CardCollectionView)allChosen, p, true, revealTitle ? sa.getParam("RevealTitle") : Localizer.getInstance().getMessage("lblChosenCards", new Object[0]) + " ", !revealTitle);
            }
        }
        host.setChosenCards(allChosen);
        if (sa.hasParam("ForgetOtherRemembered")) {
            host.clearRemembered();
        }
        if (sa.hasParam("RememberChosen")) {
            host.addRemembered(allChosen);
        }
        if (sa.hasParam("ForgetChosen")) {
            host.removeRemembered(allChosen);
        }
        if (sa.hasParam("ImprintChosen")) {
            host.addImprintedCards(allChosen);
        }
    }
}

