/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.GameCommand;
import forge.card.CardType;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.game.Game;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.event.GameEventCardStatsChanged;
import forge.game.spellability.SpellAbility;
import forge.util.Localizer;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.List;

public class ChangeTextEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        String changedTypeWordNew;
        String changedTypeWordOriginal;
        String changedColorWordNew;
        String changedColorWordOriginal;
        Card source = sa.getHostCard();
        Game game = source.getGame();
        final Long timestamp = game.getNextTimestamp();
        boolean permanent = "Permanent".equals(sa.getParam("Duration"));
        if (sa.hasParam("ChangeColorWord")) {
            byte originalColor = 0;
            String[] changedColorWordsArray = sa.getParam("ChangeColorWord").split(" ");
            if (changedColorWordsArray[0].equals("Choose")) {
                originalColor = sa.getActivatingPlayer().getController().chooseColor(Localizer.getInstance().getMessage("lblChooseColorReplace", new Object[0]), sa, ColorSet.ALL_COLORS);
                changedColorWordOriginal = TextUtil.capitalize(MagicColor.toLongString(originalColor));
            } else {
                changedColorWordOriginal = changedColorWordsArray[0];
                originalColor = MagicColor.fromName(changedColorWordOriginal);
            }
            if (changedColorWordsArray[1].equals("Choose")) {
                ColorSet possibleNewColors = originalColor == 0 ? ColorSet.ALL_COLORS : ColorSet.fromMask(originalColor).inverse();
                byte newColor = sa.getActivatingPlayer().getController().chooseColor(Localizer.getInstance().getMessage("lblChooseNewColor", new Object[0]), sa, possibleNewColors);
                changedColorWordNew = TextUtil.capitalize(MagicColor.toLongString(newColor));
            } else {
                changedColorWordNew = changedColorWordsArray[1];
            }
        } else {
            changedColorWordOriginal = null;
            changedColorWordNew = null;
        }
        if (sa.hasParam("ChangeTypeWord")) {
            String kindOfType = "";
            ArrayList<String> validTypes = Lists.newArrayList();
            String[] changedTypeWordsArray = sa.getParam("ChangeTypeWord").split(" ");
            if (changedTypeWordsArray[0].equals("ChooseBasicLandType") || changedTypeWordsArray[0].equals("ChooseCreatureType")) {
                if (changedTypeWordsArray[0].equals("ChooseBasicLandType")) {
                    validTypes.addAll(CardType.getBasicTypes());
                    kindOfType = "basic land";
                } else if (changedTypeWordsArray[0].equals("ChooseCreatureType")) {
                    validTypes.addAll(CardType.Constant.CREATURE_TYPES);
                    kindOfType = "Creature";
                }
                changedTypeWordOriginal = sa.getActivatingPlayer().getController().chooseSomeType(kindOfType, sa, validTypes, Lists.newArrayList());
            } else {
                changedTypeWordOriginal = changedTypeWordsArray[0];
            }
            validTypes.clear();
            ArrayList<String> forbiddenTypes = sa.hasParam("ForbiddenNewTypes") ? Lists.newArrayList(sa.getParam("ForbiddenNewTypes").split(",")) : Lists.newArrayList();
            forbiddenTypes.add(changedTypeWordOriginal);
            if (changedTypeWordsArray[1].startsWith("Choose")) {
                if (changedTypeWordsArray[1].equals("ChooseBasicLandType")) {
                    validTypes.addAll(CardType.getBasicTypes());
                    kindOfType = "basic land";
                } else if (changedTypeWordsArray[1].equals("ChooseCreatureType")) {
                    validTypes.addAll(CardType.Constant.CREATURE_TYPES);
                    kindOfType = "Creature";
                }
                changedTypeWordNew = sa.getActivatingPlayer().getController().chooseSomeType(kindOfType, sa, validTypes, forbiddenTypes);
            } else {
                changedTypeWordNew = changedTypeWordsArray[1];
            }
        } else {
            changedTypeWordOriginal = null;
            changedTypeWordNew = null;
        }
        List<Card> tgts = ChangeTextEffect.getCardsfromTargets(sa);
        for (final Card c : tgts) {
            if (changedColorWordOriginal != null && changedColorWordNew != null) {
                c.addChangedTextColorWord(changedColorWordOriginal, changedColorWordNew, timestamp, 0L);
            }
            if (changedTypeWordOriginal != null && changedTypeWordNew != null) {
                c.addChangedTextTypeWord(changedTypeWordOriginal, changedTypeWordNew, timestamp, 0L);
            }
            if (!permanent) {
                GameCommand revert = new GameCommand(){
                    private static final long serialVersionUID = -7802388880114360593L;

                    @Override
                    public void run() {
                        if (changedColorWordNew != null) {
                            c.removeChangedTextColorWord(timestamp, 0L);
                        }
                        if (changedTypeWordNew != null) {
                            c.removeChangedTextTypeWord(timestamp, 0L);
                        }
                    }
                };
                game.getEndOfTurn().addUntil(revert);
            }
            game.fireEvent(new GameEventCardStatsChanged(c));
            c.updateStateForView();
            c.updateTypesForView();
        }
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        String changedTypeWordNew;
        String changedTypeWordOriginal;
        String changedColorWordNew;
        String changedColorWordOriginal;
        if (sa.hasParam("ChangeColorWord")) {
            String[] changedColorWordsArray = sa.getParam("ChangeColorWord").split(" ");
            changedColorWordOriginal = changedColorWordsArray[0];
            changedColorWordNew = changedColorWordsArray[1];
        } else {
            changedColorWordOriginal = null;
            changedColorWordNew = null;
        }
        if (sa.hasParam("ChangeTypeWord")) {
            String[] changedTypeWordsArray = sa.getParam("ChangeTypeWord").split(" ");
            changedTypeWordOriginal = changedTypeWordsArray[0];
            changedTypeWordNew = changedTypeWordsArray[1];
        } else {
            changedTypeWordOriginal = null;
            changedTypeWordNew = null;
        }
        boolean permanent = "Permanent".equals(sa.getParam("Duration"));
        StringBuilder sb = new StringBuilder();
        sb.append("Change the text of ");
        List<Card> tgts = ChangeTextEffect.getCardsfromTargets(sa);
        for (Card c : tgts) {
            sb.append(c).append(" ");
        }
        if (changedColorWordOriginal != null) {
            sb.append(" by replacing all instances of ");
            if (changedColorWordOriginal.equals("Choose")) {
                sb.append("one color word");
            } else if (changedColorWordOriginal.equals("Any")) {
                sb.append("each color word");
            } else {
                sb.append(changedColorWordOriginal);
            }
            sb.append(" with ");
            if (changedColorWordNew.equals("Choose")) {
                if (changedColorWordOriginal.equals("Choose")) {
                    sb.append("another");
                } else {
                    sb.append("a color word of your choice");
                }
            } else {
                sb.append(changedColorWordNew);
            }
        }
        if (changedTypeWordOriginal != null) {
            sb.append(" by replacing all instances of ");
            if (changedTypeWordOriginal.equals("ChooseBasicLandType")) {
                sb.append("one basic land type");
            } else if (changedTypeWordOriginal.equals("ChooseCreatureType")) {
                sb.append("one creature type");
            } else {
                sb.append(changedTypeWordOriginal);
            }
            sb.append(" with ");
            if (changedTypeWordNew.equals("ChooseBasicLandType")) {
                if (changedTypeWordOriginal.equals("ChooseBasicLandType")) {
                    sb.append("another");
                } else {
                    sb.append("a basic land type of your choice");
                }
            } else if (changedTypeWordNew.equals("ChooseCreatureType")) {
                if (changedTypeWordOriginal.equals("ChooseCreatureType")) {
                    sb.append("another");
                } else {
                    sb.append("a creature type of your choice");
                }
            } else {
                sb.append(changedTypeWordNew);
            }
        }
        if (!permanent) {
            sb.append(" until end of turn");
        }
        sb.append('.');
        if (sa.hasParam("ForbiddenNewTypes")) {
            sb.append(" The new creature type can't be ");
            sb.append(sa.getParam("ForbiddenNewTypes"));
            sb.append('.');
        }
        if (permanent) {
            sb.append(" (This effect lasts indefinitely.)");
        }
        return sb.toString();
    }
}

