/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import forge.game.CardTraitBase;
import forge.game.GameEntity;
import forge.game.GameObject;
import forge.game.GameObjectPredicates;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.spellability.TargetChoices;
import forge.game.zone.MagicStack;
import forge.util.Aggregates;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ChangeTargetsEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        List<SpellAbility> sas = ChangeTargetsEffect.getTargetSpells(sa);
        Player activator = sa.getActivatingPlayer();
        Player chooser = sa.hasParam("Chooser") ? (Player)ChangeTargetsEffect.getDefinedPlayersOrTargeted(sa, "Chooser").get(false) : activator;
        MagicStack stack = activator.getGame().getStack();
        for (SpellAbility tgtSA : sas) {
            SpellAbilityStackInstance changingTgtSI;
            SpellAbilityStackInstance si = stack.getInstanceMatchingSpellAbilityID(tgtSA);
            if (si == null) continue;
            boolean isOptional = sa.hasParam("Optional");
            if (isOptional && !chooser.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblDoYouWantChangeAbilityTargets", tgtSA.getHostCard().toString()), null)) continue;
            if (sa.hasParam("ChangeSingleTarget")) {
                ArrayList<Pair<SpellAbilityStackInstance, GameObject>> allTargets = new ArrayList<Pair<SpellAbilityStackInstance, GameObject>>();
                for (changingTgtSI = si; changingTgtSI != null; changingTgtSI = changingTgtSI.getSubInstance()) {
                    SpellAbility changedSa = changingTgtSI.getSpellAbility();
                    if (!changedSa.usesTargeting()) continue;
                    for (GameObject it : changedSa.getTargets()) {
                        allTargets.add(ImmutablePair.of(changingTgtSI, it));
                    }
                }
                if (allTargets.isEmpty()) {
                    return;
                }
                Pair<SpellAbilityStackInstance, GameObject> chosenTarget = chooser.getController().chooseTarget(sa, allTargets);
                SpellAbilityStackInstance replaceIn = chosenTarget.getKey();
                GameObject oldTarget = chosenTarget.getValue();
                TargetChoices oldTargetBlock = replaceIn.getTargetChoices();
                TargetChoices newTargetBlock = oldTargetBlock.clone();
                Integer div = oldTargetBlock.getDividedValue(oldTarget);
                GameObject newTarget = Iterables.getFirst(ChangeTargetsEffect.getDefinedCardsOrTargeted(sa, "DefinedMagnet"), null);
                if (oldTargetBlock.contains(newTarget) || !replaceIn.getSpellAbility().canTarget(newTarget)) continue;
                newTargetBlock.remove(oldTarget);
                newTargetBlock.add(newTarget);
                if (div != null) {
                    newTargetBlock.addDividedAllocation(newTarget, div);
                }
                replaceIn.updateTarget(newTargetBlock, sa.getHostCard());
                continue;
            }
            while (changingTgtSI != null) {
                SpellAbility changingTgtSA = changingTgtSI.getSpellAbility();
                if (changingTgtSA.usesTargeting()) {
                    if (sa.hasParam("RandomTarget")) {
                        int div = changingTgtSA.getTotalDividedValue();
                        List<GameEntity> candidates = changingTgtSA.getTargetRestrictions().getAllCandidates(changingTgtSA, true);
                        if (sa.hasParam("RandomTargetRestriction")) {
                            candidates.removeIf(c -> !c.isValid(sa.getParam("RandomTargetRestriction").split(","), activator, sa.getHostCard(), (CardTraitBase)sa));
                        }
                        if (candidates.isEmpty()) {
                            return;
                        }
                        changingTgtSA.resetTargets();
                        GameEntity choice = Aggregates.random(candidates);
                        changingTgtSA.getTargets().add(choice);
                        if (changingTgtSA.isDividedAsYouChoose()) {
                            changingTgtSA.addDividedAllocation(choice, div);
                        }
                        changingTgtSI.updateTarget(changingTgtSA.getTargets(), sa.getHostCard());
                    } else if (sa.hasParam("DefinedMagnet")) {
                        GameObject newTarget = Iterables.getFirst(ChangeTargetsEffect.getDefinedCardsOrTargeted(sa, "DefinedMagnet"), null);
                        if (newTarget != null && changingTgtSA.canTarget(newTarget)) {
                            int div = changingTgtSA.getTotalDividedValue();
                            changingTgtSA.resetTargets();
                            changingTgtSA.getTargets().add(newTarget);
                            changingTgtSI.updateTarget(changingTgtSA.getTargets(), sa.getHostCard());
                            if (changingTgtSA.isDividedAsYouChoose()) {
                                changingTgtSA.addDividedAllocation(newTarget, div);
                            }
                        }
                    } else {
                        Card source = sa.getHostCard();
                        if (changingTgtSA.getTargetCard() != null) {
                            source = changingTgtSA.getTargetCard();
                        }
                        Predicate<GameObject> filter = sa.hasParam("TargetRestriction") ? GameObjectPredicates.restriction(sa.getParam("TargetRestriction").split(","), activator, source, sa) : null;
                        TargetChoices newTarget = chooser.getController().chooseNewTargetsFor(changingTgtSA, filter, false);
                        changingTgtSI.updateTarget(newTarget, sa.getHostCard());
                    }
                }
                changingTgtSI = changingTgtSI.getSubInstance();
            }
        }
    }
}

