/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbilityCantAttackBlock;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CamouflageEffect
extends SpellAbilityEffect {
    private void randomizeBlockers(SpellAbility sa, Combat combat, Player declarer, Player defender, List<Card> attackers, List<CardCollection> blockerPiles) {
        CardLists.shuffle(attackers);
        for (int i = 0; i < attackers.size(); ++i) {
            Card attacker = attackers.get(i);
            CardCollection blockers = blockerPiles.get(i);
            for (int j = blockers.size() - 1; j >= 0; --j) {
                Card blocker = (Card)blockers.get(j);
                if (CombatUtil.canBlock(attacker, blocker, combat)) continue;
                blockers.remove(j);
            }
            if (blockers.size() < CombatUtil.getMinNumBlockersForAttacker(attacker, defender)) continue;
            if (StaticAbilityCantAttackBlock.getMinMaxBlocker(attacker, defender).getRight() < blockers.size()) {
                Card chosen = (Card)declarer.getController().chooseCardsForEffect(blockers, sa, Localizer.getInstance().getMessage("lblChooseBlockerForAttacker", attacker.toString()), 1, 1, false, null).get(false);
                combat.addBlocker(attacker, chosen);
                continue;
            }
            for (Card blocker : blockers) {
                combat.addBlocker(attacker, blocker);
            }
        }
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card hostCard = sa.getHostCard();
        Player declarer = (Player)CamouflageEffect.getDefinedPlayersOrTargeted(sa).get(false);
        Player defender = (Player)AbilityUtils.getDefinedPlayers(hostCard, sa.getParam("Defender"), sa).get(false);
        Combat combat = hostCard.getGame().getCombat();
        CardCollection attackers = combat.getAttackers();
        ArrayList<CardCollection> blockerPiles = new ArrayList<CardCollection>();
        if (declarer.isAI()) {
            declarer.getController().declareBlockers(defender, combat);
            for (Card attacker : attackers) {
                CardCollection blockers = combat.getBlockers(attacker);
                blockerPiles.add(blockers);
                for (Card blocker : blockers) {
                    combat.removeFromCombat(blocker);
                }
            }
        } else {
            CardCollection pool = new CardCollection(defender.getCreaturesInPlay());
            for (Card blocker : pool) {
                if (CombatUtil.canBlock(blocker)) continue;
                pool.remove(blocker);
            }
            ArrayList<Integer> blockedSoFar = new ArrayList<Integer>(Collections.nCopies(pool.size(), 0));
            for (int i = 0; i < attackers.size(); ++i) {
                int size = pool.size();
                CardCollection blockers = new CardCollection(declarer.getController().chooseCardsForEffect(pool, sa, Localizer.getInstance().getMessage("lblChooseBlockersForPile", String.valueOf(i + 1)), 0, size, false, null));
                blockerPiles.add(blockers);
                for (Card blocker : blockers) {
                    int index = pool.indexOf(blocker);
                    int blockedCount = (Integer)blockedSoFar.get(index) + 1;
                    if (!blocker.canBlockAny() && blocker.canBlockAdditional() < blockedCount) {
                        pool.remove(index);
                        blockedSoFar.remove(index);
                        continue;
                    }
                    blockedSoFar.set(index, blockedCount);
                }
            }
        }
        this.randomizeBlockers(sa, combat, declarer, defender, attackers, blockerPiles);
    }
}

