/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Maps;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.HashMap;

public class BondEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.getHostCard();
        Player p = sa.getActivatingPlayer();
        Game game = source.getGame();
        for (Card tgtC : BondEffect.getTargetCards(sa)) {
            CardCollection cards;
            Card gameCard = game.getCardState(tgtC, null);
            if (gameCard == null || !tgtC.equalsWithGameTimestamp(gameCard) || gameCard.isPaired() || !gameCard.isCreature() || !gameCard.isInPlay() || gameCard.getController() != p || (cards = CardLists.getValidCards((Iterable<Card>)p.getCreaturesInPlay(), sa.getParam("ValidCards"), p, source, (CardTraitBase)sa)).isEmpty()) continue;
            HashMap<String, Object> params = Maps.newHashMap();
            params.put("Partner", gameCard);
            Card partner = p.getController().chooseSingleEntityForEffect(cards, sa, Localizer.getInstance().getMessage("lblSelectACardPair", new Object[0]), true, params);
            if (partner == null) continue;
            gameCard.setPairedWith(partner);
            partner.setPairedWith(gameCard);
        }
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Lang.joinHomogenous(BondEffect.getTargetCards(sa)));
        sb.append(" pairs with another unpaired creature you control.");
        return sb.toString();
    }
}

