/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Maps;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardZoneTable;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;

public class BalanceEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Player activator = sa.getActivatingPlayer();
        Card source = sa.getHostCard();
        Game game = activator.getGame();
        String valid = sa.getParamOrDefault("Valid", "Card");
        ZoneType zone = sa.hasParam("Zone") ? ZoneType.smartValueOf(sa.getParam("Zone")) : ZoneType.Battlefield;
        int min2 = Integer.MAX_VALUE;
        PlayerCollection players = game.getPlayersInTurnOrder();
        ArrayList<CardCollection> validCards = new ArrayList<CardCollection>(players.size());
        HashMap<Player, CardCollectionView> discardedMap = Maps.newHashMap();
        for (int i = 0; i < players.size(); ++i) {
            validCards.add(CardLists.getValidCards((Iterable<Card>)((Player)players.get(i)).getCardsIn(zone), valid, activator, source, (CardTraitBase)sa));
            min2 = Math.min(min2, ((CardCollection)validCards.get(i)).size());
        }
        EnumMap<AbilityKey, Object> params = AbilityKey.newMap();
        CardZoneTable table = AbilityKey.addCardZoneTableParams(params, sa);
        for (int i = 0; i < players.size(); ++i) {
            Player p = (Player)players.get(i);
            int numToBalance = ((CardCollection)validCards.get(i)).size() - min2;
            if (numToBalance == 0) continue;
            if (zone.equals((Object)ZoneType.Hand)) {
                discardedMap.put(p, p.getController().chooseCardsToDiscardFrom(p, sa, (CardCollection)validCards.get(i), numToBalance, numToBalance));
                continue;
            }
            CardCollectionView list = p.getController().choosePermanentsToSacrifice(sa, numToBalance, numToBalance, (CardCollectionView)validCards.get(i), valid);
            game.getAction().sacrifice(list, sa, true, params);
        }
        if (zone.equals((Object)ZoneType.Hand)) {
            BalanceEffect.discard(sa, true, discardedMap, params);
        }
        table.triggerChangesZoneAll(game, sa);
    }
}

