/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.GameCommand;
import forge.card.CardType;
import forge.card.ColorSet;
import forge.card.RemoveType;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostParser;
import forge.game.Game;
import forge.game.IHasSVars;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.cost.Cost;
import forge.game.event.GameEventCardStatsChanged;
import forge.game.keyword.Keyword;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementHandler;
import forge.game.spellability.AbilityStatic;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerHandler;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public abstract class AnimateEffectBase
extends SpellAbilityEffect {
    public static void doAnimate(final Card c, SpellAbility sa, Integer power, Integer toughness, CardType addType, CardType removeType, ColorSet colors, List<String> keywords, List<String> removeKeywords, List<String> hiddenKeywords, List<String> abilities, List<String> triggers, List<String> replacements, List<String> stAbs, final long timestamp, String duration) {
        HashMap<String, Object> params;
        Card source = sa.getHostCard();
        final Game game = source.getGame();
        boolean perpetual = "Perpetual".equals(duration);
        boolean addAllCreatureTypes = sa.hasParam("AddAllCreatureTypes");
        EnumSet<RemoveType> remove = EnumSet.noneOf(RemoveType.class);
        if (sa.hasParam("RemoveSuperTypes")) {
            remove.add(RemoveType.SuperTypes);
        }
        if (sa.hasParam("RemoveCardTypes")) {
            remove.add(RemoveType.CardTypes);
        }
        if (sa.hasParam("RemoveSubTypes")) {
            remove.add(RemoveType.SubTypes);
        }
        if (sa.hasParam("RemoveLandTypes")) {
            remove.add(RemoveType.LandTypes);
        }
        if (sa.hasParam("RemoveCreatureTypes")) {
            remove.add(RemoveType.CreatureTypes);
        }
        if (sa.hasParam("RemoveArtifactTypes")) {
            remove.add(RemoveType.ArtifactTypes);
        }
        if (sa.hasParam("RemoveEnchantmentTypes")) {
            remove.add(RemoveType.EnchantmentTypes);
        }
        boolean removeNonManaAbilities = sa.hasParam("RemoveNonManaAbilities");
        boolean removeAll = sa.hasParam("RemoveAllAbilities");
        if (sa.hasParam("RememberAnimated")) {
            source.addRemembered(c);
        }
        ColorSet incColors = null;
        if (sa.hasParam("Incorporate")) {
            String incorporate = sa.getParam("Incorporate");
            HashMap<String, Object> params2 = new HashMap<String, Object>();
            params2.put("Incorporate", incorporate);
            params2.put("Timestamp", timestamp);
            params2.put("Category", "Incorporate");
            c.addPerpetual(params2);
            ManaCost incMCost = new ManaCost(new ManaCostParser(incorporate));
            incColors = ColorSet.fromMask(incMCost.getColorProfile());
            ManaCost newCost = ManaCost.combine(c.getManaCost(), incMCost);
            c.addChangedManaCost(newCost, timestamp, 0L);
            c.updateManaCostForView();
            if (c.getFirstSpellAbility() != null) {
                c.getFirstSpellAbility().getPayCosts().add(new Cost(incorporate, false));
            }
        }
        if (!addType.isEmpty() || !removeType.isEmpty() || addAllCreatureTypes || !remove.isEmpty()) {
            if (perpetual) {
                params = new HashMap<String, Object>();
                params.put("AddTypes", addType);
                params.put("RemoveTypes", removeType);
                params.put("RemoveXTypes", remove);
                params.put("Timestamp", timestamp);
                params.put("Category", "Types");
                c.addPerpetual(params);
            }
            c.addChangedCardTypes(addType, removeType, addAllCreatureTypes, (Set<RemoveType>)remove, timestamp, 0L, true, false);
        }
        if (!keywords.isEmpty() || !removeKeywords.isEmpty() || removeAll) {
            if (perpetual) {
                params = new HashMap();
                params.put("AddKeywords", keywords);
                params.put("RemoveAll", removeAll);
                params.put("Timestamp", timestamp);
                params.put("Category", "Keywords");
                c.addPerpetual(params);
            }
            c.addChangedCardKeywords(keywords, removeKeywords, removeAll, timestamp, null);
        }
        if (power != null || toughness != null) {
            if (perpetual) {
                params = new HashMap();
                params.put("Power", power);
                params.put("Toughness", toughness);
                params.put("Timestamp", timestamp);
                params.put("Category", "NewPT");
                c.addPerpetual(params);
            }
            c.addNewPT(power, toughness, timestamp, 0L);
        }
        if (sa.hasParam("CantHaveKeyword")) {
            c.addCantHaveKeyword(timestamp, Keyword.setValueOf(sa.getParam("CantHaveKeyword")));
        }
        if (!hiddenKeywords.isEmpty()) {
            c.addHiddenExtrinsicKeywords(timestamp, 0L, hiddenKeywords);
        }
        if (colors != null) {
            boolean overwrite = sa.hasParam("OverwriteColors");
            AnimateEffectBase.handleColors(c, colors, timestamp, overwrite, perpetual);
        }
        if (incColors != null) {
            AnimateEffectBase.handleColors(c, incColors, timestamp, false, perpetual);
        }
        if (sa.hasParam("LeaveBattlefield")) {
            AnimateEffectBase.addLeaveBattlefieldReplacement(c, sa, sa.getParam("LeaveBattlefield"));
        }
        ArrayList<SpellAbility> removedAbilities = Lists.newArrayList();
        boolean clearSpells = sa.hasParam("OverwriteSpells");
        if (clearSpells) {
            removedAbilities.addAll(Lists.newArrayList(c.getSpells()));
        }
        if (sa.hasParam("RemoveThisAbility") && !removedAbilities.contains(sa)) {
            removedAbilities.add(sa);
        }
        ArrayList<SpellAbility> addedAbilities = Lists.newArrayList();
        for (String string : abilities) {
            SpellAbility spellAbility = AbilityFactory.getAbility(c, string, (IHasSVars)sa);
            addedAbilities.add(spellAbility);
            if (!sa.hasParam("TransferActivator")) continue;
            spellAbility.getRestrictions().setActivator("Player.PlayerUID_" + sa.getActivatingPlayer().getId());
        }
        ArrayList<Trigger> addedTriggers = Lists.newArrayList();
        for (String string : triggers) {
            Trigger trigger = TriggerHandler.parseTrigger(AbilityUtils.getSVar(sa, string), c, false, (IHasSVars)sa);
            addedTriggers.add(trigger);
        }
        ArrayList<ReplacementEffect> arrayList = Lists.newArrayList();
        for (String string : replacements) {
            arrayList.add(ReplacementHandler.parseReplacement(AbilityUtils.getSVar(sa, string), c, false, (IHasSVars)sa));
        }
        ArrayList<StaticAbility> arrayList2 = Lists.newArrayList();
        for (String s5 : stAbs) {
            arrayList2.add(StaticAbility.create(AbilityUtils.getSVar(sa, s5), c, sa.getCardState(), false));
        }
        final GameCommand gameCommand = new GameCommand(){
            private static final long serialVersionUID = -5861759814760561373L;

            @Override
            public void run() {
                AnimateEffectBase.doUnanimate(c, timestamp);
                c.removeChangedSVars(timestamp, 0L);
                c.removeChangedName(timestamp, 0L);
                c.updateStateForView();
                game.fireEvent(new GameEventCardStatsChanged(c));
            }
        };
        if (sa.hasParam("RevertCost")) {
            final ManaCost cost = new ManaCost(new ManaCostParser(sa.getParam("RevertCost")));
            final String desc = sa.getStackDescription();
            AbilityStatic revertSA = new AbilityStatic(c, cost){

                @Override
                public void resolve() {
                    gameCommand.run();
                }

                @Override
                public String getDescription() {
                    return cost + ": End Effect: " + desc;
                }
            };
            addedAbilities.add(revertSA);
        }
        if (!(!removeAll && !removeNonManaAbilities && addedAbilities.isEmpty() && removedAbilities.isEmpty() && addedTriggers.isEmpty() && arrayList.isEmpty() && arrayList2.isEmpty())) {
            c.addChangedCardTraits(addedAbilities, removedAbilities, addedTriggers, arrayList, arrayList2, removeAll, removeNonManaAbilities, timestamp, 0L);
            if (perpetual) {
                HashMap<String, Object> params3 = new HashMap<String, Object>();
                params3.put("Timestamp", timestamp);
                params3.put("Category", "Abilities");
                c.addPerpetual(params3);
            }
        }
        if (!"Permanent".equals(duration) && !perpetual) {
            if ("UntilControllerNextUntap".equals(duration)) {
                game.getUntap().addUntil(c.getController(), gameCommand);
            } else if ("UntilAnimatedFaceup".equals(duration)) {
                c.addFaceupCommand(gameCommand);
            } else {
                AnimateEffectBase.addUntilCommand(sa, gameCommand);
            }
        }
    }

    static void doUnanimate(Card c, long timestamp) {
        c.removeNewPT(timestamp, 0L);
        c.removeChangedCardKeywords(timestamp, 0L);
        c.removeChangedCardTypes(timestamp, 0L);
        c.removeColor(timestamp, 0L);
        c.removeChangedCardTraits(timestamp, 0L);
        c.removeCantHaveKeyword(timestamp);
        c.removeHiddenExtrinsicKeywords(timestamp, 0L);
    }

    static void handleColors(Card c, ColorSet colors, long timestamp, boolean overwrite, boolean perpetual) {
        if (perpetual) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("Colors", colors);
            params.put("Overwrite", overwrite);
            params.put("Timestamp", timestamp);
            params.put("Category", "Colors");
            c.addPerpetual(params);
        }
        c.addColor(colors, !overwrite, timestamp, 0L, false);
    }
}

