/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.card.CardType;
import forge.card.ColorSet;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.effects.AnimateEffectBase;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.event.GameEventCardStatsChanged;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class AnimateAllEffect
extends AnimateEffectBase {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        return sa.getParamOrDefault("SpellDescription", "Animate all valid cards.");
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Integer power = null;
        if (sa.hasParam("Power")) {
            power = AbilityUtils.calculateAmount(host, sa.getParam("Power"), sa);
        }
        Integer toughness = null;
        if (sa.hasParam("Toughness")) {
            toughness = AbilityUtils.calculateAmount(host, sa.getParam("Toughness"), sa);
        }
        Game game = host.getGame();
        long timestamp = game.getNextTimestamp();
        CardType types = new CardType(true);
        if (sa.hasParam("Types")) {
            types.addAll(Arrays.asList(sa.getParam("Types").split(",")));
        }
        CardType removeTypes = new CardType(true);
        if (sa.hasParam("RemoveTypes")) {
            removeTypes.addAll(Arrays.asList(sa.getParam("RemoveTypes").split(",")));
        }
        if (types.hasSubtype("ChosenType")) {
            types.clear();
            types.add(host.getChosenType());
        } else if (types.hasSubtype("ChosenType2")) {
            types.clear();
            types.add(host.getChosenType2());
        }
        ArrayList<String> keywords = Lists.newArrayList();
        if (sa.hasParam("Keywords")) {
            keywords.addAll(Arrays.asList(sa.getParam("Keywords").split(" & ")));
        }
        ArrayList<String> removeKeywords = Lists.newArrayList();
        if (sa.hasParam("RemoveKeywords")) {
            removeKeywords.addAll(Arrays.asList(sa.getParam("RemoveKeywords").split(" & ")));
        }
        ArrayList<String> hiddenKeywords = Lists.newArrayList();
        if (sa.hasParam("HiddenKeywords")) {
            hiddenKeywords.addAll(Arrays.asList(sa.getParam("HiddenKeywords").split(" & ")));
        }
        for (int i = 0; i < keywords.size(); ++i) {
            String k = (String)keywords.get(i);
            if (!host.hasSVar(k)) continue;
            keywords.add(host.getSVar(k));
            keywords.remove(k);
        }
        ColorSet finalColors = null;
        if (sa.hasParam("Colors")) {
            String colors = sa.getParam("Colors");
            finalColors = colors.equals("ChosenColor") ? ColorSet.fromNames(host.getChosenColors()) : ColorSet.fromNames(colors.split(","));
        }
        ArrayList<String> abilities = Lists.newArrayList();
        if (sa.hasParam("Abilities")) {
            abilities.addAll(Arrays.asList(sa.getParam("Abilities").split(",")));
        }
        ArrayList<String> replacements = Lists.newArrayList();
        if (sa.hasParam("Replacements")) {
            replacements.addAll(Arrays.asList(sa.getParam("Replacements").split(",")));
        }
        ArrayList<String> triggers = Lists.newArrayList();
        if (sa.hasParam("Triggers")) {
            triggers.addAll(Arrays.asList(sa.getParam("Triggers").split(",")));
        }
        ArrayList<String> sVars = Lists.newArrayList();
        if (sa.hasParam("sVars")) {
            sVars.addAll(Arrays.asList(sa.getParam("sVars").split(",")));
        }
        ArrayList<String> stAbs = Lists.newArrayList();
        if (sa.hasParam("staticAbilities")) {
            stAbs.addAll(Arrays.asList(sa.getParam("staticAbilities").split(",")));
        }
        HashMap<String, String> sVarsMap = Maps.newHashMap();
        for (String s2 : sVars) {
            sVarsMap.put(s2, AbilityUtils.getSVar(sa, s2));
        }
        String valid = sa.getParamOrDefault("ValidCards", "");
        List<ZoneType> z = sa.hasParam("Zone") ? ZoneType.listValueOf(sa.getParam("Zone")) : ZoneType.listValueOf("Battlefield");
        CardCollectionView list = sa.usesTargeting() || sa.hasParam("Defined") ? AnimateAllEffect.getTargetPlayers(sa).getCardsIn(z) : game.getCardsIn(z);
        list = AbilityUtils.filterListByType(list, valid, sa);
        for (Card c : list) {
            AnimateAllEffect.doAnimate(c, sa, power, toughness, types, removeTypes, finalColors, keywords, removeKeywords, hiddenKeywords, abilities, triggers, replacements, stAbs, timestamp, sa.getParam("Duration"));
            if (!sVarsMap.isEmpty()) {
                c.addChangedSVars(sVarsMap, timestamp, 0L);
            }
            game.fireEvent(new GameEventCardStatsChanged(c));
        }
    }
}

