/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.phase.ExtraPhase;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerHandler;
import java.util.ArrayList;
import java.util.Collection;

public class AddPhaseEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        int num;
        Card host = sa.getHostCard();
        Player activator = sa.getActivatingPlayer();
        boolean isTopsy = activator.getAmountOfKeyword("The phases of your turn are reversed.") % 2 == 1;
        PhaseHandler phaseHandler = activator.getGame().getPhaseHandler();
        PhaseType currentPhase = phaseHandler.getPhase();
        if (sa.hasParam("BeforeFirstPostCombatMainEnd") && !phaseHandler.beforeFirstPostCombatMainEnd()) {
            return;
        }
        PhaseType afterPhase = sa.hasParam("AfterPhase") ? PhaseType.smartValueOf(sa.getParam("AfterPhase")) : currentPhase;
        PhaseType nextPhase = PhaseType.getNext(afterPhase, isTopsy);
        PhaseType followingExtra = PhaseType.smartValueOf(sa.getParam("FollowedBy"));
        String extra = sa.getParam("ExtraPhase");
        for (int n = num = sa.hasParam("NumPhases") ? AbilityUtils.calculateAmount(host, sa.getParam("NumPhases"), sa) : 1; n > 0; --n) {
            ArrayList<PhaseType> extraPhaseList = new ArrayList<PhaseType>();
            if (extra.equals("Beginning")) {
                extraPhaseList.addAll((Collection)PhaseType.PHASE_GROUPS.get(0));
            } else if (extra.equals("Combat")) {
                extraPhaseList.addAll((Collection)PhaseType.PHASE_GROUPS.get(2));
            } else {
                extraPhaseList.add(PhaseType.smartValueOf(extra));
            }
            if (followingExtra != null) {
                extraPhaseList.add(followingExtra);
            }
            ExtraPhase extraPhase = phaseHandler.addExtraPhase(afterPhase, extraPhaseList, nextPhase);
            if (!sa.hasParam("ExtraPhaseDelayedTrigger")) continue;
            Trigger delTrig = TriggerHandler.parseTrigger(sa.getSVar(sa.getParam("ExtraPhaseDelayedTrigger")), host, true);
            SpellAbility overridingSA = AbilityFactory.getAbility(sa.getSVar(sa.getParam("ExtraPhaseDelayedTriggerExcute")), host);
            overridingSA.setActivatingPlayer(activator);
            delTrig.setOverridingAbility(overridingSA);
            delTrig.setSpawningAbility(sa.copy(host, true));
            extraPhase.addTrigger(delTrig);
        }
    }
}

