/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.CardTranslation;
import forge.util.Localizer;
import java.util.EnumMap;

public class AbandonEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.getHostCard();
        Player controller = source.getController();
        boolean isOptional = sa.hasParam("Optional");
        if (isOptional && !controller.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblWouldYouLikeAbandonSource", CardTranslation.getTranslatedName(source.getName())), null)) {
            return;
        }
        if (sa.hasParam("RememberAbandoned")) {
            source.addRemembered(source);
        }
        controller.getZone(ZoneType.Command).remove(source);
        controller.getZone(ZoneType.SchemeDeck).add(source);
        EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
        runParams.put(AbilityKey.Scheme, source);
        controller.getGame().getTriggerHandler().runTrigger(TriggerType.Abandoned, runParams, false);
    }
}

