/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import forge.GameCommand;
import forge.card.GamePieceType;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameObject;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardZoneTable;
import forge.game.combat.Combat;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementHandler;
import forge.game.replacement.ReplacementLayer;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerHandler;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.CardTranslation;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.TextUtil;
import forge.util.collect.FCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public abstract class SpellAbilityEffect {
    public abstract void resolve(SpellAbility var1);

    protected String getStackDescription(SpellAbility sa) {
        return sa.getDescription();
    }

    public final String getStackDescriptionWithSubs(Map<String, String> params, SpellAbility sa) {
        AbilitySub abSub;
        String stackDesc;
        StringBuilder sb = new StringBuilder();
        if (sa.getApi() != ApiType.PermanentCreature && sa.getApi() != ApiType.PermanentNoncreature) {
            if (!(sa instanceof AbilitySub)) {
                sb.append(sa.getHostCard()).append(" -");
                if (sa.getHostCard().hasPromisedGift() && sa.hasAdditionalAbility("GiftAbility")) {
                    sb.append(" Gift ").append(sa.getAdditionalAbility("GiftAbility").getParam("GiftDescription")).append(" to ").append(sa.getHostCard().getPromisedGift()).append(". ");
                }
            }
            sb.append(" ");
        }
        if ((stackDesc = params.get("StackDescription")) != null) {
            String[] reps = null;
            if (stackDesc.startsWith("REP")) {
                reps = stackDesc.substring(4).split(" & ");
                stackDesc = "SpellDescription";
            }
            if ("SpellDescription".equalsIgnoreCase(stackDesc)) {
                String rawSDesc = params.get("SpellDescription");
                if (params.containsKey("SpellDescription")) {
                    if (rawSDesc.contains(",,,,,,")) {
                        rawSDesc = rawSDesc.replaceAll(",,,,,,", " ");
                    }
                    if (rawSDesc.contains(",,,")) {
                        rawSDesc = rawSDesc.replaceAll(",,,", " ");
                    }
                    String spellDesc = CardTranslation.translateSingleDescriptionText(rawSDesc, sa.getHostCard());
                    int idxL = spellDesc.indexOf(" (");
                    int idxR = spellDesc.indexOf(")");
                    if (idxL > 0 && idxR > idxL) {
                        spellDesc = spellDesc.replace(spellDesc.substring(idxL, idxR + 1), "");
                    }
                    if (reps != null) {
                        for (String s2 : reps) {
                            String[] rep = s2.split("_", 2);
                            if (!spellDesc.contains(rep[0])) continue;
                            spellDesc = spellDesc.replaceFirst(rep[0], rep[1]);
                        }
                        SpellAbilityEffect.tokenizeString(sa, sb, spellDesc);
                    } else {
                        sb.append(spellDesc);
                    }
                }
                if (sa.getTargets() != null && !sa.getTargets().isEmpty() && reps == null) {
                    sb.append(" (Targeting: ").append(Lang.joinHomogenous(sa.getTargets())).append(")");
                }
            } else if (!"None".equalsIgnoreCase(stackDesc)) {
                SpellAbilityEffect.tokenizeString(sa, sb, stackDesc);
            }
        } else {
            String condDesc = sa.getParam("ConditionDescription");
            String afterDesc = sa.getParam("AfterDescription");
            String baseDesc = CardTranslation.translateSingleDescriptionText(this.getStackDescription(sa), sa.getHostCard());
            if (condDesc != null) {
                sb.append(condDesc).append(" ");
            }
            sb.append(condDesc != null && condDesc.endsWith(",") ? StringUtils.uncapitalize(baseDesc) : baseDesc);
            if (afterDesc != null) {
                sb.append(" ").append(afterDesc);
            }
        }
        if (sa.getApi() != ApiType.PermanentCreature && sa.getApi() != ApiType.PermanentNoncreature && (abSub = sa.getSubAbility()) != null) {
            sb.append(abSub.getStackDescription());
        }
        if (sa.hasParam("Announce")) {
            String svar = sa.getParam("Announce");
            int amount = AbilityUtils.calculateAmount(sa.getHostCard(), svar, sa);
            sb.append(" ");
            sb.append(TextUtil.enclosedParen(TextUtil.concatNoSpace(svar, "=", String.valueOf(amount))));
        } else if (sa.costHasManaX()) {
            int amount = sa.getXManaCostPaid() == null ? 0 : sa.getXManaCostPaid();
            sb.append(" ");
            sb.append(TextUtil.enclosedParen(TextUtil.concatNoSpace("X", "=", String.valueOf(amount))));
        }
        String currentName = CardTranslation.getTranslatedName(sa.getHostCard().getName());
        String substitutedDesc = TextUtil.fastReplace(sb.toString(), "CARDNAME", currentName);
        substitutedDesc = TextUtil.fastReplace(substitutedDesc, "NICKNAME", Lang.getInstance().getNickName(currentName));
        return substitutedDesc;
    }

    protected final int extractAmount(SpellAbility sa) {
        return AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParamOrDefault("Amount", "1"), sa);
    }

    public static void tokenizeString(SpellAbility sa, StringBuilder sb, String stackDesc) {
        StringTokenizer st = new StringTokenizer(stackDesc, "{}", true);
        boolean isPlainText = true;
        while (st.hasMoreTokens()) {
            String t2 = st.nextToken();
            if ("{".equals(t2)) {
                isPlainText = false;
                continue;
            }
            if ("}".equals(t2)) {
                isPlainText = true;
                continue;
            }
            if (!isPlainText) {
                if (t2.length() <= 2) {
                    sb.append("{").append(t2).append("}");
                    continue;
                }
                if (t2.startsWith("n:")) {
                    String[] parts = t2.substring(2).split(" ", 2);
                    int n = AbilityUtils.calculateAmount(sa.getHostCard(), parts[0], sa);
                    sb.append(parts.length == 1 ? Lang.getNumeral(n) : Lang.nounWithNumeral(n, parts[1]));
                    continue;
                }
                FCollection objs = t2.startsWith("p:") ? AbilityUtils.getDefinedPlayers(sa.getHostCard(), t2.substring(2), sa) : (t2.startsWith("s:") ? AbilityUtils.getDefinedSpellAbilities(sa.getHostCard(), t2.substring(2), sa) : (t2.startsWith("c:") ? AbilityUtils.getDefinedCards(sa.getHostCard(), t2.substring(2), sa) : AbilityUtils.getDefinedObjects(sa.getHostCard(), t2, sa)));
                sb.append(Lang.joinHomogenous(objs));
                continue;
            }
            sb.append(t2);
        }
    }

    protected static final CardCollection getTargetCards(SpellAbility sa) {
        return SpellAbilityEffect.getCards(false, "Defined", sa);
    }

    protected static final CardCollection getTargetCards(SpellAbility sa, String definedParam) {
        return SpellAbilityEffect.getCards(false, definedParam, sa);
    }

    protected static final CardCollection getDefinedCardsOrTargeted(SpellAbility sa) {
        return SpellAbilityEffect.getCards(true, "Defined", sa);
    }

    protected static final CardCollection getDefinedCardsOrTargeted(SpellAbility sa, String definedParam) {
        return SpellAbilityEffect.getCards(true, definedParam, sa);
    }

    protected static List<Card> getTargetCardsWithDuplicates(boolean definedFirst, String definedParam, SpellAbility sa) {
        ArrayList<Card> result = Lists.newArrayList();
        SpellAbilityEffect.getCards(definedFirst, definedParam, sa, result);
        return result;
    }

    private static CardCollection getCards(boolean definedFirst, String definedParam, SpellAbility sa) {
        return SpellAbilityEffect.getCards(definedFirst, definedParam, sa, null);
    }

    private static CardCollection getCards(boolean definedFirst, String definedParam, SpellAbility sa, List<Card> resultDuplicate) {
        boolean useTargets;
        if (sa.hasParam("ThisDefinedAndTgts")) {
            CardCollection cards = AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("ThisDefinedAndTgts"), sa);
            cards.addAll(sa.getTargets().getTargetCards());
            return cards;
        }
        CardCollection resultUnique = null;
        boolean bl = useTargets = sa.usesTargeting() && (!definedFirst || !sa.hasParam(definedParam));
        if (useTargets) {
            if (resultDuplicate == null) {
                resultDuplicate = resultUnique = new CardCollection();
            }
            Iterables.addAll(resultDuplicate, sa.getTargets().getTargetCards());
        } else {
            String[] def = sa.getParamOrDefault(definedParam, "Self").split(" & ");
            for (String d : def) {
                CardCollection defResult = AbilityUtils.getDefinedCards(sa.getHostCard(), d, sa);
                if (resultDuplicate == null) {
                    resultDuplicate = resultUnique = defResult;
                    continue;
                }
                resultDuplicate.addAll(defResult);
            }
        }
        if (resultUnique == null) {
            return null;
        }
        if (sa.hasParam("IncludeAllComponentCards")) {
            CardCollection components = new CardCollection();
            for (Card c : resultUnique) {
                components.addAll(c.getAllComponentCards(false));
            }
            resultUnique.addAll(components);
        }
        return resultUnique;
    }

    protected static final PlayerCollection getTargetPlayers(SpellAbility sa) {
        return SpellAbilityEffect.getPlayers(false, "Defined", sa);
    }

    protected static final PlayerCollection getTargetPlayers(SpellAbility sa, String definedParam) {
        return SpellAbilityEffect.getPlayers(false, definedParam, sa);
    }

    protected static final PlayerCollection getDefinedPlayersOrTargeted(SpellAbility sa) {
        return SpellAbilityEffect.getPlayers(true, "Defined", sa);
    }

    protected static final PlayerCollection getDefinedPlayersOrTargeted(SpellAbility sa, String definedParam) {
        return SpellAbilityEffect.getPlayers(true, definedParam, sa);
    }

    protected static List<Player> getTargetPlayersWithDuplicates(boolean definedFirst, String definedParam, SpellAbility sa) {
        ArrayList<Player> result = Lists.newArrayList();
        SpellAbilityEffect.getPlayers(definedFirst, definedParam, sa, result);
        return result;
    }

    private static PlayerCollection getPlayers(boolean definedFirst, String definedParam, SpellAbility sa) {
        return SpellAbilityEffect.getPlayers(definedFirst, definedParam, sa, null);
    }

    private static PlayerCollection getPlayers(boolean definedFirst, String definedParam, SpellAbility sa, List<Player> resultDuplicate) {
        boolean useTargets;
        Game game = sa.getHostCard().getGame();
        PlayerCollection resultUnique = null;
        boolean bl = useTargets = sa.usesTargeting() && (!definedFirst || !sa.hasParam(definedParam));
        if (useTargets) {
            if (resultDuplicate == null) {
                resultDuplicate = resultUnique = new PlayerCollection();
            }
            Iterables.addAll(resultDuplicate, sa.getTargets().getTargetPlayers());
        } else {
            String[] def;
            for (String d : def = sa.getParamOrDefault(definedParam, "You").split(" & ")) {
                PlayerCollection defResult = AbilityUtils.getDefinedPlayers(sa.getHostCard(), d, sa);
                if (resultDuplicate == null) {
                    resultDuplicate = resultUnique = defResult;
                    continue;
                }
                resultDuplicate.addAll(defResult);
            }
        }
        Player starter = game.getPhaseHandler().getPlayerTurn();
        if (sa.hasParam("StartingWith")) {
            starter = (Player)AbilityUtils.getDefinedPlayers(sa.getHostCard(), sa.getParam("StartingWith"), sa).getFirst();
        }
        PlayerCollection ordered = game.getPlayersInTurnOrder(starter);
        resultDuplicate.sort(Comparator.comparingInt(ordered::indexOf));
        return resultUnique;
    }

    protected static final List<SpellAbility> getTargetSpells(SpellAbility sa) {
        return SpellAbilityEffect.getSpells(false, "Defined", sa);
    }

    protected static final List<SpellAbility> getTargetSpells(SpellAbility sa, String definedParam) {
        return SpellAbilityEffect.getSpells(false, definedParam, sa);
    }

    protected static final List<SpellAbility> getDefinedSpellsOrTargeted(SpellAbility sa, String definedParam) {
        return SpellAbilityEffect.getSpells(true, definedParam, sa);
    }

    private static List<SpellAbility> getSpells(boolean definedFirst, String definedParam, SpellAbility sa) {
        boolean useTargets = sa.usesTargeting() && (!definedFirst || !sa.hasParam(definedParam));
        return useTargets ? Lists.newArrayList(sa.getTargets().getTargetSpells()) : AbilityUtils.getDefinedSpellAbilities(sa.getHostCard(), sa.getParam(definedParam), sa);
    }

    protected static final List<GameEntity> getTargetEntities(SpellAbility sa) {
        return SpellAbilityEffect.getEntities(false, "Defined", sa);
    }

    protected static final List<GameEntity> getTargetEntities(SpellAbility sa, String definedParam) {
        return SpellAbilityEffect.getEntities(false, definedParam, sa);
    }

    protected static final List<GameEntity> getDefinedEntitiesOrTargeted(SpellAbility sa, String definedParam) {
        return SpellAbilityEffect.getEntities(true, definedParam, sa);
    }

    private static List<GameEntity> getEntities(boolean definedFirst, String definedParam, SpellAbility sa) {
        boolean useTargets = sa.usesTargeting() && (!definedFirst || !sa.hasParam(definedParam));
        String[] def = sa.getParamOrDefault(definedParam, "Self").split(" & ");
        return useTargets ? Lists.newArrayList(sa.getTargets().getTargetEntities()) : AbilityUtils.getDefinedEntities(sa.getHostCard(), def, (CardTraitBase)sa);
    }

    protected static final List<GameObject> getTargets(SpellAbility sa) {
        return SpellAbilityEffect.getTargetables(false, "Defined", sa);
    }

    protected static final List<GameObject> getTargets(SpellAbility sa, String definedParam) {
        return SpellAbilityEffect.getTargetables(false, definedParam, sa);
    }

    protected static final List<GameObject> getDefinedOrTargeted(SpellAbility sa, String definedParam) {
        return SpellAbilityEffect.getTargetables(true, definedParam, sa);
    }

    private static List<GameObject> getTargetables(boolean definedFirst, String definedParam, SpellAbility sa) {
        boolean useTargets = sa.usesTargeting() && (!definedFirst || !sa.hasParam(definedParam));
        return useTargets ? Lists.newArrayList(sa.getTargets()) : AbilityUtils.getDefinedObjects(sa.getHostCard(), sa.getParam(definedParam), sa);
    }

    protected static final List<Card> getCardsfromTargets(SpellAbility sa) {
        CardCollection cards = SpellAbilityEffect.getTargetCards(sa);
        for (SpellAbility s2 : sa.getTargets().getTargetSpells()) {
            cards.add(s2.getHostCard());
        }
        return cards;
    }

    protected static void registerDelayedTrigger(SpellAbility sa, String location, Iterable<Card> crds) {
        boolean intrinsic = sa.isIntrinsic();
        boolean your = location.startsWith("Your");
        boolean combat = location.endsWith("Combat");
        String desc = sa.getParamOrDefault("AtEOTDesc", "");
        if (your) {
            location = location.substring("Your".length());
        }
        if (combat) {
            location = location.substring(0, location.length() - "Combat".length());
        }
        if (desc.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            if (location.equals("Hand")) {
                sb.append("Return ");
            } else if (location.equals("SacrificeCtrl")) {
                sb.append("Its controller sacrifices ");
            } else {
                sb.append(location).append(" ");
            }
            sb.append(Lang.joinHomogenous(crds));
            if (location.equals("Hand")) {
                sb.append(" to your hand");
            }
            sb.append(" at the ");
            if (combat) {
                sb.append("end of combat.");
            } else {
                sb.append("beginning of ");
                sb.append(your ? "your" : "the");
                sb.append(" next end step.");
            }
            desc = sb.toString();
        }
        StringBuilder delTrig = new StringBuilder();
        delTrig.append("Mode$ Phase | Phase$ ");
        delTrig.append(combat ? "EndCombat " : "End Of Turn ");
        if (your) {
            delTrig.append("| ValidPlayer$ You ");
        }
        delTrig.append("| TriggerDescription$ ").append(desc);
        Trigger trig = TriggerHandler.parseTrigger(delTrig.toString(), CardCopyService.getLKICopy(sa.getHostCard()), intrinsic);
        long ts = sa.getHostCard().getGame().getNextTimestamp();
        for (Card c : crds) {
            trig.addRemembered(c);
            c.addChangedSVars(Collections.singletonMap("EndOfTurnLeavePlay", "AtEOT"), ts, 0L);
        }
        String trigSA = "";
        if (location.equals("Hand")) {
            trigSA = "DB$ ChangeZone | Defined$ DelayTriggerRememberedLKI | Origin$ Battlefield | Destination$ Hand";
        } else if (location.equals("SacrificeCtrl")) {
            trigSA = "DB$ SacrificeAll | Defined$ DelayTriggerRememberedLKI";
        } else if (location.equals("Sacrifice")) {
            trigSA = "DB$ SacrificeAll | Defined$ DelayTriggerRememberedLKI | Controller$ You";
        } else if (location.equals("Exile")) {
            trigSA = "DB$ ChangeZone | Defined$ DelayTriggerRememberedLKI | Origin$ Battlefield | Destination$ Exile";
        } else if (location.equals("Destroy")) {
            trigSA = "DB$ Destroy | Defined$ DelayTriggerRememberedLKI";
        }
        if (sa.hasParam("AtEOTCondition")) {
            String var = sa.getParam("AtEOTCondition");
            trigSA = trigSA + "| ConditionCheckSVar$ " + var;
        }
        SpellAbility newSa = AbilityFactory.getAbility(trigSA, sa.getHostCard());
        newSa.setIntrinsic(intrinsic);
        trig.setOverridingAbility(newSa);
        trig.setSpawningAbility(sa.copy(sa.getHostCard(), true));
        sa.getActivatingPlayer().getGame().getTriggerHandler().registerDelayedTrigger(trig);
    }

    protected static void addSelfTrigger(SpellAbility sa, String location, Card card) {
        String player = "";
        String whose = " the ";
        if (location.contains("_")) {
            String[] locSplit = location.split("_");
            player = locSplit[0];
            location = locSplit[1];
            if (player.equals("You")) {
                whose = " your next ";
            }
        }
        String trigStr = "Mode$ Phase | Phase$ End of Turn | TriggerZones$ Battlefield | TriggerDescription$ At the beginning of" + whose + "end step, " + location.toLowerCase() + " CARDNAME.";
        if (!player.isEmpty()) {
            trigStr = trigStr + " | Player$ " + player;
        }
        Trigger trig = TriggerHandler.parseTrigger(trigStr, card, true);
        String trigSA = "";
        if (location.equals("Sacrifice")) {
            trigSA = "DB$ Sacrifice | SacValid$ Self";
        } else if (location.equals("Exile")) {
            trigSA = "DB$ ChangeZone | Origin$ Battlefield | Destination$ Exile | Defined$ Self";
        }
        trig.setOverridingAbility(AbilityFactory.getAbility(trigSA, card));
        card.addTrigger(trig);
        card.addChangedSVars(Collections.singletonMap("EndOfTurnLeavePlay", "AtEOT"), card.getGame().getNextTimestamp(), 0L);
    }

    protected static SpellAbility getExileSpellAbility(Card card) {
        String effect = "DB$ ChangeZone | Defined$ Self | Origin$ Command | Destination$ Exile";
        return AbilityFactory.getAbility(effect, card);
    }

    protected static SpellAbility getForgetSpellAbility(Card card) {
        String forgetEffect = "DB$ Pump | ForgetObjects$ TriggeredCard";
        String exileEffect = "DB$ ChangeZone | Defined$ Self | Origin$ Command | Destination$ Exile | ConditionDefined$ Remembered | ConditionPresent$ Card | ConditionCompare$ EQ0";
        SpellAbility saForget = AbilityFactory.getAbility(forgetEffect, card);
        AbilitySub saExile = (AbilitySub)AbilityFactory.getAbility(exileEffect, card);
        saForget.setSubAbility(saExile);
        return saForget;
    }

    public static void addForgetOnMovedTrigger(Card card, String zone) {
        String trig = "Mode$ ChangesZone | ValidCard$ Card.IsRemembered | Origin$ " + zone + " | ExcludedDestinations$ Stack,Exile | Destination$ Any | TriggerZones$ Command | Static$ True";
        String trig2 = "Mode$ Exiled | ValidCard$ Card.IsRemembered | ValidCause$ SpellAbility.!EffectSource | TriggerZones$ Command | Static$ True";
        Trigger parsedTrigger = TriggerHandler.parseTrigger(trig, card, true);
        Trigger parsedTrigger2 = TriggerHandler.parseTrigger(trig2, card, true);
        SpellAbility forget = SpellAbilityEffect.getForgetSpellAbility(card);
        parsedTrigger.setOverridingAbility(forget);
        parsedTrigger2.setOverridingAbility(forget);
        card.addTrigger(parsedTrigger);
        card.addTrigger(parsedTrigger2);
    }

    protected static void addForgetOnCastTrigger(Card card, String valid) {
        String trig = "Mode$ SpellCast | TriggerZones$ Command | Static$ True | ValidCard$ " + valid;
        Trigger parsedTrigger = TriggerHandler.parseTrigger(trig, card, true);
        parsedTrigger.setOverridingAbility(SpellAbilityEffect.getForgetSpellAbility(card));
        card.addTrigger(parsedTrigger);
    }

    protected static void addExileOnMovedTrigger(Card card, String zone) {
        String trig = "Mode$ ChangesZone | ValidCard$ Card.IsRemembered | Origin$ " + zone + " | Destination$ Any | TriggerZones$ Command | Static$ True";
        Trigger parsedTrigger = TriggerHandler.parseTrigger(trig, card, true);
        parsedTrigger.setOverridingAbility(SpellAbilityEffect.getExileSpellAbility(card));
        card.addTrigger(parsedTrigger);
    }

    protected static void addExileOnCounteredTrigger(Card card) {
        String trig = "Mode$ Countered | ValidCard$ Card.IsRemembered | TriggerZones$ Command | Static$ True";
        Trigger parsedTrigger = TriggerHandler.parseTrigger(trig, card, true);
        parsedTrigger.setOverridingAbility(SpellAbilityEffect.getExileSpellAbility(card));
        card.addTrigger(parsedTrigger);
    }

    protected static void addForgetOnPhasedInTrigger(Card card) {
        String trig = "Mode$ PhaseIn | ValidCard$ Card.IsRemembered | TriggerZones$ Command | Static$ True";
        Trigger parsedTrigger = TriggerHandler.parseTrigger(trig, card, true);
        parsedTrigger.setOverridingAbility(SpellAbilityEffect.getForgetSpellAbility(card));
        card.addTrigger(parsedTrigger);
    }

    protected static void addExileCounterTrigger(Card card, String counterType) {
        String trig = "Mode$ CounterRemoved | TriggerZones$ Command | ValidCard$ Card.EffectSource | CounterType$ " + counterType + " | NewCounterAmount$ 0 | Static$ True";
        Trigger parsedTrigger = TriggerHandler.parseTrigger(trig, card, true);
        parsedTrigger.setOverridingAbility(SpellAbilityEffect.getExileSpellAbility(card));
        card.addTrigger(parsedTrigger);
    }

    protected static void addForgetCounterTrigger(Card card, String counterType) {
        String trig = "Mode$ CounterRemoved | TriggerZones$ Command | ValidCard$ Card.IsRemembered | CounterType$ " + counterType + " | NewCounterAmount$ 0 | Static$ True";
        String trig2 = "Mode$ PhaseOut | TriggerZones$ Command | ValidCard$ Card.phasedOutIsRemembered | Static$ True";
        SpellAbility forgetSA = SpellAbilityEffect.getForgetSpellAbility(card);
        Trigger parsedTrigger = TriggerHandler.parseTrigger(trig, card, true);
        Trigger parsedTrigger2 = TriggerHandler.parseTrigger(trig2, card, true);
        parsedTrigger.setOverridingAbility(forgetSA);
        parsedTrigger2.setOverridingAbility(forgetSA);
        card.addTrigger(parsedTrigger);
        card.addTrigger(parsedTrigger2);
    }

    protected static void addExileOnLostTrigger(Card card) {
        String trig = "Mode$ LosesGame | ValidPlayer$ You | TriggerController$ Player | TriggerZones$ Command | Static$ True";
        Trigger parsedTrigger = TriggerHandler.parseTrigger(trig, card, true);
        parsedTrigger.setOverridingAbility(SpellAbilityEffect.getExileSpellAbility(card));
        card.addTrigger(parsedTrigger);
    }

    protected static void addLeaveBattlefieldReplacement(Card card, SpellAbility sa, String zone) {
        Card host = sa.getHostCard();
        Game game = card.getGame();
        Card eff = SpellAbilityEffect.createEffect(sa, sa.getActivatingPlayer(), host + "'s Effect", host.getImageKey());
        SpellAbilityEffect.addLeaveBattlefieldReplacement(eff, zone);
        eff.addRemembered(card);
        SpellAbilityEffect.addExileOnMovedTrigger(eff, "Battlefield");
        if (sa.isIntrinsic()) {
            eff.copyChangedTextFrom(card);
        }
        game.getAction().moveToCommand(eff, sa);
    }

    protected static void addLeaveBattlefieldReplacement(Card eff, String zone) {
        String repeffstr = "Event$ Moved | ValidCard$ Card.IsRemembered | Origin$ Battlefield | ExcludeDestination$ " + zone + "| Description$ If Creature would leave the battlefield,  exile it instead of putting it anywhere else.";
        String effect = "DB$ ChangeZone | Defined$ ReplacedCard | Origin$ Battlefield | Destination$ " + zone;
        ReplacementEffect re = ReplacementHandler.parseReplacement(repeffstr, eff, true);
        re.setLayer(ReplacementLayer.Other);
        re.setOverridingAbility(AbilityFactory.getAbility(effect, eff));
        eff.addReplacementEffect(re);
    }

    protected static Card createEffect(SpellAbility sa, Player controller, String name, String image) {
        Card hostCard = sa.getHostCard();
        Game game = hostCard.getGame();
        Card eff = new Card(game.nextCardId(), game);
        eff.setGameTimestamp(game.getNextTimestamp());
        eff.setName(name);
        eff.setColor(hostCard.getColor().getColor());
        if (name.startsWith("Emblem")) {
            eff.setEmblem(true);
            eff.setColor((byte)0);
        } else if (sa.hasParam("Boon")) {
            eff.setBoon(true);
        }
        eff.setOwner(controller);
        eff.setSVars(sa.getSVars());
        eff.setImageKey(image);
        eff.setGamePieceType(GamePieceType.EFFECT);
        eff.setEffectSource(sa);
        return eff;
    }

    protected static void replaceDying(SpellAbility sa) {
        if (sa.hasParam("ReplaceDyingDefined") || sa.hasParam("ReplaceDyingValid")) {
            String condition;
            if (sa.hasParam("ReplaceDyingCondition") && "Kicked".equals(condition = sa.getParam("ReplaceDyingCondition")) && !sa.isKicked()) {
                return;
            }
            Card host = sa.getHostCard();
            Player controller = sa.getActivatingPlayer();
            Game game = host.getGame();
            String zone = sa.getParamOrDefault("ReplaceDyingZone", "Exile");
            CardCollection cards = null;
            if (sa.hasParam("ReplaceDyingDefined") && (cards = AbilityUtils.getDefinedCards(host, sa.getParam("ReplaceDyingDefined"), sa)).isEmpty()) {
                return;
            }
            String name = host.getName() + "'s Effect";
            Card eff = SpellAbilityEffect.createEffect(sa, controller, name, host.getImageKey());
            if (cards != null) {
                eff.addRemembered(cards);
            }
            String valid = sa.getParamOrDefault("ReplaceDyingValid", "Card.IsRemembered");
            String repeffstr = "Event$ Moved | ValidLKI$ " + valid + "| Origin$ Battlefield | Destination$ Graveyard | Description$ If that permanent would die this turn, exile it instead.";
            String effect = "DB$ ChangeZone | Defined$ ReplacedCard | Origin$ Battlefield | Destination$ " + zone;
            if (sa.hasParam("ReplaceDyingExiledWith")) {
                effect = effect + " | ExiledWithEffectSource$ True";
            }
            ReplacementEffect re = ReplacementHandler.parseReplacement(repeffstr, eff, true);
            re.setLayer(ReplacementLayer.Other);
            re.setOverridingAbility(AbilityFactory.getAbility(effect, eff));
            eff.addReplacementEffect(re);
            if (cards != null) {
                SpellAbilityEffect.addForgetOnMovedTrigger(eff, "Battlefield");
            }
            if (sa.isIntrinsic()) {
                eff.copyChangedTextFrom(host);
            }
            game.getEndOfTurn().addUntil(SpellAbilityEffect.exileEffectCommand(game, eff));
            game.getAction().moveToCommand(eff, sa);
        }
    }

    protected static boolean addToCombat(Card c, SpellAbility sa, String attackingParam, String blockingParam) {
        Card attacker;
        Card host = sa.getHostCard();
        Game game = host.getGame();
        if (!c.isCreature() || !game.getPhaseHandler().inCombat()) {
            return false;
        }
        boolean combatChanged = false;
        Combat combat = game.getCombat();
        if (sa.hasParam(attackingParam) && combat.getAttackingPlayer().equals(c.getController())) {
            String attacking = sa.getParam(attackingParam);
            GameEntity defender = null;
            FCollection<GameEntity> defs = new FCollection<GameEntity>();
            combat.initConstraints();
            if ("True".equalsIgnoreCase(attacking)) {
                defs.addAll(combat.getDefenders());
            } else {
                defs.addAll((Collection<GameEntity>)AbilityUtils.getDefinedEntities(sa.hasParam("ForEach") ? c : host, attacking.split(" & "), (CardTraitBase)sa));
            }
            HashMap<String, Object> params = Maps.newHashMap();
            params.put("Attacker", c);
            defender = (GameEntity)sa.getActivatingPlayer().getController().chooseSingleEntityForEffect(defs, sa, Localizer.getInstance().getMessage("lblChooseDefenderToAttackWithCard", CardTranslation.getTranslatedName(c.getName())), false, params);
            if (defender != null && !combat.getAttackersOf(defender).contains(c)) {
                combat.removeFromCombat(c);
                combat.addAttacker(c, defender);
                combat.getBandOfAttacker(c).setBlocked(false);
                combatChanged = true;
            }
        }
        if (sa.hasParam(blockingParam) && (attacker = (Card)Iterables.getFirst(AbilityUtils.getDefinedCards(host, sa.getParam(blockingParam), sa), null)) != null && combat.getDefenderPlayerByAttacker(attacker).equals(c.getController())) {
            boolean wasBlocked = combat.isBlocked(attacker);
            combat.addBlocker(attacker, c);
            combat.orderAttackersForDamageAssignment(c);
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Attacker, attacker);
            runParams.put(AbilityKey.Blocker, c);
            game.getTriggerHandler().runTrigger(TriggerType.AttackerBlockedByCreature, runParams, false);
            runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Attackers, (Object)attacker);
            game.getTriggerHandler().runTrigger(TriggerType.AttackerBlockedOnce, runParams, false);
            if (!wasBlocked) {
                CardCollection blockers = combat.getBlockers(attacker);
                EnumMap<AbilityKey, Object> runParams2 = AbilityKey.newMap();
                runParams2.put(AbilityKey.Attacker, attacker);
                runParams2.put(AbilityKey.Blockers, blockers);
                runParams2.put(AbilityKey.Defender, combat.getDefenderByAttacker(attacker));
                runParams2.put(AbilityKey.DefendingPlayer, combat.getDefenderPlayerByAttacker(attacker));
                game.getTriggerHandler().runTrigger(TriggerType.AttackerBlocked, runParams2, false);
                combat.setBlocked(attacker, true);
                combat.addBlockerToDamageAssignmentOrder(attacker, c);
            }
            combatChanged = true;
        }
        return combatChanged;
    }

    protected static GameCommand untilHostLeavesPlayCommand(final CardZoneTable triggerList, final SpellAbility sa) {
        Card lki;
        final Card hostCard = sa.getHostCard();
        final Game game = hostCard.getGame();
        hostCard.addUntilLeavesBattlefield(triggerList.allCards());
        final TriggerHandler trigHandler = game.getTriggerHandler();
        if (sa.hasParam("ReturnAbility")) {
            lki = CardCopyService.getLKICopy(hostCard);
            lki.clearControllers();
            lki.setOwner(sa.getActivatingPlayer());
        } else {
            lki = null;
        }
        return new GameCommand(){
            private static final long serialVersionUID = 1L;

            @Override
            public void run() {
                CardCollectionView untilCards = hostCard.getUntilLeavesBattlefield();
                if (untilCards.isEmpty()) {
                    return;
                }
                EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
                moveParams.put(AbilityKey.LastStateBattlefield, game.copyLastStateBattlefield());
                moveParams.put(AbilityKey.LastStateGraveyard, game.copyLastStateGraveyard());
                for (Table.Cell cell : triggerList.cellSet()) {
                    for (Card c : (CardCollection)cell.getValue()) {
                        Card newCard;
                        if (!untilCards.contains(c) || (newCard = game.getCardState(c, null)) == null || !newCard.equalsWithGameTimestamp(c)) continue;
                        if (sa.hasAdditionalAbility("ReturnAbility")) {
                            String valid = sa.getParamOrDefault("ReturnValid", "Card.IsTriggerRemembered");
                            String trigSA = "Mode$ ChangesZone | Origin$ " + cell.getColumnKey() + " | Destination$ " + cell.getRowKey() + " | ValidCard$ " + valid + " | TriggerDescription$ " + sa.getAdditionalAbility("ReturnAbility").getParam("SpellDescription");
                            Trigger trig = TriggerHandler.parseTrigger(trigSA, hostCard, sa.isIntrinsic(), null);
                            trig.setSpawningAbility(sa.copy(lki, true));
                            trig.setActiveZone(null);
                            trig.addRemembered(newCard);
                            SpellAbility overridingSA = sa.getAdditionalAbility("ReturnAbility").copy(hostCard, sa.getActivatingPlayer(), false);
                            if (overridingSA instanceof AbilitySub) {
                                ((AbilitySub)overridingSA).setParent(null);
                            }
                            trig.setOverridingAbility(overridingSA);
                            trigHandler.registerThisTurnDelayedTrigger(trig);
                        }
                        Card movedCard = game.getAction().moveTo((ZoneType)((Object)cell.getRowKey()), newCard, 0, null, moveParams);
                        game.getUntilHostLeavesPlayTriggerList().put((ZoneType)((Object)cell.getColumnKey()), (ZoneType)((Object)cell.getRowKey()), movedCard);
                    }
                }
            }
        };
    }

    protected static void discard(SpellAbility sa, boolean effect, Map<Player, CardCollectionView> discardedMap, Map<AbilityKey, Object> params) {
        CardCollectionView discardedByPlayer;
        Set<Player> discarders = discardedMap.keySet();
        HashMap<Player, ArrayList<Card>> discardedBefore = Maps.newHashMap();
        for (Player p : discarders) {
            discardedBefore.put(p, Lists.newArrayList(p.getDiscardedThisTurn()));
            discardedByPlayer = new CardCollection();
            for (Card card : Lists.newArrayList(discardedMap.get(p))) {
                Card moved;
                if (card == null || (moved = p.discard(card, sa, effect, params)) == null) continue;
                ((FCollection)((Object)discardedByPlayer)).add(moved);
            }
            discardedMap.put(p, discardedByPlayer);
        }
        for (Player p : discarders) {
            discardedByPlayer = discardedMap.get(p);
            if (discardedByPlayer.isEmpty()) continue;
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(p);
            runParams.put(AbilityKey.Cards, discardedByPlayer);
            runParams.put(AbilityKey.Cause, sa);
            runParams.put(AbilityKey.DiscardedBefore, discardedBefore.get(p));
            p.getGame().getTriggerHandler().runTrigger(TriggerType.DiscardedAll, runParams, false);
            if (!sa.hasParam("RememberDiscardingPlayers")) continue;
            sa.getHostCard().addRemembered(p);
        }
    }

    protected static void addUntilCommand(SpellAbility sa, GameCommand until) {
        SpellAbilityEffect.addUntilCommand(sa, until, sa.getActivatingPlayer());
    }

    protected static void addUntilCommand(SpellAbility sa, GameCommand until, Player controller) {
        SpellAbilityEffect.addUntilCommand(sa, until, sa.getParam("Duration"), controller);
    }

    protected static void addUntilCommand(SpellAbility sa, final GameCommand until, String duration, Player controller) {
        Card host = sa.getHostCard();
        final Game game = host.getGame();
        if (host.isLKI() || host.getZone() == null || host.getZone().is(ZoneType.Stack)) {
            host = game.getCardState(host);
        }
        if ("UntilEndOfCombat".equals(duration)) {
            game.getEndOfCombat().addUntil(until);
        } else if ("UntilEndOfCombatYourNextTurn".equals(duration)) {
            game.getEndOfCombat().registerUntilEnd(controller, until);
        } else if ("UntilYourNextUpkeep".equals(duration)) {
            game.getUpkeep().addUntil(controller, until);
        } else if ("UntilTheEndOfYourNextUpkeep".equals(duration)) {
            if (game.getPhaseHandler().is(PhaseType.UPKEEP)) {
                game.getUpkeep().registerUntilEnd(controller, until);
            } else {
                game.getUpkeep().addUntilEnd(controller, until);
            }
        } else if ("UntilNextEndStep".equals(duration)) {
            game.getEndOfTurn().addAt(until);
        } else if ("UntilYourNextEndStep".equals(duration)) {
            game.getEndOfTurn().addUntil(controller, until);
        } else if ("UntilYourNextTurn".equals(duration)) {
            game.getCleanup().addUntil(controller, until);
        } else if ("UntilTheEndOfYourNextTurn".equals(duration)) {
            if (game.getPhaseHandler().isPlayerTurn(controller)) {
                game.getEndOfTurn().registerUntilEnd(controller, until);
            } else {
                game.getEndOfTurn().addUntilEnd(controller, until);
            }
        } else if ("UntilTheEndOfTargetedNextTurn".equals(duration)) {
            Player targeted = sa.getTargets().getFirstTargetedPlayer();
            if (game.getPhaseHandler().isPlayerTurn(targeted)) {
                game.getEndOfTurn().registerUntilEnd(targeted, until);
            } else {
                game.getEndOfTurn().addUntilEnd(targeted, until);
            }
        } else if ("ThisTurnAndNextTurn".equals(duration)) {
            game.getEndOfTurn().addUntil(new GameCommand(){
                private static final long serialVersionUID = -5054153666503075717L;

                @Override
                public void run() {
                    game.getEndOfTurn().addUntil(until);
                }
            });
        } else if ("UntilStateBasedActionChecked".equals(duration)) {
            game.addSBACheckedCommand(until);
        } else if (duration != null && duration.startsWith("UntilAPlayerCastSpell")) {
            game.getStack().addCastCommand(duration.split(" ")[1], until);
        } else if ("UntilHostLeavesPlay".equals(duration)) {
            host.addLeavesPlayCommand(until);
        } else if ("UntilHostLeavesPlayOrEOT".equals(duration)) {
            host.addLeavesPlayCommand(until);
            game.getEndOfTurn().addUntil(until);
        } else if ("UntilHostLeavesPlayOrEndOfCombat".equals(duration)) {
            host.addLeavesPlayCommand(until);
            game.getEndOfCombat().addUntil(until);
        } else if ("UntilLoseControlOfHost".equals(duration)) {
            host.addLeavesPlayCommand(until);
            host.addChangeControllerCommand(until);
        } else if ("AsLongAsControl".equals(duration)) {
            host.addLeavesPlayCommand(until);
            host.addChangeControllerCommand(until);
            host.addPhaseOutCommand(until);
        } else if ("AsLongAsInPlay".equals(duration)) {
            host.addLeavesPlayCommand(until);
            host.addPhaseOutCommand(until);
        } else if ("UntilUntaps".equals(duration)) {
            host.addLeavesPlayCommand(until);
            host.addUntapCommand(until);
            host.addPhaseOutCommand(until);
        } else if ("UntilTargetedUntaps".equals(duration)) {
            Card tgt = sa.getSATargetingCard().getTargetCard();
            tgt.addLeavesPlayCommand(until);
            tgt.addUntapCommand(until);
        } else if ("UntilUnattached".equals(duration)) {
            host.addLeavesPlayCommand(until);
            host.addUnattachCommand(until);
            host.addPhaseOutCommand(until);
        } else if ("UntilFacedown".equals(duration)) {
            host.addFacedownCommand(until);
        } else {
            game.getEndOfTurn().addUntil(until);
        }
    }

    protected static boolean checkValidDuration(String duration, SpellAbility sa) {
        Card tgt;
        if (duration == null) {
            return true;
        }
        Card hostCard = sa.getHostCard();
        if ((duration.startsWith("UntilHostLeavesPlay") || "UntilLoseControlOfHost".equals(duration) || "UntilUntaps".equals(duration) || "AsLongAsControl".equals(duration) || "AsLongAsInPlay".equals(duration)) && !hostCard.isInPlay() && !hostCard.isInZone(ZoneType.Stack)) {
            return false;
        }
        if (("AsLongAsControl".equals(duration) || "AsLongAsInPlay".equals(duration)) && hostCard.isPhasedOut()) {
            return false;
        }
        if (("UntilLoseControlOfHost".equals(duration) || "ForAsLongAsControl".equals(duration)) && hostCard.getController() != sa.getActivatingPlayer()) {
            return false;
        }
        if ("UntilUntaps".equals(duration) && !hostCard.isTapped()) {
            return false;
        }
        return !"UntilTargetedUntaps".equals(sa.getParam("Duration")) || (tgt = sa.getSATargetingCard().getTargetCard()).isTapped() && !tgt.isPhasedOut();
    }

    public static Player getNewChooser(SpellAbility sa, Player activator, Player loser) {
        PlayerCollection options = loser.isOpponentOf(activator) ? activator.getOpponents() : activator.getAllOtherPlayers();
        return activator.getController().chooseSingleEntityForEffect(options, sa, Localizer.getInstance().getMessage("lblChoosePlayer", new Object[0]), null);
    }

    public static void handleExiledWith(Iterable<Card> movedCards, SpellAbility cause) {
        for (Card c : movedCards) {
            SpellAbilityEffect.handleExiledWith(c, cause);
        }
    }

    public static void handleExiledWith(Card movedCard, SpellAbility cause) {
        SpellAbilityEffect.handleExiledWith(movedCard, cause, cause.getHostCard());
    }

    public static void handleExiledWith(Card movedCard, SpellAbility cause, Card exilingSource) {
        if (movedCard.isToken()) {
            return;
        }
        if (cause.hasParam("ExiledWithEffectSource")) {
            exilingSource = exilingSource.getEffectSource();
        }
        if (cause.isReplacementAbility() && exilingSource.isLKI()) {
            exilingSource = exilingSource.getGame().getCardState(exilingSource);
        }
        if (exilingSource.isImmutable() || exilingSource.isInPlay() || exilingSource.isInZone(ZoneType.Stack) || exilingSource.isInZone(ZoneType.Command)) {
            exilingSource.removeExiledCard(movedCard);
            exilingSource.addExiledCard(movedCard);
        }
        if (cause.isCopiedTrait()) {
            exilingSource = cause.getOriginalHost();
        }
        movedCard.setExiledWith(exilingSource);
        movedCard.setExiledBy(cause.getActivatingPlayer());
    }

    public static GameCommand exileEffectCommand(final Game game, final Card effect) {
        return new GameCommand(){
            private static final long serialVersionUID = 1L;

            @Override
            public void run() {
                game.getAction().exileEffect(effect);
            }
        };
    }
}

