/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.card.CardStateName;
import forge.card.CardType;
import forge.game.CardTraitBase;
import forge.game.IHasSVars;
import forge.game.ability.AbilityApiBased;
import forge.game.ability.ApiType;
import forge.game.ability.SpellApiBased;
import forge.game.ability.StaticAbilityApiBased;
import forge.game.ability.effects.CharmEffect;
import forge.game.ability.effects.RollDiceEffect;
import forge.game.card.Card;
import forge.game.card.CardState;
import forge.game.cost.Cost;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityCondition;
import forge.game.spellability.SpellAbilityRestriction;
import forge.game.spellability.TargetRestrictions;
import forge.game.zone.ZoneType;
import forge.util.FileSection;
import io.sentry.Breadcrumb;
import io.sentry.Sentry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AbilityFactory {
    public static final List<String> additionalAbilityKeys = Lists.newArrayList("WinSubAbility", "OtherwiseSubAbility", "BidSubAbility", "ChooseNumberSubAbility", "Lowest", "Highest", "NotLowest", "GuessCorrect", "GuessWrong", "MatchedAbility", "UnmatchedAbility", "HeadsSubAbility", "TailsSubAbility", "LoseSubAbility", "TrueSubAbility", "FalseSubAbility", "ChosenPile", "UnchosenPile", "RepeatSubAbility", "Execute", "FallbackAbility", "ChooseSubAbility", "CantChooseSubAbility", "AnimateSubAbility", "RegenerationAbility", "ReturnAbility", "GiftAbility");

    public static SpellAbility getAbility(String abString, Card card) {
        return AbilityFactory.getAbility(abString, card.getCurrentState());
    }

    public static SpellAbility getAbility(String abString, Card card, IHasSVars sVarHolder) {
        return AbilityFactory.getAbility(abString, card.getCurrentState(), sVarHolder);
    }

    public static SpellAbility getAbility(String abString, CardState state) {
        return AbilityFactory.getAbility(abString, state, (IHasSVars)state);
    }

    private static SpellAbility getAbility(String abString, CardState state, IHasSVars sVarHolder) {
        Map<String, String> mapParams;
        try {
            mapParams = AbilityFactory.getMapParams(abString);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException(state.getName() + ": " + ex.getMessage());
        }
        AbilityRecordType type = AbilityRecordType.getRecordType(mapParams);
        if (null == type) {
            String source = state.getName().isEmpty() ? abString : state.getName();
            throw new RuntimeException("AbilityFactory : getAbility -- no API in " + source + ": " + abString);
        }
        try {
            return AbilityFactory.getAbility(mapParams, type, state, sVarHolder);
        }
        catch (Error | Exception ex) {
            String msg = "AbilityFactory:getAbility: crash when trying to create ability ";
            Breadcrumb bread = new Breadcrumb(msg);
            bread.setData("Card", state.getName());
            bread.setData("Ability", abString);
            Sentry.addBreadcrumb(bread);
            throw new RuntimeException(msg + " of card: " + state.getName(), ex);
        }
    }

    public static SpellAbility getAbility(Card hostCard, String svar) {
        return AbilityFactory.getAbility(hostCard, svar, (IHasSVars)hostCard.getCurrentState());
    }

    public static SpellAbility getAbility(Card hostCard, String svar, IHasSVars sVarHolder) {
        return AbilityFactory.getAbility(hostCard.getCurrentState(), svar, sVarHolder);
    }

    public static SpellAbility getAbility(CardState state, String svar, IHasSVars sVarHolder) {
        if (!sVarHolder.hasSVar(svar)) {
            String source = state.getCard().getName();
            throw new RuntimeException("AbilityFactory : getAbility -- " + source + " has no SVar: " + svar);
        }
        return AbilityFactory.getAbility(sVarHolder.getSVar(svar), state, sVarHolder);
    }

    public static SpellAbility getAbility(Map<String, String> mapParams, AbilityRecordType type, CardState state, IHasSVars sVarHolder) {
        return AbilityFactory.getAbility(type, type.getApiTypeOf(mapParams), mapParams, null, state, sVarHolder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Cost parseAbilityCost(CardState state, Map<String, String> mapParams, AbilityRecordType type) {
        Cost abCost = null;
        if (type == AbilityRecordType.SubAbility) return abCost;
        String cost = mapParams.get("Cost");
        if (cost != null) return new Cost(cost, type == AbilityRecordType.Ability);
        if (type != AbilityRecordType.Spell) throw new RuntimeException("AbilityFactory : getAbility -- no Cost in " + state.getName());
        SpellAbility firstAbility = state.getFirstAbility();
        if (firstAbility == null) return new Cost(state.getManaCost(), false);
        if (!firstAbility.isSpell()) return new Cost(state.getManaCost(), false);
        System.err.println(state.getName() + " already has Spell using mana cost");
        return new Cost(state.getManaCost(), false);
    }

    public static SpellAbility getAbility(AbilityRecordType type, ApiType api, Map<String, String> mapParams, Cost abCost, CardState state, IHasSVars sVarHolder) {
        String key;
        SpellAbility spellAbility;
        TargetRestrictions abTgt;
        Card hostCard = state.getCard();
        TargetRestrictions targetRestrictions = abTgt = mapParams.containsKey("ValidTgts") ? AbilityFactory.readTarget(mapParams) : null;
        if (api == ApiType.CopySpellAbility || api == ApiType.Counter || api == ApiType.ChangeTargets || api == ApiType.ControlSpell) {
            if (abTgt != null) {
                abTgt.setZone(ZoneType.Stack);
            }
        } else if (!(api != ApiType.PermanentCreature && api != ApiType.PermanentNoncreature || type != AbilityRecordType.Spell || mapParams.containsKey("SubAbility") || mapParams.containsKey("NonBasicSpell"))) {
            hostCard.clearFirstSpell();
        }
        if (abCost == null) {
            abCost = AbilityFactory.parseAbilityCost(state, mapParams, type);
        }
        if ((spellAbility = type.buildSpellAbility(api, hostCard, abCost, abTgt, mapParams)) == null) {
            StringBuilder msg = new StringBuilder();
            msg.append("AbilityFactory : SpellAbility was not created for ");
            msg.append(state.toString());
            msg.append(". Looking for API: ").append((Object)api);
            throw new RuntimeException(msg.toString());
        }
        if (sVarHolder instanceof CardState) {
            spellAbility.setCardState((CardState)sVarHolder);
        } else if (sVarHolder instanceof CardTraitBase) {
            spellAbility.setCardState(((CardTraitBase)sVarHolder).getCardState());
        } else {
            spellAbility.setCardState(state);
        }
        if (mapParams.containsKey("Forecast")) {
            spellAbility.putParam("ActivationZone", "Hand");
            spellAbility.putParam("ActivationLimit", "1");
            spellAbility.putParam("ActivationPhases", "Upkeep");
            spellAbility.putParam("PlayerTurn", "True");
            spellAbility.putParam("PrecostDesc", "Forecast \u2014 ");
        }
        if (mapParams.containsKey("Boast")) {
            spellAbility.putParam("PresentDefined", "Self");
            spellAbility.putParam("IsPresent", "Card.attackedThisTurn");
            spellAbility.putParam("PrecostDesc", "Boast \u2014 ");
        }
        if ((api == ApiType.DelayedTrigger || api == ApiType.ImmediateTrigger) && mapParams.containsKey("Execute")) {
            spellAbility.setSVar(mapParams.get("Execute"), sVarHolder.getSVar(mapParams.get("Execute")));
        }
        if (mapParams.containsKey("PreventionSubAbility")) {
            spellAbility.setSVar(mapParams.get("PreventionSubAbility"), sVarHolder.getSVar(mapParams.get("PreventionSubAbility")));
        }
        if (mapParams.containsKey("SubAbility")) {
            String name = mapParams.get("SubAbility");
            spellAbility.setSubAbility(AbilityFactory.getSubAbility(state, name, sVarHolder));
        }
        for (String key2 : additionalAbilityKeys) {
            if (!mapParams.containsKey(key2) || spellAbility.getAdditionalAbility(key2) != null) continue;
            spellAbility.setAdditionalAbility(key2, AbilityFactory.getAbility(state, mapParams.get(key2), sVarHolder));
        }
        if (api == ApiType.Charm || api == ApiType.GenericChoice || api == ApiType.AssignGroup || api == ApiType.VillainousChoice) {
            key = "Choices";
            if (mapParams.containsKey("Choices")) {
                ArrayList<String> names = Lists.newArrayList(mapParams.get("Choices").split(","));
                spellAbility.setAdditionalAbilityList("Choices", Lists.transform(names, input -> {
                    AbilitySub sub = AbilityFactory.getSubAbility(state, input, sVarHolder);
                    if (api == ApiType.GenericChoice) {
                        sub.setRestrictions(new SpellAbilityRestriction());
                        AbilityFactory.makeRestrictions(sub);
                    }
                    return sub;
                }));
            }
        }
        if (api == ApiType.RollDice) {
            key = "ResultSubAbilities";
            if (mapParams.containsKey("ResultSubAbilities")) {
                String[] diceAbilities;
                for (String ab : diceAbilities = mapParams.get("ResultSubAbilities").split(",")) {
                    String[] kv = ab.split(":");
                    spellAbility.setAdditionalAbility(kv[0], AbilityFactory.getSubAbility(state, kv[1], sVarHolder));
                }
            }
        }
        if (spellAbility instanceof SpellApiBased && hostCard.isPermanent()) {
            String desc = mapParams.getOrDefault("SpellDescription", spellAbility.getHostCard().getName());
            spellAbility.setDescription(desc);
        } else if (mapParams.containsKey("SpellDescription")) {
            spellAbility.rebuiltDescription();
        } else if (api == ApiType.Charm) {
            spellAbility.setDescription(CharmEffect.makeFormatedDescription(spellAbility));
        } else {
            spellAbility.setDescription("");
        }
        if (api == ApiType.RollDice) {
            spellAbility.setDescription(spellAbility.getDescription() + RollDiceEffect.makeFormatedDescription(spellAbility));
        } else if (api == ApiType.Repeat) {
            spellAbility.setDescription(spellAbility.getDescription() + spellAbility.getAdditionalAbility("RepeatSubAbility").getDescription());
        }
        AbilityFactory.initializeParams(spellAbility);
        AbilityFactory.makeRestrictions(spellAbility);
        AbilityFactory.makeConditions(spellAbility);
        return spellAbility;
    }

    private static TargetRestrictions readTarget(Map<String, String> mapParams) {
        String prompt;
        String min2 = mapParams.getOrDefault("TargetMin", "1");
        String max = mapParams.getOrDefault("TargetMax", "1");
        String tgtWhat = mapParams.get("ValidTgts");
        if (mapParams.containsKey("TgtPrompt")) {
            prompt = mapParams.get("TgtPrompt");
        } else if (tgtWhat.equals("Any")) {
            prompt = "Select any target";
        } else {
            String[] commonStuff = new String[]{"Player", "Opponent", "Card", "Spell", "Permanent"};
            if (Arrays.asList(commonStuff).contains(tgtWhat) || CardType.CoreType.isValidEnum(tgtWhat)) {
                tgtWhat = tgtWhat.toLowerCase();
            }
            prompt = "Select target " + tgtWhat;
        }
        TargetRestrictions abTgt = new TargetRestrictions(prompt, mapParams.get("ValidTgts").split(","), min2, max);
        if (mapParams.containsKey("TgtZone")) {
            abTgt.setZone(ZoneType.listValueOf(mapParams.get("TgtZone")));
        }
        if (mapParams.containsKey("MaxTotalTargetCMC")) {
            abTgt.setMaxTotalCMC(mapParams.get("MaxTotalTargetCMC"));
        }
        if (mapParams.containsKey("MaxTotalTargetPower")) {
            abTgt.setMaxTotalPower(mapParams.get("MaxTotalTargetPower"));
        }
        if (mapParams.containsKey("TargetValidTargeting")) {
            abTgt.setSAValidTargeting(mapParams.get("TargetValidTargeting"));
        }
        if (mapParams.containsKey("TargetUnique")) {
            abTgt.setUniqueTargets(true);
        }
        if (mapParams.containsKey("TargetsFromSingleZone")) {
            abTgt.setSingleZone(true);
        }
        if (mapParams.containsKey("TargetsWithoutSameCreatureType")) {
            abTgt.setWithoutSameCreatureType(true);
        }
        if (mapParams.containsKey("TargetsWithSameCreatureType")) {
            abTgt.setWithSameCreatureType(true);
        }
        if (mapParams.containsKey("TargetsWithSameCardType")) {
            abTgt.setWithSameCardType(true);
        }
        if (mapParams.containsKey("TargetsWithSameController")) {
            abTgt.setSameController(true);
        }
        if (mapParams.containsKey("TargetsWithDifferentControllers")) {
            abTgt.setDifferentControllers(true);
        }
        if (mapParams.containsKey("TargetsForEachPlayer")) {
            abTgt.setForEachPlayer(true);
        }
        if (mapParams.containsKey("TargetsWithDifferentCMC")) {
            abTgt.setDifferentCMC(true);
        }
        if (mapParams.containsKey("TargetsWithEqualToughness")) {
            abTgt.setEqualToughness(true);
        }
        if (mapParams.containsKey("TargetsAtRandom")) {
            abTgt.setRandomTarget(true);
        }
        if (mapParams.containsKey("RandomNumTargets")) {
            abTgt.setRandomNumTargets(true);
        }
        if (mapParams.containsKey("TargetingPlayer")) {
            abTgt.setMandatory(true);
        }
        return abTgt;
    }

    private static void initializeParams(SpellAbility sa) {
        if (sa.hasParam("NonBasicSpell")) {
            sa.setBasicSpell(false);
        }
    }

    private static void makeRestrictions(SpellAbility sa) {
        SpellAbilityRestriction restrict = sa.getRestrictions();
        if (restrict != null) {
            restrict.setRestrictions(sa.getMapParams());
        }
    }

    private static void makeConditions(SpellAbility sa) {
        SpellAbilityCondition condition = sa.getConditions();
        condition.setConditions(sa.getMapParams());
    }

    private static AbilitySub getSubAbility(CardState state, String sSub, IHasSVars sVarHolder) {
        if (sVarHolder.hasSVar(sSub)) {
            return (AbilitySub)AbilityFactory.getAbility(state, sSub, sVarHolder);
        }
        System.out.println("SubAbility '" + sSub + "' not found for: " + state.getName());
        return null;
    }

    public static Map<String, String> getMapParams(String abString) {
        return FileSection.parseToMap(abString, FileSection.DOLLAR_SIGN_KV_SEPARATOR);
    }

    public static void adjustChangeZoneTarget(Map<String, String> params, SpellAbility sa) {
        if (params.containsKey("Origin")) {
            List<ZoneType> origin = ZoneType.listValueOf(params.get("Origin"));
            TargetRestrictions tgt = sa.getTargetRestrictions();
            if (tgt != null && !tgt.canTgtPlayer()) {
                tgt.setZone(origin);
            }
        }
    }

    public static SpellAbility buildFusedAbility(Card card) {
        if (!card.isSplitCard()) {
            throw new IllegalStateException("Fuse ability may be built only on split cards");
        }
        CardState leftState = card.getState(CardStateName.LeftSplit);
        SpellAbility leftAbility = leftState.getFirstAbility();
        HashMap<String, String> leftMap = Maps.newHashMap(leftAbility.getMapParams());
        AbilityRecordType leftType = AbilityRecordType.getRecordType(leftMap);
        ApiType leftApi = leftType.getApiTypeOf(leftMap);
        leftMap.put("StackDescription", (String)leftMap.get("SpellDescription"));
        leftMap.put("SpellDescription", "Fuse (you may cast both halves of this card from your hand).");
        leftMap.put("ActivationZone", "Hand");
        CardState rightState = card.getState(CardStateName.RightSplit);
        SpellAbility rightAbility = rightState.getFirstAbility();
        HashMap<String, String> rightMap = Maps.newHashMap(rightAbility.getMapParams());
        AbilityRecordType rightType = AbilityRecordType.getRecordType(rightMap);
        ApiType rightApi = leftType.getApiTypeOf(rightMap);
        rightMap.put("StackDescription", (String)rightMap.get("SpellDescription"));
        rightMap.put("SpellDescription", "");
        Cost totalCost = AbilityFactory.parseAbilityCost(leftState, leftMap, leftType);
        totalCost.add(AbilityFactory.parseAbilityCost(rightState, rightMap, rightType));
        SpellAbility left = AbilityFactory.getAbility(leftType, leftApi, leftMap, totalCost, leftState, leftState);
        left.setCardState(card.getState(CardStateName.Original));
        AbilitySub right = (AbilitySub)AbilityFactory.getAbility(AbilityRecordType.SubAbility, rightApi, rightMap, null, rightState, rightState);
        left.appendSubAbility(right);
        return left;
    }

    public static enum AbilityRecordType {
        Ability("AB"),
        Spell("SP"),
        StaticAbility("ST"),
        SubAbility("DB");

        private final String prefix;

        private AbilityRecordType(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public SpellAbility buildSpellAbility(ApiType api, Card hostCard, Cost abCost, TargetRestrictions abTgt, Map<String, String> mapParams) {
            switch (this) {
                case Ability: {
                    return new AbilityApiBased(api, hostCard, abCost, abTgt, mapParams);
                }
                case Spell: {
                    return new SpellApiBased(api, hostCard, abCost, abTgt, mapParams);
                }
                case StaticAbility: {
                    return new StaticAbilityApiBased(api, hostCard, abCost, abTgt, mapParams);
                }
                case SubAbility: {
                    return new AbilitySub(api, hostCard, abTgt, mapParams);
                }
            }
            return null;
        }

        public ApiType getApiTypeOf(Map<String, String> abParams) {
            return ApiType.smartValueOf(abParams.get(this.getPrefix()));
        }

        public static AbilityRecordType getRecordType(Map<String, String> abParams) {
            if (abParams.containsKey(Ability.getPrefix())) {
                return Ability;
            }
            if (abParams.containsKey(Spell.getPrefix())) {
                return Spell;
            }
            if (abParams.containsKey(StaticAbility.getPrefix())) {
                return StaticAbility;
            }
            if (abParams.containsKey(SubAbility.getPrefix())) {
                return SubAbility;
            }
            return null;
        }
    }
}

