/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import forge.game.CardTraitBase;
import forge.game.IIdentifiable;
import forge.game.card.Card;
import forge.game.card.CardState;
import forge.game.keyword.KeywordInterface;
import forge.game.spellability.SpellAbility;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public abstract class TriggerReplacementBase
extends CardTraitBase
implements IIdentifiable,
Cloneable {
    protected EnumSet<ZoneType> validHostZones;
    private SpellAbility overridingAbility = null;

    @Override
    public void setHostCard(Card c) {
        super.setHostCard(c);
        if (this.overridingAbility != null) {
            this.overridingAbility.setHostCard(c);
        }
    }

    @Override
    public void setKeyword(KeywordInterface kw) {
        super.setKeyword(kw);
        if (this.overridingAbility != null) {
            this.overridingAbility.setKeyword(kw);
        }
    }

    @Override
    public void setCardState(CardState state) {
        super.setCardState(state);
        if (this.overridingAbility != null) {
            this.overridingAbility.setCardState(state);
        }
    }

    public Set<ZoneType> getActiveZone() {
        return this.validHostZones;
    }

    public void setActiveZone(EnumSet<ZoneType> zones) {
        this.validHostZones = zones;
    }

    public final boolean zonesCheck(Zone hostCardZone) {
        return !this.hostCard.isPhasedOut() && (this.validHostZones == null || this.validHostZones.isEmpty() || hostCardZone != null && this.validHostZones.contains((Object)hostCardZone.getZoneType()));
    }

    public SpellAbility getOverridingAbility() {
        return this.overridingAbility;
    }

    public void setOverridingAbility(SpellAbility overridingAbility0) {
        this.overridingAbility = overridingAbility0;
        overridingAbility0.setIntrinsic(this.intrinsic);
    }

    public abstract SpellAbility ensureAbility();

    @Override
    public void changeText() {
        if (!this.isIntrinsic()) {
            return;
        }
        super.changeText();
        SpellAbility sa = this.ensureAbility();
        if (sa != null) {
            sa.changeText();
        }
    }

    @Override
    public void changeTextIntrinsic(Map<String, String> colorMap, Map<String, String> typeMap) {
        super.changeTextIntrinsic(colorMap, typeMap);
        SpellAbility sa = this.ensureAbility();
        if (sa != null) {
            sa.changeTextIntrinsic(colorMap, typeMap);
        }
    }
}

