/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.eventbus.EventBus;
import forge.LobbyPlayer;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckFormat;
import forge.deck.DeckSection;
import forge.game.Game;
import forge.game.GameLogEntryType;
import forge.game.GameOutcome;
import forge.game.GameRules;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.event.Event;
import forge.game.event.GameEventAnteCardsSelected;
import forge.game.event.GameEventGameFinished;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerController;
import forge.game.player.RegisteredPlayer;
import forge.game.trigger.Trigger;
import forge.game.zone.PlayerZone;
import forge.game.zone.ZoneType;
import forge.item.PaperCard;
import forge.util.Localizer;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Match {
    private static List<PaperCard> removedCards = Lists.newArrayList();
    private final List<RegisteredPlayer> players;
    private final GameRules rules;
    private final String title;
    private final EventBus events = new EventBus("match events");
    private final Map<Integer, GameOutcome> gameOutcomes = Maps.newHashMap();
    private GameOutcome lastOutcome = null;

    public Match(GameRules rules0, List<RegisteredPlayer> players0, String title) {
        this.players = Collections.unmodifiableList(Lists.newArrayList(players0));
        this.rules = rules0;
        this.title = title;
    }

    public GameRules getRules() {
        return this.rules;
    }

    String getTitle() {
        Multiset<RegisteredPlayer> wins = this.getGamesWon();
        StringBuilder titleAppend = new StringBuilder(this.title);
        titleAppend.append(" (");
        for (RegisteredPlayer rp : this.players) {
            titleAppend.append(wins.count(rp)).append('-');
        }
        titleAppend.deleteCharAt(titleAppend.length() - 1);
        titleAppend.append(')');
        return titleAppend.toString();
    }

    public void addGamePlayed(Game finished) {
        if (!finished.isGameOver()) {
            throw new IllegalStateException("Game is not over yet.");
        }
        this.lastOutcome = finished.getOutcome();
        this.gameOutcomes.put(finished.getId(), finished.getOutcome());
    }

    public Game createGame() {
        return new Game(this.players, this.rules, this);
    }

    public void startGame(Game game) {
        this.startGame(game, null);
    }

    public void startGame(Game game, Runnable startGameHook) {
        this.prepareAllZones(game);
        if (this.rules.useAnte()) {
            Multimap<Player, Card> list = game.chooseCardsForAnte(this.rules.getMatchAnteRarity());
            for (Map.Entry<Player, Card> kv : list.entries()) {
                Player p = kv.getKey();
                game.getAction().moveTo(ZoneType.Ante, kv.getValue(), null, AbilityKey.newMap());
                game.getGameLog().add(GameLogEntryType.ANTE, p + " anted " + kv.getValue());
            }
            game.fireEvent(new GameEventAnteCardsSelected(list));
        }
        game.getAction().startGame(this.lastOutcome, startGameHook);
        if (this.rules.useAnte()) {
            this.executeAnte(game);
        }
        game.clearCaches();
        game.fireEvent(new GameEventGameFinished());
        System.gc();
    }

    public GameOutcome getOutcomeById(int id) {
        return this.gameOutcomes.get(id);
    }

    public void clearGamesPlayed() {
        this.gameOutcomes.clear();
        for (RegisteredPlayer p : this.players) {
            p.restoreDeck();
        }
    }

    public Collection<GameOutcome> getOutcomes() {
        return this.gameOutcomes.values();
    }

    public GameOutcome getLastOutcome() {
        return this.lastOutcome;
    }

    public boolean isMatchOver() {
        int[] victories = new int[this.players.size()];
        for (GameOutcome go : this.getOutcomes()) {
            LobbyPlayer winner = go.getWinningLobbyPlayer();
            int i = 0;
            for (RegisteredPlayer p : this.players) {
                if (p.getPlayer().equals(winner)) {
                    int n = i;
                    victories[n] = victories[n] + 1;
                    if (victories[i] >= this.rules.getGamesToWinMatch()) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public int getGamesWonBy(LobbyPlayer questPlayer) {
        int sum = 0;
        for (GameOutcome go : this.getOutcomes()) {
            if (!questPlayer.equals(go.getWinningLobbyPlayer())) continue;
            ++sum;
        }
        return sum;
    }

    public Multiset<RegisteredPlayer> getGamesWon() {
        HashMultiset<RegisteredPlayer> won = HashMultiset.create(this.players.size());
        for (GameOutcome go : this.getOutcomes()) {
            if (go.getWinningPlayer() == null) {
                return won;
            }
            won.add(go.getWinningPlayer());
        }
        return won;
    }

    public boolean isWonBy(LobbyPlayer questPlayer) {
        return this.getGamesWonBy(questPlayer) >= this.rules.getGamesToWinMatch();
    }

    public RegisteredPlayer getWinner() {
        if (this.isMatchOver()) {
            return this.lastOutcome.getWinningPlayer();
        }
        return null;
    }

    public List<RegisteredPlayer> getPlayers() {
        return this.players;
    }

    private static Set<PaperCard> getRemovedAnteCards(Deck toUse) {
        String keywordToRemove = "Remove CARDNAME from your deck before playing if you're not playing for ante.";
        HashSet<PaperCard> myRemovedAnteCards = new HashSet<PaperCard>();
        for (Map.Entry<DeckSection, CardPool> ds : toUse) {
            for (Map.Entry cp : ds.getValue()) {
                if (!Iterables.contains(((PaperCard)cp.getKey()).getRules().getMainPart().getKeywords(), "Remove CARDNAME from your deck before playing if you're not playing for ante.")) continue;
                myRemovedAnteCards.add((PaperCard)cp.getKey());
            }
        }
        return myRemovedAnteCards;
    }

    public static List<PaperCard> getRemovedCards() {
        return removedCards;
    }

    public void removeCard(PaperCard c) {
        removedCards.add(c);
    }

    private static void preparePlayerZone(Player player, ZoneType zoneType, CardPool section, boolean canRandomFoil) {
        PlayerZone library = player.getZone(zoneType);
        ArrayList<Card> newLibrary = new ArrayList<Card>();
        for (Map.Entry stackOfCards : section) {
            PaperCard cp = (PaperCard)stackOfCards.getKey();
            for (int i = 0; i < stackOfCards.getValue(); ++i) {
                Card card = Card.fromPaperCard(cp, player);
                if (cp.isFoil() || canRandomFoil && MyRandom.percentTrue(5)) {
                    card.setRandomFoil();
                }
                card.setCollectible(true);
                newLibrary.add(card);
            }
        }
        library.setCards(newLibrary);
    }

    private void prepareAllZones(Game game) {
        Player player;
        int i;
        Trigger.resetIDs();
        game.getTriggerHandler().clearDelayedTrigger();
        HashMap<Player, Map<DeckSection, List<? extends PaperCard>>> rAICards = new HashMap<Player, Map<DeckSection, List<? extends PaperCard>>>();
        ArrayListMultimap<Player, PaperCard> removedAnteCards = ArrayListMultimap.create();
        PlayerCollection players = game.getPlayers();
        List<RegisteredPlayer> playersConditions = game.getMatch().getPlayers();
        boolean isFirstGame = this.gameOutcomes.isEmpty();
        boolean canSideBoard = !isFirstGame && this.rules.getGameType().isSideboardingAllowed();
        boolean sideboardForAIs = this.rules.getSideboardForAI() && this.rules.getGameType().getDeckFormat().equals((Object)DeckFormat.Constructed);
        PlayerController sideboardProxy = null;
        if (canSideBoard && sideboardForAIs) {
            for (i = 0; i < players.size(); ++i) {
                player = (Player)players.get(i);
                if (player.getController().isAI()) continue;
                sideboardProxy = player.getController();
                break;
            }
        }
        for (i = 0; i < playersConditions.size(); ++i) {
            player = (Player)players.get(i);
            RegisteredPlayer psc = playersConditions.get(i);
            PlayerController person = player.getController();
            if (canSideBoard) {
                List<PaperCard> newMain;
                if (sideboardProxy != null && person.isAI()) {
                    person = sideboardProxy;
                }
                Deck toChange = psc.getDeck();
                if (!Match.getRemovedCards().isEmpty()) {
                    CardPool main = new CardPool();
                    main.addAll(toChange.get(DeckSection.Main));
                    CardPool sideboard = new CardPool();
                    sideboard.addAll(toChange.getOrCreate(DeckSection.Sideboard));
                    for (PaperCard c : removedCards) {
                        if (main.contains(c)) {
                            main.remove(c, 1);
                            continue;
                        }
                        if (!sideboard.contains(c)) continue;
                        sideboard.remove(c, 1);
                    }
                    toChange.getMain().clear();
                    toChange.getMain().addAll(main);
                    toChange.get(DeckSection.Sideboard).clear();
                    toChange.get(DeckSection.Sideboard).addAll(sideboard);
                }
                if (null != (newMain = person.sideboard(toChange, this.rules.getGameType(), player.getName()))) {
                    CardPool allCards = new CardPool();
                    allCards.addAll(toChange.get(DeckSection.Main));
                    allCards.addAll(toChange.getOrCreate(DeckSection.Sideboard));
                    for (PaperCard c : newMain) {
                        allCards.remove(c);
                    }
                    toChange.getMain().clear();
                    toChange.getMain().add((Iterable<PaperCard>)newMain);
                    toChange.get(DeckSection.Sideboard).clear();
                    toChange.get(DeckSection.Sideboard).addAll(allCards);
                }
            }
            Deck myDeck = psc.getDeck();
            player.setDraftNotes(myDeck.getDraftNotes());
            Set<PaperCard> myRemovedAnteCards = null;
            if (!this.rules.useAnte()) {
                myRemovedAnteCards = Match.getRemovedAnteCards(myDeck);
                for (PaperCard cp : myRemovedAnteCards) {
                    for (Map.Entry<DeckSection, CardPool> ds : myDeck) {
                        ds.getValue().removeAll(cp);
                    }
                }
            }
            Match.preparePlayerZone(player, ZoneType.Library, myDeck.getMain(), psc.useRandomFoil());
            if (myDeck.has(DeckSection.Sideboard)) {
                Match.preparePlayerZone(player, ZoneType.Sideboard, myDeck.get(DeckSection.Sideboard), psc.useRandomFoil());
                Card companion = player.assignCompanion(game, person);
                if (companion != null) {
                    PlayerZone commandZone = player.getZone(ZoneType.Command);
                    companion = game.getAction().moveTo(ZoneType.Command, companion, null, AbilityKey.newMap());
                    commandZone.add(Player.createCompanionEffect(game, companion));
                    player.updateZoneForView(commandZone);
                }
            }
            player.initVariantsZones(psc);
            player.shuffle(null);
            if (isFirstGame) {
                Map<DeckSection, List<? extends PaperCard>> cardsComplained = player.getController().complainCardsCantPlayWell(myDeck);
                if (cardsComplained != null && !cardsComplained.isEmpty()) {
                    rAICards.put(player, cardsComplained);
                }
            } else {
                for (Card c : player.getCardsIn(ZoneType.Library)) {
                    c.setTapped(false);
                    c.resetActivationsPerTurn();
                }
            }
            if (myRemovedAnteCards == null || myRemovedAnteCards.isEmpty()) continue;
            removedAnteCards.putAll(player, myRemovedAnteCards);
        }
        Localizer localizer = Localizer.getInstance();
        if (!rAICards.isEmpty() && !this.rules.getGameType().isCardPoolLimited() && this.rules.warnAboutAICards()) {
            game.getAction().revealUnplayableByAI(localizer.getMessage("lblAICantPlayCards", new Object[0]), rAICards);
        }
        if (!removedAnteCards.isEmpty()) {
            game.getAction().revealAnte(localizer.getMessage("lblAnteCardsRemoved", new Object[0]), removedAnteCards);
        }
    }

    private void executeAnte(Game lastGame) {
        GameOutcome outcome = lastGame.getOutcome();
        ArrayList<PaperCard> losses = new ArrayList<PaperCard>();
        int cntPlayers = this.players.size();
        int iWinner = -1;
        for (int i = 0; i < cntPlayers; ++i) {
            Player fromGame = (Player)lastGame.getRegisteredPlayers().get(i);
            RegisteredPlayer registered = fromGame.getRegisteredPlayer();
            CardCollectionView lostOwnership = fromGame.getLostOwnership();
            CardCollectionView gainedOwnership = fromGame.getGainedOwnership();
            if (!lostOwnership.isEmpty()) {
                ArrayList<PaperCard> lostPaperOwnership = new ArrayList<PaperCard>();
                for (Card c : lostOwnership) {
                    lostPaperOwnership.add((PaperCard)c.getPaperCard());
                }
                outcome.addAnteLost(registered, lostPaperOwnership);
            }
            if (!gainedOwnership.isEmpty()) {
                ArrayList<PaperCard> gainedPaperOwnership = new ArrayList<PaperCard>();
                for (Card c : gainedOwnership) {
                    gainedPaperOwnership.add((PaperCard)c.getPaperCard());
                }
                outcome.addAnteWon(registered, gainedPaperOwnership);
            }
            if (outcome.isDraw()) continue;
            if (!fromGame.hasLost()) {
                iWinner = i;
                continue;
            }
            Deck losersDeck = this.players.get(i).getDeck();
            ArrayList<PaperCard> personalLosses = new ArrayList<PaperCard>();
            for (Card c : fromGame.getCardsIn(ZoneType.Ante)) {
                if (!c.isCollectible()) continue;
                PaperCard toRemove = (PaperCard)c.getPaperCard();
                losersDeck.getMain().remove(toRemove);
                personalLosses.add(toRemove);
                losses.add(toRemove);
            }
            outcome.addAnteLost(registered, personalLosses);
        }
        if (iWinner >= 0) {
            List<PaperCard> chosen;
            Player fromGame = (Player)lastGame.getRegisteredPlayers().get(iWinner);
            RegisteredPlayer registered = fromGame.getRegisteredPlayer();
            outcome.addAnteWon(registered, losses);
            if (this.rules.getGameType().canAddWonCardsMidGame() && null != (chosen = fromGame.getController().chooseCardsYouWonToAddToDeck(losses))) {
                Deck deck = this.players.get(iWinner).getDeck();
                for (PaperCard c : chosen) {
                    deck.getMain().add(c);
                }
            }
        }
    }

    public void fireEvent(Event event) {
        this.events.post(event);
    }

    public void subscribeToEvents(Object subscriber) {
        this.events.register(subscriber);
    }
}

